/*
 * Decompiled with CFR 0.152.
 */
package kala.control;

import java.io.Serializable;
import java.util.function.Supplier;
import kala.control.AnyOption;
import kala.control.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnyTry<T>
implements Serializable {
    protected static final int SUCCESS_HASH_MAGIC = 518848667;
    protected static final int FAILURE_HASH_MAGIC = 1918688519;

    public abstract boolean isSuccess();

    public abstract boolean isFailure();

    public abstract T getValue();

    @Nullable
    public abstract T getOrNull();

    public abstract AnyOption<T> getOption();

    @NotNull
    public abstract Throwable getCause();

    @Nullable
    public Throwable getCauseOrNull() {
        return this.isFailure() ? this.getCause() : null;
    }

    @NotNull
    public Option<Throwable> getCauseOption() {
        return this.isFailure() ? Option.some(this.getCause()) : Option.none();
    }

    public Throwable getCauseOrDefault(Throwable defaultValue) {
        return this.isFailure() ? this.getCause() : defaultValue;
    }

    public Throwable getCauseOrElse(@NotNull Supplier<? extends Throwable> supplier) {
        return this.isFailure() ? this.getCause() : supplier.get();
    }

    @NotNull
    public abstract <Ex extends Throwable> AnyTry<T> rethrow() throws Ex;

    @NotNull
    public abstract <Ex extends Throwable> AnyTry<T> rethrow(@NotNull Class<? extends Ex> var1) throws Ex;

    @NotNull
    public abstract AnyTry<T> rethrowFatal();
}

