/*
 * Decompiled with CFR 0.152.
 */
package kala.control;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import kala.control.Option;
import kala.control.OptionContainer;
import kala.control.Result;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class Either<A, B>
implements Serializable {
    Either() {
    }

    @Contract(value="_ -> param1", pure=true)
    public static <A, B> Either<A, B> narrow(Either<? extends A, ? extends B> either) {
        return either;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <A, B> Left<A, B> narrow(Left<? extends A, ? extends B> left) {
        return left;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <A, B> Right<A, B> narrow(Right<? extends A, ? extends B> right) {
        return right;
    }

    @Contract(value="_ -> new")
    public static <A, B> @NotNull Left<A, B> left(A value) {
        return new Left(value);
    }

    @Contract(value="_ -> new")
    public static <A, B> @NotNull Right<A, B> right(B value) {
        return new Right(value);
    }

    public static <T> T join(@NotNull Either<? extends T, ? extends T> either) {
        if (either.isLeft()) {
            return either.getLeftValue();
        }
        return either.getRightValue();
    }

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public abstract A getLeftValue();

    @NotNull
    public abstract Option<A> getLeftOption();

    public abstract B getRightValue();

    @NotNull
    public abstract Option<B> getRightOption();

    @NotNull
    public abstract <U, V> Either<U, V> map(@NotNull Function<? super A, ? extends U> var1, @NotNull Function<? super B, ? extends V> var2);

    @NotNull
    public abstract <U> Either<U, B> mapLeft(@NotNull Function<? super A, ? extends U> var1);

    @NotNull
    public abstract <U> Either<A, U> mapRight(@NotNull Function<? super B, ? extends U> var1);

    public abstract <U> U fold(@NotNull Function<? super A, ? extends U> var1, @NotNull Function<? super B, ? extends U> var2);

    @Contract(value="-> new")
    @NotNull
    public abstract Either<B, A> swap();

    @Contract(value="-> new")
    @NotNull
    public abstract Result<B, A> toResult();

    @Contract(value=" -> new")
    @NotNull
    public final LeftProjection leftProjection() {
        return new LeftProjection();
    }

    @Contract(value=" -> new")
    @NotNull
    public final RightProjection rightProjection() {
        return new RightProjection();
    }

    public abstract void forEach(@NotNull Consumer<? super A> var1, @NotNull Consumer<? super B> var2);

    public static final class Left<A, B>
    extends Either<A, B> {
        private static final long serialVersionUID = -1160729620210301179L;
        private static final int HASH_MAGIC = -1951578063;
        private final A value;

        Left(A value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public A getLeftValue() {
            return this.value;
        }

        @Override
        @NotNull
        public Option<A> getLeftOption() {
            return Option.some(this.value);
        }

        @Override
        @Contract(value="-> fail")
        public B getRightValue() {
            throw new NoSuchElementException("Either.Left.getRightValue");
        }

        @Override
        @NotNull
        public Option<B> getRightOption() {
            return Option.none();
        }

        @Override
        @NotNull
        public <U, V> Either<U, V> map(@NotNull Function<? super A, ? extends U> leftMapper, @NotNull Function<? super B, ? extends V> rightMapper) {
            return Either.left(leftMapper.apply(this.value));
        }

        @Override
        @NotNull
        public <U> Either<U, B> mapLeft(@NotNull Function<? super A, ? extends U> mapper) {
            Objects.requireNonNull(mapper);
            return Either.left(mapper.apply(this.value));
        }

        @Override
        @NotNull
        public <U> Either<A, U> mapRight(@NotNull Function<? super B, ? extends U> mapper) {
            return this;
        }

        @Override
        public <U> U fold(@NotNull Function<? super A, ? extends U> leftMapper, @NotNull Function<? super B, ? extends U> rightMapper) {
            return leftMapper.apply(this.value);
        }

        @Override
        @NotNull
        public Either<B, A> swap() {
            return Either.right(this.value);
        }

        @Override
        @NotNull
        public Result<B, A> toResult() {
            return Result.err(this.value);
        }

        @Override
        public void forEach(@NotNull Consumer<? super A> leftConsumer, @NotNull Consumer<? super B> rightConsumer) {
            leftConsumer.accept(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Left)) {
                return false;
            }
            return Objects.equals(this.value, ((Left)obj).value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value) + -1951578063;
        }

        public String toString() {
            return "Either.Left[" + this.value + "]";
        }
    }

    public static final class Right<A, B>
    extends Either<A, B> {
        private static final long serialVersionUID = -3372589401685464421L;
        private static final int HASH_MAGIC = 1973604283;
        private final B value;

        Right(B value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        @Contract(value="-> fail")
        public A getLeftValue() {
            throw new NoSuchElementException("Either.Right.getLeftValue");
        }

        @Override
        @NotNull
        public Option<A> getLeftOption() {
            return Option.none();
        }

        @Override
        public B getRightValue() {
            return this.value;
        }

        @Override
        @NotNull
        public Option<B> getRightOption() {
            return Option.none();
        }

        @Override
        @NotNull
        public <U, V> Either<U, V> map(@NotNull Function<? super A, ? extends U> leftMapper, @NotNull Function<? super B, ? extends V> rightMapper) {
            return Either.right(rightMapper.apply(this.value));
        }

        @Override
        @NotNull
        public <U> Either<U, B> mapLeft(@NotNull Function<? super A, ? extends U> mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> Either<A, U> mapRight(@NotNull Function<? super B, ? extends U> mapper) {
            Objects.requireNonNull(mapper);
            return Either.right(mapper.apply(this.value));
        }

        @Override
        public <U> U fold(@NotNull Function<? super A, ? extends U> leftMapper, @NotNull Function<? super B, ? extends U> rightMapper) {
            return rightMapper.apply(this.value);
        }

        @Override
        @NotNull
        public Either<B, A> swap() {
            return Either.left(this.value);
        }

        @Override
        @NotNull
        public Result<B, A> toResult() {
            return Result.ok(this.value);
        }

        @Override
        public void forEach(@NotNull Consumer<? super A> leftConsumer, @NotNull Consumer<? super B> rightConsumer) {
            rightConsumer.accept(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Right)) {
                return false;
            }
            return Objects.equals(this.value, ((Right)obj).value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value) + 1973604283;
        }

        public String toString() {
            return "Either.Right[" + this.value + "]";
        }
    }

    public final class LeftProjection
    extends Projection<A> {
        @Override
        public boolean isDefined() {
            return Either.this.isLeft();
        }

        @Override
        public A get() {
            return Either.this.getLeftValue();
        }

        @NotNull
        public <U> LeftProjection map(@NotNull Function<? super A, ? extends U> mapper) {
            Objects.requireNonNull(mapper);
            if (this.isDefined()) {
                return Either.left(mapper.apply(Either.this.getLeftValue())).new LeftProjection();
            }
            return this;
        }

        @NotNull
        public String toString() {
            return Either.this + ".LeftProjection";
        }
    }

    public final class RightProjection
    extends Projection<B> {
        @Override
        public boolean isDefined() {
            return Either.this.isRight();
        }

        @Override
        public B get() {
            return Either.this.getRightValue();
        }

        @NotNull
        public <U> RightProjection map(@NotNull Function<? super B, ? extends U> mapper) {
            Objects.requireNonNull(mapper);
            if (this.isDefined()) {
                return Either.right(mapper.apply(Either.this.getRightValue())).new RightProjection();
            }
            return this;
        }

        @NotNull
        public String toString() {
            return Either.this + ".RightProjection";
        }
    }

    public abstract class Projection<T>
    implements OptionContainer<T> {
        private static final int HASH_MAGIC = 905770825;

        Projection() {
        }

        @NotNull
        public final Either<A, B> getEither() {
            return Either.this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Either.this.equals(((Projection)o).getEither());
        }

        public final int hashCode() {
            return Either.this.hashCode() + 905770825;
        }
    }
}

