/*
 * Decompiled with CFR 0.152.
 */
package kala.control;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kala.collection.base.Iterators;
import kala.collection.base.Traversable;
import kala.control.AnyTry;
import kala.control.Either;
import kala.control.Option;
import kala.control.Result;
import kala.function.CheckedBiFunction;
import kala.function.CheckedFunction;
import kala.function.CheckedRunnable;
import kala.function.CheckedSupplier;
import kala.function.CheckedTriFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Try<T>
extends AnyTry<T>
implements Traversable<T>,
Serializable {
    private static final long serialVersionUID = -876749736621195838L;
    public static final Try<Void> VOID = new Try<Object>(null, null);
    private final T value;
    private final Throwable cause;

    private Try(T value, Throwable cause) {
        this.value = value;
        this.cause = cause;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T> Try<T> narrow(Try<? extends T> t) {
        return t;
    }

    public static <Ex extends Throwable> void maybeThrows() throws Ex {
    }

    @Contract(value="_ -> fail")
    public static <R, Ex extends Throwable> R throwException(Ex exception) throws Ex {
        throw exception;
    }

    @Contract(value="_ -> fail")
    public static <R> R sneakyThrow(Throwable exception) {
        Try.sneakyThrow0(exception);
        throw new AssertionError();
    }

    private static <Ex extends Throwable> void sneakyThrow0(Throwable exception) throws Ex {
        throw exception;
    }

    public static String getStackTraceAsString(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
            try (PrintStream stream = new PrintStream((OutputStream)buffer, false, "UTF-8");){
                exception.printStackTrace(stream);
            }
            return buffer.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e);
        }
    }

    public static String getStackTraceAsString(StackTraceElement @NotNull [] stackTrace) {
        StringBuilder builder = new StringBuilder(4096);
        String lineSeparator = System.getProperty("line.separator");
        for (StackTraceElement traceElement : stackTrace) {
            builder.append("\tat ").append(traceElement).append(lineSeparator);
        }
        return builder.toString();
    }

    public static String getStackTraceAsString(@NotNull Iterable<StackTraceElement> stackTrace) {
        StringBuilder builder = new StringBuilder(4096);
        String lineSeparator = System.getProperty("line.separator");
        for (StackTraceElement traceElement : stackTrace) {
            builder.append("\tat ").append(traceElement).append(lineSeparator);
        }
        return builder.toString();
    }

    public static boolean isFatal(Throwable exception) {
        return exception instanceof InterruptedException || exception instanceof LinkageError || exception instanceof ThreadDeath || exception instanceof VirtualMachineError;
    }

    @NotNull
    public static <T> Try<T> success(T value) {
        return new Try<T>(value, null);
    }

    @NotNull
    public static <T> Try<T> failure(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        return new Try<Object>(null, exception);
    }

    @NotNull
    public static <T> Try<T> of(@NotNull CheckedSupplier<? extends T, ?> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return Try.success(supplier.getChecked());
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    @NotNull
    public static <T> Try<T> ofCallable(@NotNull Callable<? extends T> callable) {
        Objects.requireNonNull(callable);
        try {
            return Try.success(callable.call());
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    @Deprecated
    @NotNull
    public static Try<Void> run(@NotNull CheckedRunnable<?> runnable) {
        return Try.runCatching(runnable);
    }

    @NotNull
    public static Try<Void> runCatching(@NotNull CheckedRunnable<?> runnable) {
        Objects.requireNonNull(runnable);
        try {
            runnable.runChecked();
            return VOID;
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    @NotNull
    public static Try<Void> runRunnable(@NotNull Runnable runnable) {
        Objects.requireNonNull(runnable);
        try {
            runnable.run();
            return VOID;
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    public static void runIgnoreException(@NotNull CheckedRunnable<?> runnable) {
        Objects.requireNonNull(runnable);
        try {
            runnable.runChecked();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void runUnchecked(@NotNull CheckedRunnable<?> runnable) {
        runnable.run();
    }

    @NotNull
    public static <U, R0 extends AutoCloseable> Try<U> using(R0 resource0, @NotNull CheckedFunction<? super R0, ? extends U, ?> action) {
        Try<U> try_;
        block8: {
            Objects.requireNonNull(action);
            R0 r0 = resource0;
            try {
                try_ = Try.success(action.applyChecked(resource0));
                if (r0 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r0 != null) {
                        try {
                            r0.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    return Try.failure(ex);
                }
            }
            r0.close();
        }
        return try_;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <U, R0 extends AutoCloseable, R1 extends AutoCloseable> Try<U> using(R0 resource0, R1 resource1, @NotNull CheckedBiFunction<? super R0, ? super R1, ? extends U, ?> action) {
        Objects.requireNonNull(action);
        try (R0 r0 = resource0;){
            Try<R1> try_;
            block14: {
                R1 r1 = resource1;
                try {
                    try_ = Try.success(action.applyChecked(resource0, resource1));
                    if (r1 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (r1 != null) {
                        try {
                            r1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                r1.close();
            }
            return try_;
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public static <U, R0 extends AutoCloseable, R1 extends AutoCloseable, R2 extends AutoCloseable> Try<U> using(R0 resource0, R1 resource1, R2 resource2, @NotNull CheckedTriFunction<? super R0, ? super R1, ? super R2, ? extends U, ?> action) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isSuccess() {
        return this.cause == null;
    }

    @Override
    public boolean isFailure() {
        return this.cause != null;
    }

    @Override
    @Deprecated
    public T getValue() {
        return this.get();
    }

    public T get() {
        if (this.isFailure()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    @Override
    @Nullable
    public T getOrNull() {
        return this.value;
    }

    @Override
    @NotNull
    public Option<T> getOption() {
        return this.isSuccess() ? Option.some(this.value) : Option.none();
    }

    public T getOrDefault(T defaultValue) {
        return this.isSuccess() ? this.value : defaultValue;
    }

    public T getOrElse(@NotNull Supplier<? extends T> supplier) {
        return this.isSuccess() ? this.value : supplier.get();
    }

    public <Ex extends Throwable> T getOrThrow() throws Ex {
        if (this.isFailure()) {
            throw this.cause;
        }
        return this.value;
    }

    public <Ex extends Throwable> T getOrThrow(@NotNull Supplier<? extends Ex> supplier) throws Ex {
        if (this.isFailure()) {
            throw (Throwable)supplier.get();
        }
        return this.value;
    }

    public <Ex extends Throwable> T getOrThrowException(Ex exception) throws Ex {
        if (this.isFailure()) {
            throw exception;
        }
        return this.value;
    }

    @Override
    @NotNull
    public Throwable getCause() {
        if (this.isSuccess()) {
            throw new UnsupportedOperationException();
        }
        return this.cause;
    }

    @NotNull
    public Try<T> recover(@NotNull CheckedFunction<? super Throwable, ? extends T, ?> op) {
        Objects.requireNonNull(op);
        if (this.isSuccess()) {
            return this;
        }
        try {
            return Try.success(op.applyChecked(this.cause));
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    @NotNull
    public <X> Try<T> recover(@NotNull Class<? extends X> type, @NotNull CheckedFunction<? super X, ? extends T, ?> op) {
        Objects.requireNonNull(op);
        if (!type.isInstance(this.cause)) {
            return this;
        }
        try {
            return Try.success(op.applyChecked(this.cause));
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    @NotNull
    public Try<T> recoverWith(@NotNull CheckedFunction<? super Throwable, ? extends Try<? extends T>, ?> op) {
        Objects.requireNonNull(op);
        if (this.isSuccess()) {
            return this;
        }
        try {
            return op.applyChecked(this.cause);
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    @NotNull
    public <X> Try<T> recoverWith(@NotNull Class<? extends X> type, @NotNull CheckedFunction<? super X, ? extends Try<? extends T>, ?> op) {
        Objects.requireNonNull(op);
        if (!type.isInstance(this.cause)) {
            return this;
        }
        try {
            return op.applyChecked(this.cause);
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    @Override
    @NotNull
    public <Ex extends Throwable> Try<T> rethrow() throws Ex {
        if (this.isFailure()) {
            throw this.cause;
        }
        return this;
    }

    @Override
    @NotNull
    public <Ex extends Throwable> Try<T> rethrow(@NotNull Class<? extends Ex> type) throws Ex {
        if (type.isInstance(this.cause)) {
            throw this.cause;
        }
        return this;
    }

    @Override
    @NotNull
    public Try<T> rethrowFatal() {
        if (Try.isFatal(this.cause)) {
            Try.sneakyThrow(this.cause);
        }
        return this;
    }

    @NotNull
    public @NotNull Either<@NotNull Throwable, T> toEither() {
        return this.isSuccess() ? Either.right(this.value) : Either.left(this.cause);
    }

    @NotNull
    public @NotNull Result<T, @NotNull Throwable> toResult() {
        return this.isSuccess() ? Result.ok(this.value) : Result.err(this.cause);
    }

    @NotNull
    public <U> Try<U> map(@NotNull CheckedFunction<? super T, ? extends U, ?> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isFailure()) {
            return this;
        }
        try {
            return Try.success(mapper.applyChecked(this.value));
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    @NotNull
    public <U> Try<U> flatMap(@NotNull CheckedFunction<? super T, ? extends Try<? extends U>, ?> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isFailure()) {
            return this;
        }
        try {
            return mapper.applyChecked(this.value);
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.isSuccess() ? Iterators.of(this.value) : Iterators.empty();
    }

    @Override
    public void forEach(@NotNull Consumer<? super T> action) {
        if (this.isSuccess()) {
            action.accept(this.value);
        }
    }

    public int hashCode() {
        if (this.isSuccess()) {
            return Objects.hashCode(this.value) + 518848667;
        }
        return this.getCause().hashCode() + 1918688519;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnyTry)) {
            return false;
        }
        AnyTry other = (AnyTry)o;
        if (this.isSuccess() && other.isSuccess()) {
            return Objects.equals(this.get(), other.getValue());
        }
        if (this.isFailure() && other.isFailure()) {
            return this.getCause().equals(other.getCause());
        }
        return false;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "Try.Success[" + this.value + "]";
        }
        return "Try.Failure[" + this.cause + "]";
    }

    private Object writeReplace() {
        if (this.isSuccess()) {
            return new Replaced(true, this.value);
        }
        return new Replaced(false, this.cause);
    }

    private static final class Replaced
    implements Serializable {
        private static final long serialVersionUID = -3487244164062636325L;
        private final boolean isSuccess;
        private final Object value;

        Replaced(boolean isSuccess, Object value) {
            this.isSuccess = isSuccess;
            this.value = value;
        }

        private Object readResolve() {
            return this.isSuccess ? Try.success(this.value) : Try.failure((Throwable)this.value);
        }
    }
}

