/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import kala.control.Try;
import kala.function.IndexedConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface CheckedIndexedConsumer<T, Ex extends Throwable>
extends IndexedConsumer<T> {
    @Contract(value="_ -> param1", pure=true)
    public static <T, Ex extends Throwable> CheckedIndexedConsumer<T, Ex> of(CheckedIndexedConsumer<? super T, ? extends Ex> consumer) {
        return consumer;
    }

    public void acceptChecked(int var1, T var2) throws Ex;

    @Override
    default public void accept(int index, T t) {
        try {
            this.acceptChecked(index, t);
        }
        catch (Throwable e) {
            Try.sneakyThrow(e);
        }
    }

    @Deprecated
    @NotNull
    default public Try<Void> tryAccept(int index, T t) {
        try {
            this.acceptChecked(index, t);
            return Try.VOID;
        }
        catch (Throwable e) {
            return Try.failure(e);
        }
    }
}

