/*
 * Decompiled with CFR 0.152.
 */
package kala.internal;

import java.util.Arrays;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatIterator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class InternalFloatArrayBuilder {
    private static final int DEFAULT_CAPACITY = 16;
    private float[] elements = FloatArrays.EMPTY;
    private int size = 0;

    private void grow() {
        float[] newArray;
        int oldCapacity = this.elements.length;
        if (oldCapacity == 0) {
            newArray = new float[Math.max(16, this.size + 1)];
        } else {
            int newCapacity = Math.max(Math.max(oldCapacity, this.size + 1), oldCapacity + (oldCapacity >> 1));
            newArray = new float[newCapacity];
        }
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    public int size() {
        return this.size;
    }

    public float get(int idx) {
        return this.elements[idx];
    }

    public void set(int idx, float newValue) {
        this.elements[idx] = newValue;
    }

    public void append(float value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    public float[] toArray() {
        return this.elements.length == this.size ? this.elements : Arrays.copyOf(this.elements, this.size);
    }

    public FloatIterator iterator() {
        return FloatArrays.iterator(this.elements, 0, this.size);
    }
}

