/*
 * Decompiled with CFR 0.152.
 */
package kala.text;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import kala.Conditions;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.CharArrays;
import kala.control.primitive.ByteOption;
import kala.control.primitive.DoubleOption;
import kala.control.primitive.FloatOption;
import kala.control.primitive.IntOption;
import kala.control.primitive.LongOption;
import kala.control.primitive.ShortOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringView
implements Comparable<StringView>,
CharSequence,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int ZERO_HASH_REPLACE = 914090028;
    private static final StringView EMPTY = new StringView("", 0, 0);
    private final String value;
    private final int offset;
    private final int length;
    private int hash;

    private StringView(String value, int offset, int length) {
        this.value = value;
        this.offset = offset;
        this.length = length;
    }

    public static StringView of(@NotNull String value) {
        return value.length() != 0 ? new StringView(value, 0, value.length()) : EMPTY;
    }

    public static StringView of(@NotNull String value, int beginIndex, int endIndex) {
        Conditions.checkPositionIndices(beginIndex, endIndex, value.length());
        return beginIndex != endIndex ? new StringView(value, beginIndex, endIndex - beginIndex) : EMPTY;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        Conditions.checkElementIndex(index, this.length);
        return this.value.charAt(index + this.offset);
    }

    public char[] getChars() {
        return this.getChars(0, this.length);
    }

    public char[] getChars(int beginIndex, int endIndex) {
        Conditions.checkPositionIndices(beginIndex, endIndex, this.length);
        int resLength = endIndex - beginIndex;
        if (resLength == 0) {
            return CharArrays.EMPTY;
        }
        char[] res = new char[resLength];
        this.value.getChars(beginIndex, endIndex, res, 0);
        return res;
    }

    public byte[] getBytes() {
        return this.getBytes(StandardCharsets.UTF_8, 0, this.length);
    }

    public byte[] getBytes(int beginIndex, int endIndex) {
        return this.getBytes(StandardCharsets.UTF_8, beginIndex, endIndex);
    }

    public byte[] getBytes(Charset charset) {
        return this.getBytes(charset, 0, this.length);
    }

    public byte[] getBytes(Charset charset, int beginIndex, int endIndex) {
        ByteBuffer result;
        Conditions.checkPositionIndices(beginIndex, endIndex, this.length);
        if (beginIndex == endIndex) {
            return ByteArrays.EMPTY;
        }
        if (this.value.length() == endIndex - beginIndex) {
            return this.value.getBytes(charset);
        }
        try {
            result = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(CharBuffer.wrap(this.value, beginIndex + this.offset, endIndex + this.offset));
        }
        catch (CharacterCodingException e) {
            throw new AssertionError((Object)e);
        }
        if (result.capacity() == result.limit()) {
            return result.array();
        }
        byte[] res = new byte[result.limit()];
        result.get(res);
        return res;
    }

    @Override
    @NotNull
    public StringView subSequence(int start, int end) {
        return this.substring(start, end);
    }

    @NotNull
    public StringView substring(int beginIndex) {
        return this.substring(beginIndex, this.length);
    }

    @NotNull
    public StringView substring(int beginIndex, int endIndex) {
        Conditions.checkPositionIndices(beginIndex, endIndex, this.length);
        return beginIndex != endIndex ? new StringView(this.value, this.offset + beginIndex, endIndex - beginIndex) : EMPTY;
    }

    @NotNull
    public StringView concat(@NotNull String other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return StringView.of(other);
        }
        StringBuilder builder = new StringBuilder(this.length + other.length());
        this.appendTo(builder);
        builder.append(other);
        return StringView.of(builder.toString());
    }

    @NotNull
    public StringView concat(@NotNull StringView other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        StringBuilder builder = new StringBuilder(this.length + other.length());
        this.appendTo(builder);
        other.appendTo(builder);
        return StringView.of(builder.toString());
    }

    public boolean startsWith(@NotNull String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(@NotNull String prefix, int toIndex) {
        if (toIndex < 0 || toIndex > this.length - prefix.length()) {
            return false;
        }
        return this.value.regionMatches(this.offset + toIndex, prefix, 0, prefix.length());
    }

    public boolean startsWith(@NotNull StringView prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(@NotNull StringView prefix, int toIndex) {
        if (toIndex < 0 || toIndex > this.length - prefix.length()) {
            return false;
        }
        return this.value.regionMatches(this.offset + toIndex, prefix.value, prefix.offset, prefix.length);
    }

    public boolean endsWith(@NotNull String suffix) {
        return this.startsWith(suffix, this.length - suffix.length());
    }

    public boolean endsWith(@NotNull StringView suffix) {
        return this.startsWith(suffix, this.length - suffix.length());
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int idx;
        if (fromIndex >= this.length) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        return (idx = this.value.indexOf(ch, fromIndex + this.offset)) >= this.offset && idx < this.offset + this.length ? idx - this.offset : -1;
    }

    public StringView replace(char oldChar, char newChar) {
        if (oldChar == newChar) {
            return this;
        }
        int idx = this.indexOf(oldChar);
        if (idx < 0) {
            return this;
        }
        StringBuilder res = new StringBuilder(this.length);
        res.append(this.value, this.offset, idx += this.offset);
        res.append(newChar);
        while (++idx < this.offset + this.length) {
            char ch = this.value.charAt(idx);
            res.append(ch == oldChar ? newChar : ch);
        }
        return StringView.of(res.toString());
    }

    public boolean contentEquals(StringView other) {
        return this == other || this.length == other.length && this.value.regionMatches(this.offset, other.value, other.offset, this.length);
    }

    public boolean contentEquals(String other) {
        return this.length == other.length() && this.value.regionMatches(this.offset, other, 0, this.length);
    }

    public boolean contentEquals(CharSequence other) {
        if (this.length != other.length()) {
            return false;
        }
        if (other instanceof StringView) {
            return this.contentEquals((StringView)other);
        }
        if (other instanceof String) {
            return this.contentEquals((String)other);
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.value.charAt(this.offset + i) == other.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean contentEqualsIgnoreCase(StringView other) {
        return this == other || this.length == other.length && this.value.regionMatches(true, this.offset, other.value, other.offset, this.length);
    }

    public boolean contentEqualsIgnoreCase(String other) {
        return this.length == other.length() && this.value.regionMatches(true, this.offset, other, 0, this.length);
    }

    public boolean contentEqualsIgnoreCase(CharSequence other) {
        if (this.length != other.length()) {
            return false;
        }
        if (other instanceof StringView) {
            return this.contentEqualsIgnoreCase((StringView)other);
        }
        return this.contentEqualsIgnoreCase(other.toString());
    }

    public void appendTo(StringBuilder builder) {
        this.appendTo(builder, 0, this.length);
    }

    public void appendTo(StringBuilder builder, int beginIndex, int endIndex) {
        Conditions.checkPositionIndices(beginIndex, endIndex, this.length);
        if (beginIndex != endIndex) {
            builder.append(this.value, this.offset + beginIndex, this.offset + endIndex);
        }
    }

    public boolean toBoolean() {
        return this.contentEqualsIgnoreCase("true");
    }

    public byte toByte() throws NumberFormatException {
        return Byte.parseByte(this.toString(), 10);
    }

    public byte toByte(int radix) throws NumberFormatException {
        return Byte.parseByte(this.toString(), radix);
    }

    @Nullable
    public Byte toByteOrNull() {
        try {
            return Byte.parseByte(this.toString(), 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public Byte toByteOrNull(int radix) {
        try {
            return Byte.parseByte(this.toString(), radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public ByteOption toByteOption() {
        try {
            return ByteOption.some(Byte.parseByte(this.toString(), 10));
        }
        catch (NumberFormatException e) {
            return ByteOption.none();
        }
    }

    @NotNull
    public ByteOption toByteOption(int radix) {
        try {
            return ByteOption.some(Byte.parseByte(this.toString(), radix));
        }
        catch (NumberFormatException e) {
            return ByteOption.none();
        }
    }

    public short toShort() throws NumberFormatException {
        return Short.parseShort(this.toString(), 10);
    }

    public short toShort(int radix) throws NumberFormatException {
        return Short.parseShort(this.toString(), radix);
    }

    @Nullable
    public Short toShortOrNull() {
        try {
            return Short.parseShort(this.toString(), 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public Short toShortOrNull(int radix) {
        try {
            return Short.parseShort(this.toString(), radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public ShortOption toShortOption() {
        try {
            return ShortOption.some(Short.parseShort(this.toString(), 10));
        }
        catch (NumberFormatException e) {
            return ShortOption.none();
        }
    }

    @NotNull
    public ShortOption toShortOption(int radix) {
        try {
            return ShortOption.some(Short.parseShort(this.toString(), radix));
        }
        catch (NumberFormatException e) {
            return ShortOption.none();
        }
    }

    public int toInt() throws NumberFormatException {
        return this.toInt(10);
    }

    public int toInt(int radix) throws NumberFormatException {
        return Integer.parseInt(this.toString(), radix);
    }

    @Nullable
    public Integer toIntOrNull() {
        try {
            return this.toInt(10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public Integer toIntOrNull(int radix) {
        try {
            return this.toInt(radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public IntOption toIntOption() {
        try {
            return IntOption.some(this.toInt(10));
        }
        catch (NumberFormatException e) {
            return IntOption.none();
        }
    }

    @NotNull
    public IntOption toIntOption(int radix) {
        try {
            return IntOption.some(this.toInt(radix));
        }
        catch (NumberFormatException e) {
            return IntOption.none();
        }
    }

    public long toLong() throws NumberFormatException {
        return this.toLong(10);
    }

    public long toLong(int radix) throws NumberFormatException {
        return Long.parseLong(this.toString(), radix);
    }

    @Nullable
    public Long toLongOrNull() {
        try {
            return this.toLong(10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public Long toLongOrNull(int radix) {
        try {
            return this.toLong(radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public LongOption toLongOption() {
        try {
            return LongOption.some(this.toLong(10));
        }
        catch (NumberFormatException e) {
            return LongOption.none();
        }
    }

    @NotNull
    public LongOption toLongOption(int radix) {
        try {
            return LongOption.some(this.toLong(radix));
        }
        catch (NumberFormatException e) {
            return LongOption.none();
        }
    }

    public float toFloat() throws NumberFormatException {
        return Float.parseFloat(this.toString());
    }

    @Nullable
    public Float toFloatOrNull() {
        try {
            return Float.valueOf(Float.parseFloat(this.toString()));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public FloatOption toFloatOption() {
        try {
            return FloatOption.some(Float.parseFloat(this.toString()));
        }
        catch (NumberFormatException e) {
            return FloatOption.none();
        }
    }

    public double toDouble() throws NumberFormatException {
        return Double.parseDouble(this.toString());
    }

    @Nullable
    public Double toDoubleOrNull() {
        try {
            return Double.parseDouble(this.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public DoubleOption toDoubleOption() {
        try {
            return DoubleOption.some(Double.parseDouble(this.toString()));
        }
        catch (NumberFormatException e) {
            return DoubleOption.none();
        }
    }

    public int hashCode() {
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            h = 31 * h + this.value.charAt(i);
        }
        this.hash = h == 0 ? 914090028 : h;
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringView)) {
            return false;
        }
        return this.contentEquals((StringView)obj);
    }

    @Override
    public String toString() {
        return this.value.substring(this.offset, this.offset + this.length);
    }

    @Override
    public int compareTo(@NotNull StringView other) {
        int lim = Math.min(this.length, other.length);
        for (int i = 0; i < lim; ++i) {
            char c2;
            char c1 = this.charAt(i);
            if (c1 == (c2 = other.charAt(i))) continue;
            return c1 - c2;
        }
        return this.length - other.length;
    }
}

