/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.IntFunction;
import kala.tuple.AnyTuple;
import kala.tuple.HList;
import kala.tuple.Tuple;
import kala.tuple.Tuple5;
import kala.tuple.Tuple7;
import kala.tuple.Unit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Tuple6<T1, T2, T3, T4, T5, T6>
implements HList<T1, Tuple5<T2, T3, T4, T5, T6>>,
Serializable {
    private static final long serialVersionUID = 3503303487328993024L;
    public final T1 _1;
    public final T2 _2;
    public final T3 _3;
    public final T4 _4;
    public final T5 _5;
    public final T6 _6;

    public Tuple6(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6) {
        this._1 = t1;
        this._2 = t2;
        this._3 = t3;
        this._4 = t4;
        this._5 = t5;
        this._6 = t6;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> narrow(HList<? extends T1, ? extends HList<? extends T2, ? extends HList<? extends T3, ? extends HList<? extends T4, ? extends HList<? extends T5, ? extends HList<? extends T6, ? extends Unit>>>>>> tuple) {
        return (Tuple6)tuple;
    }

    @Override
    public int arity() {
        return 6;
    }

    @Override
    public <U> U elementAt(int index) {
        switch (index) {
            case 0: {
                return (U)this._1;
            }
            case 1: {
                return (U)this._2;
            }
            case 2: {
                return (U)this._3;
            }
            case 3: {
                return (U)this._4;
            }
            case 4: {
                return (U)this._5;
            }
            case 5: {
                return (U)this._6;
            }
        }
        throw new IndexOutOfBoundsException("Index out of range: " + index);
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        U[] arr = generator.apply(this.arity());
        arr[0] = this._1;
        arr[1] = this._2;
        arr[2] = this._3;
        arr[3] = this._4;
        arr[4] = this._5;
        arr[5] = this._6;
        return arr;
    }

    public T1 component1() {
        return this._1;
    }

    public T2 component2() {
        return this._2;
    }

    public T3 component3() {
        return this._3;
    }

    public T4 component4() {
        return this._4;
    }

    public T5 component5() {
        return this._5;
    }

    public T6 component6() {
        return this._6;
    }

    @Override
    public T1 head() {
        return this._1;
    }

    @Override
    @NotNull
    public Tuple5<T2, T3, T4, T5, T6> tail() {
        return Tuple.of(this._2, this._3, this._4, this._5, this._6);
    }

    @Contract(value="_ -> new")
    @NotNull
    public <H> Tuple7<H, T1, T2, T3, T4, T5, T6> cons(H head) {
        return new Tuple7<H, T1, T2, T3, T4, T5, T6>(head, this._1, this._2, this._3, this._4, this._5, this._6);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Tuple6) {
            Tuple6 other = (Tuple6)o;
            return Objects.equals(this._1, other._1) && Objects.equals(this._2, other._2) && Objects.equals(this._3, other._3) && Objects.equals(this._4, other._4) && Objects.equals(this._5, other._5) && Objects.equals(this._6, other._6);
        }
        if (o instanceof AnyTuple) {
            AnyTuple other = (AnyTuple)o;
            return other.arity() == 6 && Objects.equals(this._1, other.elementAt(0)) && Objects.equals(this._2, other.elementAt(1)) && Objects.equals(this._3, other.elementAt(2)) && Objects.equals(this._4, other.elementAt(3)) && Objects.equals(this._5, other.elementAt(4)) && Objects.equals(this._6, other.elementAt(5));
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + Objects.hashCode(this._1);
        hash = 31 * hash + Objects.hashCode(this._2);
        hash = 31 * hash + Objects.hashCode(this._3);
        hash = 31 * hash + Objects.hashCode(this._4);
        hash = 31 * hash + Objects.hashCode(this._5);
        hash = 31 * hash + Objects.hashCode(this._6);
        return hash + 427632945;
    }

    public String toString() {
        return "(" + this._1 + ", " + this._2 + ", " + this._3 + ", " + this._4 + ", " + this._5 + ", " + this._6 + ")";
    }
}

