/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;
import kala.tuple.AnyTuple;
import kala.tuple.HList;
import kala.tuple.Tuple9;
import org.jetbrains.annotations.NotNull;

final class TupleXXL
implements HList<Object, HList<?, ?>> {
    private static final long serialVersionUID = -1035728226134523579L;
    private final Object @NotNull [] values;

    TupleXXL(Object @NotNull [] values) {
        this.values = values;
    }

    @Override
    public int arity() {
        return this.values.length;
    }

    @Override
    public <U> U elementAt(int index) {
        try {
            return (U)this.values[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
    }

    @Override
    @NotNull
    public <H> HList<H, TupleXXL> cons(H head) {
        int arity = this.arity();
        Object[] arr = new Object[arity + 1];
        arr[0] = head;
        System.arraycopy(this.values, 0, arr, 1, arity);
        return new TupleXXL(arr);
    }

    @Override
    public Object @NotNull [] toArray() {
        return (Object[])this.values.clone();
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        U[] arr = generator.apply(this.arity());
        System.arraycopy(this.values, 0, arr, 0, this.arity());
        return arr;
    }

    @Override
    public Object head() {
        return this.values[0];
    }

    @Override
    @NotNull
    public HList<?, ?> tail() {
        int arity = this.arity();
        if (arity == 10) {
            return new Tuple9<Object, Object, Object, Object, Object, Object, Object, Object, Object>(this.values[1], this.values[2], this.values[3], this.values[4], this.values[5], this.values[6], this.values[7], this.values[8], this.values[9]);
        }
        return new TupleXXL(Arrays.copyOfRange(this.values, 1, arity));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TupleXXL) {
            TupleXXL other = (TupleXXL)o;
            return Arrays.equals(this.values, other.values);
        }
        if (o instanceof AnyTuple) {
            AnyTuple other = (AnyTuple)o;
            if (this.arity() != other.arity()) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (Objects.equals(this.values[i], other.elementAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (Object value : this.values) {
            hash = hash * 31 + Objects.hashCode(value);
        }
        return hash + 427632945;
    }

    public String toString() {
        Object[] values = this.values;
        int arity = values.length;
        StringBuilder builder = new StringBuilder(6 * arity);
        builder.append('(').append(values[0]);
        for (int i = 1; i < arity; ++i) {
            builder.append(", ").append(values[i]);
        }
        builder.append(')');
        return builder.toString();
    }
}

