/*
 * Decompiled with CFR 0.152.
 */
package kala.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import kala.collection.base.AbstractIterator;
import kala.function.Memoized;
import kala.value.AbstractValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class LazyValue<T>
extends AbstractValue<T>
implements Memoized,
Serializable {
    private static final long serialVersionUID = 7403692951772568981L;
    private volatile transient Supplier<? extends T> supplier;
    private transient T value;

    private LazyValue(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    private LazyValue(T value) {
        this.value = value;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T> LazyValue<T> narrow(LazyValue<? extends T> value) {
        return value;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <T> LazyValue<T> of(@NotNull Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        return new LazyValue<Supplier<? extends T>>(supplier);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <T> LazyValue<T> ofValue(T value) {
        return new LazyValue<T>(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.supplier != null) {
            LazyValue lazyValue = this;
            synchronized (lazyValue) {
                Supplier<T> s = this.supplier;
                if (s != null) {
                    this.value = s.get();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }

    public boolean isReady() {
        return this.supplier == null;
    }

    @Override
    @Contract(value="_ -> new")
    @NotNull
    public <U> LazyValue<U> map(@NotNull Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return LazyValue.of(() -> mapper.apply((T)this.get()));
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return LazyValue.this.get();
            }
        };
    }

    @Override
    public String toString() {
        if (this.supplier == null) {
            return "LazyValue[" + this.value + "]";
        }
        return "LazyValue[<not computed>]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
        this.supplier = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.get());
    }
}

