/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.function.BooleanConsumer;
import kala.function.BooleanUnaryOperator;
import kala.value.primitive.DefaultBooleanValue;
import kala.value.primitive.DelegateBooleanValue;
import kala.value.primitive.DelegateMutableBooleanValue;
import kala.value.primitive.LazyBooleanValue;
import kala.value.primitive.MutableBooleanValue;
import kala.value.primitive.PrimitiveValue;
import org.jetbrains.annotations.NotNull;

public interface BooleanValue
extends PrimitiveValue<Boolean>,
BooleanTraversable,
BooleanSupplier {
    @NotNull
    public static BooleanValue of(boolean value) {
        return new DefaultBooleanValue(value);
    }

    @NotNull
    public static BooleanValue by(@NotNull BooleanSupplier getter) {
        Objects.requireNonNull(getter);
        return new DelegateBooleanValue(getter);
    }

    @NotNull
    public static LazyBooleanValue lazy(@NotNull BooleanSupplier getter) {
        return LazyBooleanValue.of(getter);
    }

    public boolean get();

    @Override
    @Deprecated
    default public boolean getAsBoolean() {
        return this.get();
    }

    @Override
    @NotNull
    default public Boolean getValue() {
        return this.get();
    }

    @NotNull
    default public BooleanValue map(@NotNull BooleanUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return BooleanValue.by(() -> mapper.applyAsBoolean(this.get()));
    }

    @NotNull
    default public MutableBooleanValue asMutable(@NotNull BooleanConsumer setter) {
        Objects.requireNonNull(setter);
        return new DelegateMutableBooleanValue(this, setter);
    }

    @Override
    @NotNull
    default public BooleanIterator iterator() {
        return BooleanIterator.of(this.get());
    }

    @Override
    default public void forEach(@NotNull BooleanConsumer action) {
        action.accept(this.get());
    }
}

