/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import kala.function.BooleanBinaryOperator;
import kala.function.BooleanConsumer;
import kala.function.BooleanUnaryOperator;
import kala.value.primitive.BooleanValue;
import kala.value.primitive.BooleanVar;
import kala.value.primitive.DelegateMutableBooleanValue;
import kala.value.primitive.MutablePrimitiveValue;
import kala.value.primitive.VolatileBooleanVar;
import org.jetbrains.annotations.NotNull;

public interface MutableBooleanValue
extends MutablePrimitiveValue<Boolean>,
BooleanValue,
BooleanConsumer {
    @NotNull
    public static MutableBooleanValue create() {
        return new BooleanVar();
    }

    @NotNull
    public static MutableBooleanValue create(boolean initialValue) {
        return new BooleanVar(initialValue);
    }

    @NotNull
    public static MutableBooleanValue createVolatile() {
        return new VolatileBooleanVar();
    }

    @NotNull
    public static MutableBooleanValue createVolatile(boolean initialValue) {
        return new VolatileBooleanVar(initialValue);
    }

    @NotNull
    public static MutableBooleanValue by(@NotNull BooleanSupplier getter, @NotNull BooleanConsumer setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return new DelegateMutableBooleanValue(getter, setter);
    }

    public void set(boolean var1);

    @Override
    default public void setValue(@NotNull Boolean value) {
        this.set(value);
    }

    @Override
    @Deprecated
    default public void accept(boolean value) {
        this.set(value);
    }

    @NotNull
    default public MutableBooleanValue withGetter(@NotNull BooleanSupplier newGetter) {
        Objects.requireNonNull(newGetter);
        return new DelegateMutableBooleanValue(newGetter, this);
    }

    @NotNull
    default public MutableBooleanValue withSetter(@NotNull BooleanConsumer newSetter) {
        Objects.requireNonNull(newSetter);
        return new DelegateMutableBooleanValue(this, newSetter);
    }

    @Override
    @Deprecated
    @NotNull
    default public MutableBooleanValue asMutable(@NotNull BooleanConsumer setter) {
        return this.withSetter(setter);
    }

    default public boolean getAndSet(boolean newValue) {
        boolean oldValue = this.get();
        this.set(newValue);
        return oldValue;
    }

    default public boolean compareAndSet(boolean expectedValue, boolean newValue) {
        if (this.get() == expectedValue) {
            this.set(newValue);
            return true;
        }
        return false;
    }

    default public void update(@NotNull BooleanUnaryOperator updateFunction) {
        this.getAndUpdate(updateFunction);
    }

    default public boolean getAndUpdate(@NotNull BooleanUnaryOperator updateFunction) {
        boolean v = this.get();
        this.set(updateFunction.applyAsBoolean(v));
        return v;
    }

    default public boolean updateAndGet(@NotNull BooleanUnaryOperator updateFunction) {
        boolean v = updateFunction.applyAsBoolean(this.get());
        this.set(v);
        return v;
    }

    default public void accumulate(boolean t, @NotNull BooleanBinaryOperator accumulatorFunction) {
        this.getAndAccumulate(t, accumulatorFunction);
    }

    default public boolean getAndAccumulate(boolean t, @NotNull BooleanBinaryOperator accumulatorFunction) {
        boolean v = this.get();
        this.set(accumulatorFunction.applyAsBoolean(v, t));
        return v;
    }

    default public boolean accumulateAndGet(boolean t, @NotNull BooleanBinaryOperator accumulatorFunction) {
        boolean v = accumulatorFunction.applyAsBoolean(this.get(), t);
        this.set(v);
        return v;
    }
}

