/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import kala.value.primitive.DelegateMutableDoubleValue;
import kala.value.primitive.DoubleValue;
import kala.value.primitive.DoubleVar;
import kala.value.primitive.MutablePrimitiveValue;
import kala.value.primitive.VolatileDoubleVar;
import org.jetbrains.annotations.NotNull;

public interface MutableDoubleValue
extends MutablePrimitiveValue<Double>,
DoubleValue,
DoubleConsumer {
    @NotNull
    public static MutableDoubleValue create() {
        return new DoubleVar();
    }

    @NotNull
    public static MutableDoubleValue create(double initialValue) {
        return new DoubleVar(initialValue);
    }

    @NotNull
    public static MutableDoubleValue createVolatile() {
        return new VolatileDoubleVar();
    }

    @NotNull
    public static MutableDoubleValue createVolatile(double initialValue) {
        return new VolatileDoubleVar(initialValue);
    }

    @NotNull
    public static MutableDoubleValue by(@NotNull DoubleSupplier getter, @NotNull DoubleConsumer setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return new DelegateMutableDoubleValue(getter, setter);
    }

    public void set(double var1);

    @Override
    default public void setValue(@NotNull Double value) {
        this.set(value);
    }

    @Override
    @Deprecated
    default public void accept(double value) {
        this.set(value);
    }

    @NotNull
    default public MutableDoubleValue withGetter(@NotNull DoubleSupplier newGetter) {
        Objects.requireNonNull(newGetter);
        return new DelegateMutableDoubleValue(newGetter, this);
    }

    @NotNull
    default public MutableDoubleValue withSetter(@NotNull DoubleConsumer newSetter) {
        Objects.requireNonNull(newSetter);
        return new DelegateMutableDoubleValue(this, newSetter);
    }

    @Override
    @Deprecated
    @NotNull
    default public MutableDoubleValue asMutable(@NotNull DoubleConsumer setter) {
        return this.withSetter(setter);
    }

    default public double getAndSet(double newValue) {
        double oldValue = this.get();
        this.set(newValue);
        return oldValue;
    }

    default public boolean compareAndSet(double expectedValue, double newValue) {
        if (Double.doubleToLongBits(this.get()) == Double.doubleToLongBits(expectedValue)) {
            this.set(newValue);
            return true;
        }
        return false;
    }

    default public void update(@NotNull DoubleUnaryOperator updateFunction) {
        this.getAndUpdate(updateFunction);
    }

    default public double getAndUpdate(@NotNull DoubleUnaryOperator updateFunction) {
        double v = this.get();
        this.set(updateFunction.applyAsDouble(v));
        return v;
    }

    default public double updateAndGet(@NotNull DoubleUnaryOperator updateFunction) {
        double v = updateFunction.applyAsDouble(this.get());
        this.set(v);
        return v;
    }

    default public void accumulate(double t, @NotNull DoubleBinaryOperator accumulatorFunction) {
        this.getAndAccumulate(t, accumulatorFunction);
    }

    default public double getAndAccumulate(double t, @NotNull DoubleBinaryOperator accumulatorFunction) {
        double v = this.get();
        this.set(accumulatorFunction.applyAsDouble(v, t));
        return v;
    }

    default public double accumulateAndGet(double t, @NotNull DoubleBinaryOperator accumulatorFunction) {
        double v = accumulatorFunction.applyAsDouble(this.get(), t);
        this.set(v);
        return v;
    }
}

