/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import kala.value.primitive.AtomicLongVar;
import kala.value.primitive.DelegateMutableLongValue;
import kala.value.primitive.LongValue;
import kala.value.primitive.LongVar;
import kala.value.primitive.MutablePrimitiveValue;
import kala.value.primitive.VolatileLongVar;
import org.jetbrains.annotations.NotNull;

public interface MutableLongValue
extends MutablePrimitiveValue<Long>,
LongValue,
LongConsumer {
    @NotNull
    public static MutableLongValue create() {
        return new LongVar();
    }

    @NotNull
    public static MutableLongValue create(long initialValue) {
        return new LongVar(initialValue);
    }

    @NotNull
    public static MutableLongValue createVolatile() {
        return new VolatileLongVar();
    }

    @NotNull
    public static MutableLongValue createVolatile(long initialValue) {
        return new VolatileLongVar(initialValue);
    }

    @NotNull
    public static MutableLongValue createAtomic() {
        return new AtomicLongVar();
    }

    @NotNull
    public static MutableLongValue createAtomic(long initialValue) {
        return new AtomicLongVar(initialValue);
    }

    @NotNull
    public static MutableLongValue by(@NotNull LongSupplier getter, @NotNull LongConsumer setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return new DelegateMutableLongValue(getter, setter);
    }

    public void set(long var1);

    @Override
    default public void setValue(@NotNull Long value) {
        this.set(value);
    }

    @Override
    @Deprecated
    default public void accept(long value) {
        this.set(value);
    }

    @NotNull
    default public MutableLongValue withGetter(@NotNull LongSupplier newGetter) {
        Objects.requireNonNull(newGetter);
        return new DelegateMutableLongValue(newGetter, this);
    }

    @NotNull
    default public MutableLongValue withSetter(@NotNull LongConsumer newSetter) {
        Objects.requireNonNull(newSetter);
        return new DelegateMutableLongValue(this, newSetter);
    }

    @Override
    @Deprecated
    @NotNull
    default public MutableLongValue asMutable(@NotNull LongConsumer setter) {
        return this.withSetter(setter);
    }

    default public long getAndSet(long newValue) {
        long oldValue = this.get();
        this.set(newValue);
        return oldValue;
    }

    default public boolean compareAndSet(long expectedValue, long newValue) {
        if (this.get() == expectedValue) {
            this.set(newValue);
            return true;
        }
        return false;
    }

    default public void update(@NotNull LongUnaryOperator updateFunction) {
        this.getAndUpdate(updateFunction);
    }

    default public long getAndUpdate(@NotNull LongUnaryOperator updateFunction) {
        long v = this.get();
        this.set(updateFunction.applyAsLong(v));
        return v;
    }

    default public long updateAndGet(@NotNull LongUnaryOperator updateFunction) {
        long v = updateFunction.applyAsLong(this.get());
        this.set(v);
        return v;
    }

    default public void accumulate(long t, @NotNull LongBinaryOperator accumulatorFunction) {
        this.getAndAccumulate(t, accumulatorFunction);
    }

    default public long getAndAccumulate(long t, @NotNull LongBinaryOperator accumulatorFunction) {
        long v = this.get();
        this.set(accumulatorFunction.applyAsLong(v, t));
        return v;
    }

    default public long accumulateAndGet(long t, @NotNull LongBinaryOperator accumulatorFunction) {
        long v = accumulatorFunction.applyAsLong(this.get(), t);
        this.set(v);
        return v;
    }

    default public void increment() {
        this.set(this.get() + 1L);
    }

    default public void decrement() {
        this.set(this.get() - 1L);
    }

    default public void add(long delta) {
        this.set(this.get() + delta);
    }

    default public void sub(long delta) {
        this.set(this.get() - delta);
    }

    default public long getAndIncrement() {
        long v = this.get();
        this.increment();
        return v;
    }

    default public long getAndDecrement() {
        long v = this.get();
        this.decrement();
        return v;
    }

    default public long getAndAdd(long delta) {
        long v = this.get();
        this.add(delta);
        return v;
    }

    default public long getAndSub(long delta) {
        long v = this.get();
        this.sub(delta);
        return v;
    }

    default public long incrementAndGet() {
        this.increment();
        return this.get();
    }

    default public long decrementAndGet() {
        this.decrement();
        return this.get();
    }

    default public long addAndGet(long delta) {
        this.add(delta);
        return this.get();
    }

    default public long subAndGet(long delta) {
        this.sub(delta);
        return this.get();
    }
}

