/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import kala.tuple.AnyTuple;
import kala.tuple.HList;
import kala.tuple.SerializedTuple;
import kala.tuple.Tuple;
import kala.tuple.Tuple1;
import kala.tuple.Tuple3;
import kala.tuple.Unit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record Tuple2<T1, T2>(T1 component1, T2 component2) implements HList<T1, Tuple1<T2>>,
Serializable,
Map.Entry<T1, T2>
{
    private static final long serialVersionUID = 0L;

    @Contract(value="_ -> param1", pure=true)
    public static <T1, T2> Tuple2<T1, T2> narrow(HList<? extends T1, ? extends HList<? extends T2, ? extends Unit>> tuple) {
        return (Tuple2)tuple;
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public <U> U elementAt(int index) {
        return (U)(switch (index) {
            case 0 -> this.component1;
            case 1 -> this.component2;
            default -> throw new IndexOutOfBoundsException("Index out of range: " + index);
        });
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        U[] arr = generator.apply(this.arity());
        arr[0] = this.component1;
        arr[1] = this.component2;
        return arr;
    }

    @Override
    public T1 head() {
        return this.component1;
    }

    @Override
    @NotNull
    public Tuple1<T2> tail() {
        return Tuple.of(this.component2);
    }

    @Contract(value="_ -> new")
    @NotNull
    public <H> Tuple3<H, T1, T2> cons(H head) {
        return new Tuple3<H, T1, T2>(head, this.component1, this.component2);
    }

    @Override
    public T1 getKey() {
        return this.component1;
    }

    @Override
    public T2 getValue() {
        return this.component2;
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    public T2 setValue(T2 value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Tuple2.setValue");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Tuple2) {
            Tuple2 other = (Tuple2)o;
            return Objects.equals(this.component1, other.component1) && Objects.equals(this.component2, other.component2);
        }
        if (o instanceof Map.Entry) {
            Map.Entry other = (Map.Entry)o;
            return Objects.equals(this.component1, other.getKey()) && Objects.equals(this.component2, other.getValue());
        }
        if (o instanceof AnyTuple) {
            AnyTuple other = (AnyTuple)o;
            return other.arity() == 2 && Objects.equals(this.component1, other.elementAt(0)) && Objects.equals(this.component2, other.elementAt(1));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.component1) ^ Objects.hashCode(this.component2);
    }

    @Override
    public String toString() {
        return "(" + this.component1 + ", " + this.component2 + ")";
    }

    private Object writeReplace() {
        return new SerializedTuple(this.toArray());
    }
}

