/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.IntFunction;
import kala.tuple.AnyTuple;
import kala.tuple.HList;
import kala.tuple.SerializedTuple;
import kala.tuple.Tuple;
import kala.tuple.Tuple6;
import kala.tuple.Tuple8;
import kala.tuple.Unit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record Tuple7<T1, T2, T3, T4, T5, T6, T7>(T1 component1, T2 component2, T3 component3, T4 component4, T5 component5, T6 component6, T7 component7) implements HList<T1, Tuple6<T2, T3, T4, T5, T6, T7>>,
Serializable
{
    private static final long serialVersionUID = 0L;

    @Contract(value="_ -> param1", pure=true)
    public static <T1, T2, T3, T4, T5, T6, T7> Tuple7<T1, T2, T3, T4, T5, T6, T7> narrow(HList<? extends T1, ? extends HList<? extends T2, ? extends HList<? extends T3, ? extends HList<? extends T4, ? extends HList<? extends T5, ? extends HList<? extends T6, ? extends HList<? extends T7, ? extends Unit>>>>>>> tuple) {
        return (Tuple7)tuple;
    }

    @Override
    public int arity() {
        return 7;
    }

    @Override
    public <U> U elementAt(int index) {
        return (U)(switch (index) {
            case 0 -> this.component1;
            case 1 -> this.component2;
            case 2 -> this.component3;
            case 3 -> this.component4;
            case 4 -> this.component5;
            case 5 -> this.component6;
            case 6 -> this.component7;
            default -> throw new IndexOutOfBoundsException("Index out of range: " + index);
        });
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        U[] arr = generator.apply(this.arity());
        arr[0] = this.component1;
        arr[1] = this.component2;
        arr[2] = this.component3;
        arr[3] = this.component4;
        arr[4] = this.component5;
        arr[5] = this.component6;
        arr[6] = this.component7;
        return arr;
    }

    @Override
    public T1 head() {
        return this.component1;
    }

    @Override
    @NotNull
    public Tuple6<T2, T3, T4, T5, T6, T7> tail() {
        return Tuple.of(this.component2, this.component3, this.component4, this.component5, this.component6, this.component7);
    }

    @Contract(value="_ -> new")
    @NotNull
    public <H> Tuple8<H, T1, T2, T3, T4, T5, T6, T7> cons(H head) {
        return new Tuple8<H, T1, T2, T3, T4, T5, T6, T7>(head, this.component1, this.component2, this.component3, this.component4, this.component5, this.component6, this.component7);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Tuple7) {
            Tuple7 other = (Tuple7)o;
            return Objects.equals(this.component1, other.component1) && Objects.equals(this.component2, other.component2) && Objects.equals(this.component3, other.component3) && Objects.equals(this.component4, other.component4) && Objects.equals(this.component5, other.component5) && Objects.equals(this.component6, other.component6) && Objects.equals(this.component7, other.component7);
        }
        if (o instanceof AnyTuple) {
            AnyTuple other = (AnyTuple)o;
            return other.arity() == 7 && Objects.equals(this.component1, other.elementAt(0)) && Objects.equals(this.component2, other.elementAt(1)) && Objects.equals(this.component3, other.elementAt(2)) && Objects.equals(this.component4, other.elementAt(3)) && Objects.equals(this.component5, other.elementAt(4)) && Objects.equals(this.component6, other.elementAt(5)) && Objects.equals(this.component7, other.elementAt(6));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + Objects.hashCode(this.component1);
        hash = 31 * hash + Objects.hashCode(this.component2);
        hash = 31 * hash + Objects.hashCode(this.component3);
        hash = 31 * hash + Objects.hashCode(this.component4);
        hash = 31 * hash + Objects.hashCode(this.component5);
        hash = 31 * hash + Objects.hashCode(this.component6);
        hash = 31 * hash + Objects.hashCode(this.component7);
        return hash;
    }

    @Override
    public String toString() {
        return "(" + this.component1 + ", " + this.component2 + ", " + this.component3 + ", " + this.component4 + ", " + this.component5 + ", " + this.component6 + ", " + this.component7 + ")";
    }

    private Object writeReplace() {
        return new SerializedTuple(this.toArray());
    }
}

