/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple.primitive;

import java.util.Map;
import java.util.Objects;
import kala.Conditions;
import kala.tuple.AnyTuple;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.tuple.primitive.PrimitiveTuple;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record IntObjTuple2<T>(int component1, T component2) implements PrimitiveTuple
{
    private static final long serialVersionUID = 0L;

    @NotNull
    public static <T> IntObjTuple2<T> of(int i, T t) {
        return new IntObjTuple2<T>(i, t);
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public <U> U elementAt(int index) {
        switch (index) {
            case 0: {
                return (U)Integer.valueOf(this.component1);
            }
            case 1: {
                return (U)this.component2;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @NotNull
    public @NotNull Tuple2<@NotNull Integer, T> toTuple2() {
        return Tuple.of(this.component1, this.component2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IntObjTuple2) {
            IntObjTuple2 other = (IntObjTuple2)o;
            return this.component1 == other.component1 && Objects.equals(this.component2, other.component2);
        }
        if (o instanceof Map.Entry) {
            Map.Entry other = (Map.Entry)o;
            return Conditions.equals(this.component1, other.getKey()) && Conditions.equals(this.component2, other.getValue());
        }
        if (o instanceof AnyTuple) {
            AnyTuple other = (AnyTuple)o;
            return other.arity() == 2 && Conditions.equals(this.component1, other.elementAt(0)) && Conditions.equals(this.component2, other.elementAt(1));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Integer.hashCode(this.component1) ^ Objects.hashCode(this.component2);
    }

    @Override
    public String toString() {
        return "IntObjTuple2(" + this.component1 + ", " + this.component2 + ")";
    }
}

