/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.base.Sized;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface AnyTraversable<T>
extends Sized {
    @NotNull
    public Traversable<T> asGeneric();

    public static int knownSize(@NotNull Object c) {
        Objects.requireNonNull(c);
        if (c instanceof Sized) {
            return ((AnyTraversable)c).knownSize();
        }
        if (c instanceof Collection) {
            return ((Collection)c).size();
        }
        return -1;
    }

    @NotNull
    public Iterator<T> iterator();

    default public Spliterator<T> spliterator() {
        int ks = this.knownSize();
        if (ks == 0) {
            return Spliterators.emptySpliterator();
        }
        if (ks > 0) {
            return Spliterators.spliterator(this.iterator(), (long)ks, this.characteristics());
        }
        return Spliterators.spliteratorUnknownSize(this.iterator(), this.characteristics());
    }

    default public int characteristics() {
        return 0;
    }

    @NotNull
    default public BaseStream<T, ?> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @NotNull
    default public BaseStream<T, ?> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    default public boolean isEmpty() {
        int knownSize = this.knownSize();
        if (knownSize < 0) {
            return !this.iterator().hasNext();
        }
        return knownSize == 0;
    }

    @Override
    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    default public int size() {
        return Iterators.size(this.iterator());
    }

    @Override
    default public @Range(from=-1L, to=0x7FFFFFFFL) int knownSize() {
        return -1;
    }

    default public int sizeCompare(int otherSize) {
        if (otherSize < 0) {
            return 1;
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            return Integer.compare(knownSize, otherSize);
        }
        int i = 0;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            if (i == otherSize) {
                return 1;
            }
            ++i;
        }
        return i - otherSize;
    }

    default public int sizeCompare(@NotNull Iterable<?> other) {
        int os = AnyTraversable.knownSize(other);
        if (os >= 0) {
            return this.sizeCompare(os);
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return other.iterator().hasNext() ? -1 : 0;
        }
        if (ks > 0) {
            Iterator<?> it = other.iterator();
            while (it.hasNext()) {
                it.next();
                if (--ks != 0) continue;
                return it.hasNext() ? -1 : 0;
            }
            return 1;
        }
        Iterator<T> it1 = this.iterator();
        Iterator<?> it2 = other.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            it1.next();
            it2.next();
        }
        if (it1.hasNext()) {
            return 1;
        }
        if (it2.hasNext()) {
            return -1;
        }
        return 0;
    }

    default public boolean sizeIs(int otherSize) {
        return this.sizeCompare(otherSize) == 0;
    }

    default public boolean sizeEquals(int otherSize) {
        return this.sizeIs(otherSize);
    }

    default public boolean sizeEquals(@NotNull Iterable<?> other) {
        return this.sizeCompare(other) == 0;
    }

    default public boolean sizeLessThan(int otherSize) {
        return this.sizeCompare(otherSize) < 0;
    }

    default public boolean sizeLessThan(@NotNull Iterable<?> other) {
        return this.sizeCompare(other) < 0;
    }

    default public boolean sizeLessThanOrEquals(int otherSize) {
        return this.sizeCompare(otherSize) <= 0;
    }

    default public boolean sizeLessThanOrEquals(@NotNull Iterable<?> other) {
        return this.sizeCompare(other) <= 0;
    }

    default public boolean sizeGreaterThan(int otherSize) {
        return this.sizeCompare(otherSize) > 0;
    }

    default public boolean sizeGreaterThan(@NotNull Iterable<?> other) {
        return this.sizeCompare(other) > 0;
    }

    default public boolean sizeGreaterThanOrEquals(int otherSize) {
        return this.sizeCompare(otherSize) >= 0;
    }

    default public boolean sizeGreaterThanOrEquals(@NotNull Iterable<?> other) {
        return this.sizeCompare(other) >= 0;
    }

    default public <R, Builder> R collect(@NotNull Collector<? super T, Builder, ? extends R> collector) {
        return (R)Iterators.collect(this.iterator(), collector);
    }

    default public <R, Builder> R collect(@NotNull CollectionFactory<? super T, Builder, ? extends R> factory) {
        return (R)Iterators.collect(this.iterator(), factory);
    }

    @Contract(value="_ -> param1", mutates="param1")
    default public <G extends Growable<? super T>> G collect(G destination) {
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            destination.plusAssign(it.next());
        }
        return destination;
    }

    @Contract(value="_ -> param1", mutates="param1")
    default public <C extends Collection<? super T>> C collect(C collection) {
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            collection.add(it.next());
        }
        return collection;
    }

    @NotNull
    public Object toArray();

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer) {
        return this.joinTo(buffer, ", ");
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator) {
        return this.joinTo(buffer, separator, "", "");
    }

    @Contract(value="_, _, _, _ -> param1", mutates="param1")
    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A var1, CharSequence var2, CharSequence var3, CharSequence var4);

    @NotNull
    default public String joinToString() {
        return this.joinTo(new StringBuilder()).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator) {
        return this.joinTo(new StringBuilder(), separator).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return this.joinTo(new StringBuilder(), separator, prefix, postfix).toString();
    }
}

