/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import kala.collection.base.Iterators;
import kala.collection.base.MapIterators;
import kala.function.CheckedBiConsumer;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MapIterator<K, V>
extends Iterator<Tuple2<K, V>> {
    @NotNull
    public static <K, V> MapIterator<K, V> empty() {
        return MapIterators.EMPTY;
    }

    @NotNull
    public static <K, V> MapIterator<K, V> ofIterator(@NotNull Iterator<? extends Map.Entry<? extends K, ? extends V>> it) {
        if (!it.hasNext()) {
            return MapIterator.empty();
        }
        if (it instanceof MapIterator) {
            return (MapIterator)it;
        }
        return new MapIterators.OfIterator(it);
    }

    @Override
    public boolean hasNext();

    public K nextKey();

    public V getValue();

    @Override
    default public Tuple2<K, V> next() {
        return Tuple.of(this.nextKey(), this.getValue());
    }

    default public boolean containsKey(K key) {
        if (key == null) {
            while (this.hasNext()) {
                if (null != this.nextKey()) continue;
                return true;
            }
        } else {
            while (this.hasNext()) {
                if (!key.equals(this.nextKey())) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean containsValue(Object value) {
        if (value == null) {
            while (this.hasNext()) {
                this.nextKey();
                if (null != this.getValue()) continue;
                return true;
            }
        } else {
            while (this.hasNext()) {
                this.nextKey();
                if (!value.equals(this.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean anyMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextKey(), this.getValue())) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
        while (this.hasNext()) {
            if (predicate.test(this.nextKey(), this.getValue())) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(@NotNull BiPredicate<? super K, ? super V> predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextKey(), this.getValue())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public <U> Iterator<U> map(@NotNull BiFunction<? super K, ? super V, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new MapIterators.Mapped<U, K, V>(this, mapper);
    }

    @NotNull
    default public <NV> MapIterator<K, NV> mapValues(@NotNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return MapIterator.empty();
        }
        return new MapIterators.MapValues<K, NV, V>(this, mapper);
    }

    default public int hash() {
        int hash = 0;
        while (this.hasNext()) {
            hash += Objects.hashCode(this.nextKey()) ^ Objects.hashCode(this.getValue());
        }
        return hash;
    }

    @NotNull
    default public Iterator<K> asKeysIterator() {
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new MapIterators.KeysIterator(this);
    }

    @NotNull
    default public Iterator<V> asValuesIterator() {
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new MapIterators.ValuesIterator(this);
    }

    default public void forEach(@NotNull BiConsumer<? super K, ? super V> action) {
        while (this.hasNext()) {
            action.accept(this.nextKey(), this.getValue());
        }
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedBiConsumer<? super K, ? super V, ? extends Ex> action) throws Ex {
        this.forEach(action);
    }

    default public void forEachUnchecked(@NotNull CheckedBiConsumer<? super K, ? super V, ?> action) {
        this.forEach(action);
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer) {
        return this.joinTo(buffer, ", ");
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator) {
        return this.joinTo(buffer, separator, "", "");
    }

    @Contract(value="_, _, _, _ -> param1", mutates="param1")
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        try {
            buffer.append(prefix);
            if (this.hasNext()) {
                buffer.append(Objects.toString(this.nextKey())).append("=").append(Objects.toString(this.getValue()));
            }
            while (this.hasNext()) {
                buffer.append(separator).append(Objects.toString(this.nextKey())).append("=").append(Objects.toString(this.getValue()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        return this.joinTo(buffer, ", ", transform);
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        return this.joinTo(buffer, separator, "", "", transform);
    }

    @Contract(value="_, _, _, _, _ -> param1", mutates="param1")
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        try {
            buffer.append(prefix);
            if (this.hasNext()) {
                buffer.append(transform.apply(this.nextKey(), this.getValue()));
            }
            while (this.hasNext()) {
                buffer.append(separator).append(transform.apply(this.nextKey(), this.getValue()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @NotNull
    default public String joinToString() {
        return this.joinTo(new StringBuilder()).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator) {
        return this.joinTo(new StringBuilder(), separator).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return this.joinTo(new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    default public String joinToString(@NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        return this.joinTo(new StringBuilder(), transform).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        return this.joinTo(new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull BiFunction<? super K, ? super V, ? extends CharSequence> transform) {
        return this.joinTo(new StringBuilder(), separator, prefix, postfix, transform).toString();
    }
}

