/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.base.GenericArrays;
import kala.collection.base.Iterators;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import kala.control.Option;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedFunction;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectArrays {
    public static final Object[] EMPTY = new Object[0];
    private static final IntFunction<Object[]> GENERATOR = Object[]::new;
    private static final CollectionFactory<Object, ?, Object[]> FACTORY = GenericArrays.factory(Object.class);

    private ObjectArrays() {
    }

    @Contract(pure=true)
    @NotNull
    public static IntFunction<Object[]> generator() {
        return GENERATOR;
    }

    @Contract(pure=true)
    @NotNull
    public static CollectionFactory<Object, ?, Object[]> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    public static Object @NotNull [] create(int length) {
        return new Object[length];
    }

    @Contract(value="_ -> param1", pure=true)
    public static Object @NotNull [] of(Object ... values) {
        return values;
    }

    public static Object @NotNull [] from(Object @NotNull [] values) {
        return values.length == 0 ? EMPTY : Arrays.copyOf(values, values.length, Object[].class);
    }

    public static Object @NotNull [] from(@NotNull Iterable<?> values) {
        Objects.requireNonNull(values);
        if (values instanceof Collection) {
            return ((Collection)values).toArray();
        }
        if (values instanceof Traversable) {
            return ((Traversable)values).toArray();
        }
        ArrayList tmp = new ArrayList();
        for (Object e : values) {
            tmp.add(e);
        }
        return tmp.toArray();
    }

    public static Object @NotNull [] from(@NotNull Iterator<?> it) {
        return Iterators.toArray(it);
    }

    public static Object @NotNull [] from(@NotNull Stream<?> stream) {
        return stream.toArray(GENERATOR);
    }

    public static Object @NotNull [] fill(int n, Object value) {
        if (n <= 0) {
            return EMPTY;
        }
        Object[] res = new Object[n];
        if (value != null) {
            Arrays.fill(res, value);
        }
        return res;
    }

    public static Object @NotNull [] fill(int n, @NotNull Supplier<?> supplier) {
        if (n <= 0) {
            return EMPTY;
        }
        Object[] res = new Object[n];
        for (int i = 0; i < n; ++i) {
            res[i] = supplier.get();
        }
        return res;
    }

    public static Object @NotNull [] fill(int n, @NotNull IntFunction<?> supplier) {
        if (n <= 0) {
            return EMPTY;
        }
        Object[] res = new Object[n];
        for (int i = 0; i < n; ++i) {
            res[i] = supplier.apply(i);
        }
        return res;
    }

    @NotNull
    public static String className(Object @NotNull [] array) {
        return "java.lang.Object[]";
    }

    @NotNull
    public static Iterator<Object> iterator(Object @NotNull [] array) {
        return GenericArrays.iterator(array);
    }

    @NotNull
    public static Iterator<Object> iterator(Object @NotNull [] array, int beginIndex) {
        return GenericArrays.iterator(array, beginIndex);
    }

    @NotNull
    public static Iterator<Object> iterator(Object @NotNull [] array, int beginIndex, int endIndex) {
        return GenericArrays.iterator(array, beginIndex, endIndex);
    }

    @NotNull
    public static Spliterator<Object> spliterator(Object @NotNull [] array) {
        return Arrays.spliterator(array);
    }

    @NotNull
    public static Stream<Object> stream(Object @NotNull [] array) {
        return Arrays.stream(array);
    }

    @NotNull
    public static Stream<Object> parallelStream(Object @NotNull [] array) {
        return (Stream)Arrays.stream(array).parallel();
    }

    public static boolean isEmpty(Object @NotNull [] array) {
        return array.length == 0;
    }

    public static int size(Object @NotNull [] array) {
        return array.length;
    }

    public static int knownSize(Object @NotNull [] array) {
        return array.length;
    }

    public static boolean isDefineAt(Object @NotNull [] array, int index) {
        return index >= 0 && index <= array.length;
    }

    public static Object get(Object @NotNull [] array, int index) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Nullable
    public static Object getOrNull(Object @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? array[index] : null;
    }

    @NotNull
    public static Option<Object> getOption(Object @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? Option.some(array[index]) : Option.none();
    }

    public static void set(Object @NotNull [] array, int index, Object value) {
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public static Object @NotNull [] reversed(Object @NotNull [] array) {
        int length = array.length;
        Object[] res = new Object[length];
        for (int i = 0; i < length; ++i) {
            res[i] = array[length - i - 1];
        }
        return res;
    }

    @NotNull
    public static Iterator<Object> reverseIterator(Object @NotNull [] array) {
        return GenericArrays.iterator(array);
    }

    public static void shuffle(Object @NotNull [] array) {
        ObjectArrays.shuffle(array, ThreadLocalRandom.current());
    }

    public static void shuffle(Object @NotNull [] array, @NotNull Random random) {
        int size = array.length;
        if (size <= 1) {
            return;
        }
        for (int i = size; i > 1; --i) {
            int k = random.nextInt(i);
            Object tmp = array[i - 1];
            array[i - 1] = array[k];
            array[k] = tmp;
        }
    }

    @NotNull
    public static Option<Object> find(Object @NotNull [] array, @NotNull Predicate predicate) {
        for (Object e : array) {
            if (!predicate.test(e)) continue;
            return Option.some(e);
        }
        return Option.none();
    }

    public static Object first(Object @NotNull [] array) {
        try {
            return array[0];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    public static Object last(Object @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        return array[length - 1];
    }

    public static boolean contains(Object @NotNull [] array, Object value) {
        if (value == null) {
            for (Object o : array) {
                if (null != o) continue;
                return true;
            }
        } else {
            for (Object o : array) {
                if (!value.equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(Object @NotNull [] array, Object @NotNull [] values) {
        for (Object value : values) {
            if (ObjectArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Object @NotNull [] array, @NotNull Iterable<?> values) {
        for (Object value : values) {
            if (ObjectArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatch(Object @NotNull [] array, @NotNull Predicate<?> predicate) {
        for (Object e : array) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean allMatch(Object @NotNull [] array, @NotNull Predicate<?> predicate) {
        for (Object e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneMatch(Object @NotNull [] array, @NotNull Predicate<?> predicate) {
        for (Object e : array) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(Object @NotNull [] array, Object value) {
        int length = array.length;
        if (value == null) {
            for (int i = 0; i < length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(Object @NotNull [] array, Object value, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        if (value == null) {
            for (int i = Math.max(beginIndex, 0); i < length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = Math.max(beginIndex, 0); i < length; ++i) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(Object @NotNull [] array, @NotNull Predicate<?> predicate) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(Object @NotNull [] array, @NotNull Predicate<?> predicate, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(Object @NotNull [] array, Object value) {
        if (value == null) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(Object @NotNull [] array, Object value, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        if (value == null) {
            for (int i = Integer.min(endIndex, array.length - 1); i >= 0; --i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = Integer.min(endIndex, array.length - 1); i >= 0; --i) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(Object @NotNull [] array, @NotNull Predicate<?> predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(Object @NotNull [] array, @NotNull Predicate<?> predicate, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static Object @NotNull [] slice(Object @NotNull [] array, int beginIndex, int endIndex) {
        int length = array.length;
        Conditions.checkPositionIndices(beginIndex, endIndex, length);
        int newLength = endIndex - beginIndex;
        if (newLength == 0) {
            return EMPTY;
        }
        Object[] res = new Object[newLength];
        System.arraycopy(array, beginIndex, res, 0, newLength);
        return res;
    }

    public static Object @NotNull [] drop(Object @NotNull [] array, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return EMPTY;
        }
        int length = array.length;
        if (n >= length) {
            return EMPTY;
        }
        return Arrays.copyOfRange(array, n, array.length);
    }

    public static Object @NotNull [] dropLast(Object @NotNull [] array, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (Object[])array.clone();
        }
        return ObjectArrays.take(array, array.length - n);
    }

    public static Object @NotNull [] dropWhile(Object @NotNull [] array, @NotNull Predicate<?> predicate) {
        int idx;
        int length = array.length;
        for (idx = 0; idx < length && predicate.test(array[idx]); ++idx) {
        }
        return idx >= length ? EMPTY : Arrays.copyOfRange(array, idx, length);
    }

    public static Object @NotNull [] take(Object @NotNull [] array, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return EMPTY;
        }
        int length = array.length;
        if (n >= length) {
            return (Object[])array.clone();
        }
        return Arrays.copyOfRange(array, 0, n);
    }

    public static Object @NotNull [] takeLast(Object @NotNull [] array, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return EMPTY;
        }
        return ObjectArrays.drop(array, array.length - n);
    }

    public static Object @NotNull [] takeWhile(Object @NotNull [] array, @NotNull Predicate<?> predicate) {
        int count;
        int length = array.length;
        if (length == 0) {
            return (Object[])array.clone();
        }
        for (count = 0; count < length && predicate.test(array[count]); ++count) {
        }
        if (count == 0) {
            return EMPTY;
        }
        return Arrays.copyOf(array, count);
    }

    public static Object @NotNull [] updated(Object @NotNull [] array, int index, Object newValue) {
        int size = array.length;
        Conditions.checkElementIndex(index, size);
        Object[] newValues = (Object[])array.clone();
        newValues[index] = newValue;
        return newValues;
    }

    public static Object @NotNull [] concat(Object @NotNull [] a, Object @NotNull [] b) {
        Object[] dest = new Object[a.length + b.length];
        System.arraycopy(a, 0, dest, 0, a.length);
        System.arraycopy(b, 0, dest, a.length, b.length);
        return dest;
    }

    public static Object @NotNull [] filter(Object @NotNull [] array, @NotNull Predicate<?> predicate) {
        int length = array.length;
        if (length == 0) {
            return (Object[])array.clone();
        }
        Object[] tmp = new Object[length];
        int count = 0;
        for (Object e : array) {
            if (!predicate.test(e)) continue;
            tmp[count++] = e;
        }
        if (count == 0) {
            return EMPTY;
        }
        if (count == length) {
            return tmp;
        }
        return Arrays.copyOf(array, count);
    }

    public static Object @NotNull [] filterNot(Object @NotNull [] array, @NotNull Predicate<?> predicate) {
        int length = array.length;
        if (length == 0) {
            return EMPTY;
        }
        Object[] tmp = new Object[length];
        int count = 0;
        for (Object e : array) {
            if (predicate.test(e)) continue;
            tmp[count++] = e;
        }
        if (count == 0) {
            return EMPTY;
        }
        if (count == length) {
            return tmp;
        }
        return Arrays.copyOf(array, count);
    }

    @NotNull
    public static @NotNull Object @NotNull [] filterNotNull(Object @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            return (Object[])array.clone();
        }
        Object[] tmp = new Object[length];
        int count = 0;
        for (Object e : array) {
            if (e == null) continue;
            tmp[count++] = e;
        }
        if (count == 0) {
            return EMPTY;
        }
        if (count == length) {
            return tmp;
        }
        return Arrays.copyOf(array, count);
    }

    public static Object @NotNull [] map(Object @NotNull [] array, @NotNull Function<?, ?> mapper) {
        int length = array.length;
        Object[] res = new Object[length];
        for (int i = 0; i < length; ++i) {
            res[i] = mapper.apply(array[i]);
        }
        return res;
    }

    public static Object @NotNull [] mapIndexed(Object @NotNull [] array, @NotNull IndexedFunction<?, ?> mapper) {
        int length = array.length;
        Object[] res = new Object[length];
        for (int i = 0; i < length; ++i) {
            res[i] = mapper.apply(i, array[i]);
        }
        return res;
    }

    @NotNull
    public static @NotNull Object @NotNull [] mapNotNull(Object @NotNull [] array, @NotNull Function<?, ?> mapper) {
        int length = array.length;
        if (length == 0) {
            return EMPTY;
        }
        Object[] tmp = new Object[length];
        int c = 0;
        for (Object e : array) {
            Object u = mapper.apply(e);
            if (u == null) continue;
            tmp[c++] = u;
        }
        if (c == length) {
            return tmp;
        }
        return Arrays.copyOf(tmp, c);
    }

    @NotNull
    public static @NotNull Object @NotNull [] mapIndexedNotNull(Object @NotNull [] array, @NotNull IndexedFunction<?, ?> mapper) {
        int length = array.length;
        if (length == 0) {
            return EMPTY;
        }
        Object[] tmp = new Object[length];
        int c = 0;
        for (int i = 0; i < length; ++i) {
            Object u = mapper.apply(i, array[i]);
            if (u == null) continue;
            tmp[c++] = u;
        }
        if (c == length) {
            return tmp;
        }
        return Arrays.copyOf(tmp, c);
    }

    public static Object @NotNull [] mapMulti(Object @NotNull [] array, @NotNull BiConsumer<?, ? super Consumer<? super Object>> mapper) {
        if (array.length == 0) {
            return EMPTY;
        }
        ArrayList tmp = new ArrayList();
        Consumer<Object> consumer = tmp::add;
        for (Object o : array) {
            mapper.accept(o, consumer);
        }
        return tmp.toArray();
    }

    public static Object @NotNull [] mapIndexedMulti(Object @NotNull [] array, @NotNull IndexedBiConsumer<?, ? super Consumer<? super Object>> mapper) {
        int length = array.length;
        if (length == 0) {
            return EMPTY;
        }
        ArrayList tmp = new ArrayList();
        Consumer<Object> consumer = tmp::add;
        for (int i = 0; i < length; ++i) {
            mapper.accept(i, array[i], consumer);
        }
        return tmp.toArray();
    }

    public static Object @NotNull [] flatMap(Object @NotNull [] array, @NotNull Function<?, ? extends Iterable<?>> mapper) {
        if (array.length == 0) {
            return EMPTY;
        }
        ArrayList tmp = new ArrayList();
        for (Object e : array) {
            for (Object u : mapper.apply(e)) {
                tmp.add(u);
            }
        }
        return tmp.toArray();
    }

    public static Tuple2<Object, Object> @NotNull [] zip(Object @NotNull [] array, Object @NotNull [] other) {
        int length = Integer.min(array.length, other.length);
        Tuple2[] res = new Tuple2[length];
        for (int i = 0; i < length; ++i) {
            res[i] = Tuple.of(array[i], other[i]);
        }
        return res;
    }

    public static Tuple2<Object, Object> @NotNull [] zip(Object @NotNull [] array, Iterable<?> other) {
        int count;
        int length = array.length;
        Tuple2[] tmp = new Tuple2[length];
        if (length == 0) {
            return tmp;
        }
        Iterator<?> it = other.iterator();
        for (count = 0; count < length && it.hasNext(); ++count) {
            tmp[count] = Tuple.of(array[count], it.next());
        }
        return count == length ? tmp : Arrays.copyOf(tmp, count);
    }

    public static Object @NotNull [] @NotNull [] chunked(Object @NotNull [] array, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        int arrayLength = array.length;
        if (arrayLength == 0) {
            return new Object[0][];
        }
        int x = arrayLength / size;
        int r = arrayLength % size;
        Object[][] res = new Object[r == 0 ? x : x + 1][];
        for (int i = 0; i < x; ++i) {
            res[i] = Arrays.copyOfRange(array, i * size, (i + 1) * size);
        }
        if (r != 0) {
            res[x] = Arrays.copyOfRange(array, x * size, x * size + r);
        }
        return res;
    }

    public static Object @NotNull [] @NotNull [] windowed(Object @NotNull [] array, int size) {
        return ObjectArrays.windowed(array, size, 1, false);
    }

    public static Object @NotNull [] @NotNull [] windowed(Object @NotNull [] array, int size, int step) {
        return ObjectArrays.windowed(array, size, step, false);
    }

    public static Object @NotNull [] @NotNull [] windowed(Object @NotNull [] array, int size, int step, boolean partialWindows) {
        int windowSize;
        int arrayLength = array.length;
        if (size <= 0 || step <= 0) {
            if (size == step) {
                throw new IllegalArgumentException("size " + size + " must be greater than zero.");
            }
            throw new IllegalArgumentException("Both size " + size + " and step " + step + " must be greater than zero.");
        }
        int resultCapacity = arrayLength / step + (arrayLength % step == 0 ? 0 : 1);
        Object[][] ans = new Object[resultCapacity][];
        int ansi = 0;
        for (int index = 0; index < arrayLength && ((windowSize = Integer.min(size, arrayLength - index)) >= size || partialWindows); index += step) {
            ans[ansi++] = Arrays.copyOfRange(array, index, windowSize + index);
        }
        return (Object[][])Arrays.copyOf(ans, ansi);
    }

    public static int count(Object @NotNull [] array, @NotNull Predicate<?> predicate) {
        Predicate<?> p = predicate;
        int count = 0;
        for (Object e : array) {
            if (!p.test(e)) continue;
            ++count;
        }
        return count;
    }

    public static Object max(Object @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        Object e = array[0];
        for (int i = 1; i < length; ++i) {
            Object v = array[i];
            if (((Comparable)e).compareTo(v) >= 0) continue;
            e = v;
        }
        return e;
    }

    @Nullable
    public static Object maxOrNull(Object @NotNull [] array) {
        return array.length != 0 ? ObjectArrays.max(array) : null;
    }

    public static Object min(Object @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        Object e = array[0];
        for (int i = 1; i < length; ++i) {
            Object v = array[i];
            if (((Comparable)e).compareTo(v) <= 0) continue;
            e = v;
        }
        return e;
    }

    @Nullable
    public static Object minOrNull(Object @NotNull [] array) {
        return array.length != 0 ? ObjectArrays.min(array) : null;
    }

    @NotNull
    public static <A extends Appendable> A joinTo(Object @NotNull [] array, @NotNull A buffer) {
        return ObjectArrays.joinTo(array, buffer, ", ", "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(Object @NotNull [] array, @NotNull A buffer, CharSequence separator) {
        return ObjectArrays.joinTo(array, buffer, separator, "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(Object @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(Objects.toString(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(Objects.toString(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static <A extends Appendable> A joinTo(Object @NotNull [] array, @NotNull A buffer, @NotNull Function<?, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo(array, buffer, ", ", "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(Object @NotNull [] array, @NotNull A buffer, CharSequence separator, @NotNull Function<?, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo(array, buffer, separator, "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(Object @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<?, ? extends CharSequence> transform) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(transform.apply(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(transform.apply(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static String joinToString(Object @NotNull [] array) {
        return ObjectArrays.joinTo(array, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(Object @NotNull [] array, CharSequence separator) {
        return ObjectArrays.joinTo(array, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(Object @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return ObjectArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static String joinToString(Object @NotNull [] array, @NotNull Function<?, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo(array, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static String joinToString(Object @NotNull [] array, CharSequence separator, @NotNull Function<?, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo(array, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static String joinToString(Object @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<?, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }
}

