/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import kala.collection.base.GenericArrays;
import kala.collection.base.Iterators;
import kala.collection.base.Traversable;
import kala.control.Option;
import kala.function.CheckedIndexedConsumer;
import kala.function.IndexedBiFunction;
import kala.function.IndexedConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OrderedTraversable<E>
extends Traversable<E> {
    @NotNull
    default public Iterator<E> reverseIterator() {
        ArrayList buffer;
        int ks = this.knownSize();
        if (ks == 0) {
            return Iterators.empty();
        }
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        ArrayList<Object> arrayList = buffer = ks > 0 ? new ArrayList(ks) : new ArrayList();
        while (it.hasNext()) {
            buffer.add(it.next());
        }
        Iterator<Object> res = GenericArrays.reverseIterator(buffer.toArray());
        return res;
    }

    @Override
    @NotNull
    default public Option<E> find(@NotNull Predicate<? super E> predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public Option<E> findFirst(@NotNull Predicate<? super E> predicate) {
        return Iterators.firstOption(this.iterator(), predicate);
    }

    @NotNull
    default public Option<E> findLast(@NotNull Predicate<? super E> predicate) {
        return Iterators.firstOption(this.reverseIterator(), predicate);
    }

    default public E first() {
        return (E)this.iterator().next();
    }

    @Nullable
    default public E firstOrNull() {
        return this.isNotEmpty() ? (E)this.first() : null;
    }

    @NotNull
    default public Option<E> firstOption() {
        return this.isNotEmpty() ? Option.some(this.first()) : Option.none();
    }

    default public E last() {
        return this.reverseIterator().next();
    }

    @Nullable
    default public E lastOrNull() {
        return this.isNotEmpty() ? (E)this.last() : null;
    }

    @NotNull
    default public Option<E> lastOption() {
        return this.isNotEmpty() ? Option.some(this.last()) : Option.none();
    }

    default public E first(@NotNull Predicate<? super E> predicate) {
        return this.findFirst(predicate).get();
    }

    @Nullable
    default public E firstOrNull(@NotNull Predicate<? super E> predicate) {
        return (E)this.findFirst(predicate).getOrNull();
    }

    @NotNull
    default public Option<E> firstOption(@NotNull Predicate<? super E> predicate) {
        return this.findFirst(predicate);
    }

    default public E last(@NotNull Predicate<? super E> predicate) {
        return this.findLast(predicate).get();
    }

    @Nullable
    default public E lastOrNull(@NotNull Predicate<? super E> predicate) {
        return (E)this.findLast(predicate).getOrNull();
    }

    @NotNull
    default public Option<E> lastOption(@NotNull Predicate<? super E> predicate) {
        return this.findLast(predicate);
    }

    @Contract(pure=true)
    default public int indexOf(Object value) {
        int idx = 0;
        if (value == null) {
            for (Object e : this) {
                if (null == e) {
                    return idx;
                }
                ++idx;
            }
        } else {
            for (Object e : this) {
                if (value.equals(e)) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(Object value, int from) {
        int idx = 0;
        if (value == null) {
            for (Object e : this) {
                if (idx >= from && null == e) {
                    return idx;
                }
                ++idx;
            }
        } else {
            for (Object e : this) {
                if (idx >= from && value.equals(e)) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull Predicate<? super E> predicate) {
        int idx = 0;
        for (Object e : this) {
            if (predicate.test(e)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull Predicate<? super E> predicate, int from) {
        int idx = 0;
        for (Object e : this) {
            if (idx >= from && predicate.test(e)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(Object value) {
        int idx = this.size() - 1;
        Iterator<E> it = this.reverseIterator();
        if (value == null) {
            while (it.hasNext()) {
                if (null == it.next()) {
                    return idx;
                }
                --idx;
            }
        } else {
            while (it.hasNext()) {
                if (value.equals(it.next())) {
                    return idx;
                }
                --idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(Object value, int end) {
        int idx = this.size() - 1;
        Iterator<E> it = this.reverseIterator();
        if (value == null) {
            while (it.hasNext()) {
                if (idx <= end && null == it.next()) {
                    return idx;
                }
                --idx;
            }
        } else {
            while (it.hasNext()) {
                if (idx <= end && value.equals(it.next())) {
                    return idx;
                }
                --idx;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull Predicate<? super E> predicate) {
        int idx = this.size() - 1;
        Iterator<E> it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.next())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull Predicate<? super E> predicate, int end) {
        int idx = this.size() - 1;
        Iterator<E> it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.next())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    default public E foldIndexed(E zero, @NotNull IndexedBiFunction<? super E, ? super E, ? extends E> op) {
        return this.foldLeftIndexed(zero, op);
    }

    default public <U> U foldLeftIndexed(U zero, @NotNull IndexedBiFunction<? super U, ? super E, ? extends U> op) {
        return Iterators.foldLeftIndexed(this.iterator(), zero, op);
    }

    default public <U> U foldRightIndexed(U zero, @NotNull IndexedBiFunction<? super E, ? super U, ? extends U> op) {
        return Iterators.foldRightIndexed(this.iterator(), zero, op);
    }

    @Override
    default public E reduceRight(@NotNull BiFunction<? super E, ? super E, ? extends E> op) throws NoSuchElementException {
        Iterator<E> it = this.reverseIterator();
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        E e = it.next();
        while (it.hasNext()) {
            e = op.apply(it.next(), e);
        }
        return e;
    }

    default public void forEachIndexed(@NotNull IndexedConsumer<? super E> action) {
        int idx = 0;
        for (Object e : this) {
            action.accept(idx++, e);
        }
    }

    default public <Ex extends Throwable> void forEachIndexedChecked(@NotNull CheckedIndexedConsumer<? super E, ? extends Ex> action) throws Ex {
        this.forEachIndexed(action);
    }

    default public void forEachIndexedUnchecked(@NotNull CheckedIndexedConsumer<? super E, ?> action) {
        this.forEachIndexed(action);
    }
}

