/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kala.collection.base.AnyTraversable;
import kala.collection.base.GenericArrays;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.base.ObjectArrays;
import kala.collection.base.primitive.DoubleGrowable;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.base.primitive.IntGrowable;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.base.primitive.LongGrowable;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.CollectionBuilder;
import kala.collection.factory.CollectionFactory;
import kala.collection.factory.primitive.DoubleCollectionBuilder;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.factory.primitive.IntCollectionBuilder;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.factory.primitive.LongCollectionBuilder;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.comparator.Comparators;
import kala.concurrent.ConcurrentScope;
import kala.concurrent.Granularity;
import kala.concurrent.LateInitCountDownLatch;
import kala.control.Option;
import kala.function.CheckedBiConsumer;
import kala.function.CheckedBiFunction;
import kala.function.CheckedConsumer;
import kala.function.CheckedPredicate;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.value.primitive.IntVar;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface Traversable<T>
extends Iterable<T>,
AnyTraversable<T> {
    @Contract(value="_ -> param1", pure=true)
    public static <T> Traversable<T> narrow(Traversable<? extends T> traversable) {
        return traversable;
    }

    public static <T> Traversable<T> wrap(@NotNull Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        if (iterable instanceof Traversable) {
            return Traversable.narrow((Traversable)iterable);
        }
        return iterable::iterator;
    }

    @Override
    @NotNull
    default public Traversable<T> asGeneric() {
        return this;
    }

    @Override
    @NotNull
    public Iterator<T> iterator();

    @Override
    default public Spliterator<T> spliterator() {
        return AnyTraversable.super.spliterator();
    }

    @NotNull
    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @NotNull
    default public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    default public T elementAt(int index) {
        Iterator<T> it = this.iterator();
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            it.next();
        }
        if (it.hasNext()) {
            return it.next();
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    @NotNull
    default public Option<T> find(@NotNull Predicate<? super T> predicate) {
        for (T t : this) {
            if (!predicate.test(t)) continue;
            return Option.some(t);
        }
        return Option.none();
    }

    default public boolean contains(Object value) {
        return Iterators.contains(this.iterator(), value);
    }

    default public boolean containsAll(Object @NotNull [] values) {
        for (Object value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(@NotNull Iterable<?> values) {
        for (Object value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull Iterable<?> other) {
        return Iterators.sameElements(this.iterator(), other.iterator());
    }

    default public boolean sameElements(@NotNull Iterable<?> other, boolean identity) {
        if (!identity) {
            return this.sameElements(other);
        }
        return Iterators.sameElements(this.iterator(), other.iterator(), true);
    }

    default public boolean anyMatch(@NotNull Predicate<? super T> predicate) {
        return Iterators.anyMatch(this.iterator(), predicate);
    }

    default public boolean allMatch(@NotNull Predicate<? super T> predicate) {
        return Iterators.allMatch(this.iterator(), predicate);
    }

    default public boolean noneMatch(@NotNull Predicate<? super T> predicate) {
        return Iterators.noneMatch(this.iterator(), predicate);
    }

    default public <U> boolean anyMatchWith(@NotNull Iterable<? extends U> other, @NotNull BiPredicate<? super T, ? super U> predicate) {
        return Iterators.anyMatchWith(this.iterator(), other.iterator(), predicate);
    }

    default public <U> boolean allMatchWith(@NotNull Iterable<? extends U> other, @NotNull BiPredicate<? super T, ? super U> predicate) {
        return Iterators.allMatchWith(this.iterator(), other.iterator(), predicate);
    }

    default public <U> boolean noneMatchWith(@NotNull Iterable<? extends U> other, @NotNull BiPredicate<? super T, ? super U> predicate) {
        return Iterators.noneMatchWith(this.iterator(), other.iterator(), predicate);
    }

    default public <R> R filter(@NotNull CollectionFactory<T, ?, R> factory, @NotNull Predicate<? super T> predicate) {
        return this.filterTo(factory.newCollectionBuilder(), predicate).build();
    }

    default public <R> R filterNot(@NotNull CollectionFactory<T, ?, R> factory, @NotNull Predicate<? super T> predicate) {
        return this.filterNotTo(factory.newCollectionBuilder(), predicate).build();
    }

    default public <R> R filterNotNull(@NotNull CollectionFactory<T, ?, R> factory) {
        return this.filterNotNullTo(factory.newCollectionBuilder()).build();
    }

    default public <U, R> R filterIsInstance(@NotNull CollectionFactory<U, ?, R> factory, Class<? extends U> clazz) {
        return this.filterIsInstanceTo(factory.newCollectionBuilder(), clazz).build();
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends Growable<? super T>> G filterTo(@NotNull G destination, @NotNull Predicate<? super T> predicate) {
        for (T e : this) {
            if (!predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends Growable<? super T>> G filterNotTo(@NotNull G destination, @NotNull Predicate<? super T> predicate) {
        for (T e : this) {
            if (predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_ -> param1", mutates="param1")
    @NotNull
    default public <G extends Growable<? super T>> G filterNotNullTo(@NotNull G destination) {
        for (T e : this) {
            if (e == null) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G filterIsInstanceTo(@NotNull G destination, @NotNull Class<? extends U> clazz) {
        for (T value : this) {
            if (!clazz.isInstance(value)) continue;
            destination.plusAssign(value);
        }
        return destination;
    }

    default public <U, R> R map(@NotNull CollectionFactory<U, ?, R> factory, @NotNull Function<? super T, ? extends U> mapper) {
        return this.mapTo(factory.newCollectionBuilder(this.knownSize()), mapper).build();
    }

    default public <R> R mapToInt(@NotNull IntCollectionFactory<?, R> factory, @NotNull ToIntFunction<? super T> mapper) {
        return IntCollectionFactory.buildBy(factory, consumer -> {
            for (T e : this) {
                consumer.accept(mapper.applyAsInt((T)e));
            }
        });
    }

    default public <R> R mapToLong(@NotNull LongCollectionFactory<?, R> factory, @NotNull ToLongFunction<? super T> mapper) {
        return LongCollectionFactory.buildBy(factory, consumer -> {
            for (T e : this) {
                consumer.accept(mapper.applyAsLong((T)e));
            }
        });
    }

    default public <R> R mapToDouble(@NotNull DoubleCollectionFactory<?, R> factory, @NotNull ToDoubleFunction<? super T> mapper) {
        return DoubleCollectionFactory.buildBy(factory, consumer -> {
            for (T e : this) {
                consumer.accept(mapper.applyAsDouble((T)e));
            }
        });
    }

    default public <U, R> R mapNotNull(@NotNull CollectionFactory<U, ?, R> factory, @NotNull Function<? super T, ? extends U> mapper) {
        return this.mapNotNullTo(factory.newCollectionBuilder(this.knownSize()), mapper).build();
    }

    @NotNull
    default public <U, R> R mapMulti(@NotNull CollectionFactory<U, ?, R> factory, @NotNull BiConsumer<? super T, ? super Consumer<? super U>> mapper) {
        return this.mapMultiTo(factory.newCollectionBuilder(), mapper).build();
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapTo(@NotNull G destination, @NotNull Function<? super T, ? extends U> mapper) {
        for (T e : this) {
            destination.plusAssign(mapper.apply(e));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends IntGrowable> G mapToIntTo(@NotNull G destination, @NotNull ToIntFunction<? super T> mapper) {
        for (T e : this) {
            destination.plusAssign(mapper.applyAsInt(e));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends LongGrowable> G mapToLongTo(@NotNull G destination, @NotNull ToLongFunction<? super T> mapper) {
        for (T e : this) {
            destination.plusAssign(mapper.applyAsLong(e));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends DoubleGrowable> G mapToDoubleTo(@NotNull G destination, @NotNull ToDoubleFunction<? super T> mapper) {
        for (T e : this) {
            destination.plusAssign(mapper.applyAsDouble(e));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapNotNullTo(@NotNull G destination, @NotNull Function<? super T, ? extends U> mapper) {
        for (T e : this) {
            U u = mapper.apply(e);
            if (u == null) continue;
            destination.plusAssign(u);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapMultiTo(@NotNull G destination, @NotNull BiConsumer<? super T, ? super Consumer<? super U>> mapper) {
        CollectionBuilder consumer = destination instanceof CollectionBuilder ? (CollectionBuilder)destination : destination::plusAssign;
        for (T value : this) {
            mapper.accept(value, consumer);
        }
        return destination;
    }

    @NotNull
    default public <U, R> R flatMap(@NotNull CollectionFactory<U, ?, R> factory, @NotNull Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return this.flatMapTo(factory.newCollectionBuilder(), mapper).build();
    }

    @NotNull
    default public <R> R flatMapToInt(@NotNull IntCollectionFactory<?, R> factory, @NotNull Function<? super T, ? extends IntTraversable> mapper) {
        return ((IntCollectionBuilder)this.flatMapToIntTo(factory.newCollectionBuilder(), mapper)).build();
    }

    @NotNull
    default public <R> R flatMapToLong(@NotNull LongCollectionFactory<?, R> factory, @NotNull Function<? super T, ? extends LongTraversable> mapper) {
        return ((LongCollectionBuilder)this.flatMapToLongTo(factory.newCollectionBuilder(), mapper)).build();
    }

    @NotNull
    default public <R> R flatMapToDouble(@NotNull DoubleCollectionFactory<?, R> factory, @NotNull Function<? super T, ? extends DoubleTraversable> mapper) {
        return ((DoubleCollectionBuilder)this.flatMapToDoubleTo(factory.newCollectionBuilder(), mapper)).build();
    }

    default public <U, G extends Growable<? super U>> G flatMapTo(@NotNull G destination, @NotNull Function<? super T, ? extends Iterable<? extends U>> mapper) {
        for (T value : this) {
            destination.plusAssign(mapper.apply(value));
        }
        return destination;
    }

    default public <U, G extends IntGrowable> G flatMapToIntTo(@NotNull G destination, @NotNull Function<? super T, ? extends IntTraversable> mapper) {
        for (T value : this) {
            destination.plusAssign(mapper.apply(value));
        }
        return destination;
    }

    default public <U, G extends LongGrowable> G flatMapToLongTo(@NotNull G destination, @NotNull Function<? super T, ? extends LongTraversable> mapper) {
        for (T value : this) {
            destination.plusAssign(mapper.apply(value));
        }
        return destination;
    }

    default public <U, G extends DoubleGrowable> G flatMapToDoubleTo(@NotNull G destination, @NotNull Function<? super T, ? extends DoubleTraversable> mapper) {
        for (T value : this) {
            destination.plusAssign(mapper.apply(value));
        }
        return destination;
    }

    default public <R> Tuple2<R, R> partition(@NotNull CollectionFactory<T, ?, R> factory, @NotNull Predicate<? super T> predicate) {
        CollectionFactory<T, ?, R> uncheckedFactory = factory;
        Object builder1 = uncheckedFactory.newBuilder();
        Object builder2 = uncheckedFactory.newBuilder();
        for (T e : this) {
            Object builder = predicate.test(e) ? builder1 : builder2;
            uncheckedFactory.addToBuilder(builder, e);
        }
        return Tuple.of(uncheckedFactory.build(builder1), uncheckedFactory.build(builder2));
    }

    default public <R> R distinct(@NotNull CollectionFactory<T, ?, R> factory) {
        return this.distinctTo(factory.newCollectionBuilder()).build();
    }

    default public <U, R> R distinctBy(@NotNull CollectionFactory<T, ?, R> factory, Function<? super T, ? extends U> mapper) {
        return this.distinctByTo(factory.newCollectionBuilder(), mapper).build();
    }

    default public <R> R distinctByInt(@NotNull CollectionFactory<T, ?, R> factory, ToIntFunction<? super T> mapper) {
        return this.distinctByIntTo(factory.newCollectionBuilder(), mapper).build();
    }

    @NotNull
    default public <G extends Growable<? super T>> G distinctTo(G destination) {
        HashSet<T> iteratedValues = new HashSet<T>();
        for (T value : this) {
            if (!iteratedValues.add(value)) continue;
            destination.plusAssign(value);
        }
        return destination;
    }

    @NotNull
    default public <U, G extends Growable<? super T>> G distinctByTo(G destination, Function<? super T, ? extends U> mapper) {
        HashSet<U> iteratedValues = new HashSet<U>();
        for (T value : this) {
            if (!iteratedValues.add(mapper.apply(value))) continue;
            destination.plusAssign(value);
        }
        return destination;
    }

    @NotNull
    default public <G extends Growable<? super T>> G distinctByIntTo(G destination, ToIntFunction<? super T> mapper) {
        HashSet<Integer> iteratedValues = new HashSet<Integer>();
        for (T value : this) {
            if (!iteratedValues.add(mapper.applyAsInt(value))) continue;
            destination.plusAssign(value);
        }
        return destination;
    }

    default public int count(@NotNull Predicate<? super T> predicate) {
        return Iterators.count(this.iterator(), predicate);
    }

    default public T max() {
        return this.max(Comparators.naturalOrder());
    }

    default public T max(Comparator<? super T> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return Iterators.max(this.iterator(), comparator);
    }

    @Nullable
    default public T maxOrNull() {
        return this.isNotEmpty() ? (T)this.max() : null;
    }

    @Nullable
    default public T maxOrNull(@NotNull Comparator<? super T> comparator) {
        return this.isNotEmpty() ? (T)this.max(comparator) : null;
    }

    @NotNull
    default public Option<T> maxOption() {
        return this.isNotEmpty() ? Option.some(this.max()) : Option.none();
    }

    @NotNull
    default public Option<T> maxOption(Comparator<? super T> comparator) {
        return this.isNotEmpty() ? Option.some(this.max(comparator)) : Option.none();
    }

    default public T min() {
        return this.min(Comparators.naturalOrder());
    }

    default public T min(Comparator<? super T> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return Iterators.min(this.iterator(), comparator);
    }

    @Nullable
    default public T minOrNull() {
        return this.isNotEmpty() ? (T)this.min() : null;
    }

    @Nullable
    default public T minOrNull(@NotNull Comparator<? super T> comparator) {
        return this.isNotEmpty() ? (T)this.min(comparator) : null;
    }

    @NotNull
    default public Option<T> minOption() {
        return this.isNotEmpty() ? Option.some(this.min()) : Option.none();
    }

    @NotNull
    default public Option<T> minOption(Comparator<? super T> comparator) {
        return this.isNotEmpty() ? Option.some(this.min(comparator)) : Option.none();
    }

    default public T fold(T zero, @NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op);
        return this.foldLeft(zero, op);
    }

    default public <U> U foldLeft(U zero, @NotNull BiFunction<? super U, ? super T, ? extends U> op) {
        return Iterators.foldLeft(this.iterator(), zero, op);
    }

    default public <U> U foldRight(U zero, @NotNull BiFunction<? super T, ? super U, ? extends U> op) {
        return Iterators.foldRight(this.iterator(), zero, op);
    }

    default public <Ex extends Throwable> T foldChecked(T zero, @NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ? extends Ex> op) throws Ex {
        return this.fold(zero, op);
    }

    default public T foldUnchecked(T zero, @NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ?> op) {
        return this.fold(zero, op);
    }

    default public <U, Ex extends Throwable> U foldLeftChecked(U zero, @NotNull CheckedBiFunction<? super U, ? super T, ? extends U, ? extends Ex> op) throws Ex {
        return this.foldLeft(zero, op);
    }

    default public <U> U foldLeftUnchecked(U zero, @NotNull CheckedBiFunction<? super U, ? super T, ? extends U, ?> op) {
        return this.foldLeft(zero, op);
    }

    default public <U, Ex extends Throwable> U foldRightChecked(U zero, @NotNull CheckedBiFunction<? super T, ? super U, ? extends U, ? extends Ex> op) throws Ex {
        return this.foldRight(zero, op);
    }

    default public <U> U foldRightUnchecked(U zero, @NotNull CheckedBiFunction<? super T, ? super U, ? extends U, ?> op) {
        return this.foldRight(zero, op);
    }

    default public T reduce(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public T reduceOrNull(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public Option<T> reduceOption(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        return this.reduceLeftOption(op);
    }

    default public T reduceLeft(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        return Iterators.reduceLeft(this.iterator(), op);
    }

    @Nullable
    default public T reduceLeftOrNull(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        return this.isNotEmpty() ? (T)this.reduceLeft(op) : null;
    }

    @NotNull
    default public Option<T> reduceLeftOption(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        return this.isNotEmpty() ? Option.some(this.reduceLeft(op)) : Option.none();
    }

    default public T reduceRight(@NotNull BiFunction<? super T, ? super T, ? extends T> op) throws NoSuchElementException {
        return Iterators.reduceRight(this.iterator(), op);
    }

    @Nullable
    default public T reduceRightOrNull(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        return this.isNotEmpty() ? (T)this.reduceRight(op) : null;
    }

    @NotNull
    default public Option<T> reduceRightOption(@NotNull BiFunction<? super T, ? super T, ? extends T> op) {
        return this.isNotEmpty() ? Option.some(this.reduceRight(op)) : Option.none();
    }

    default public <Ex extends Throwable> T reduceChecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ? extends Ex> op) throws Ex {
        return this.reduce(op);
    }

    default public T reduceUnchecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ?> op) {
        return this.reduce(op);
    }

    @Nullable
    default public <Ex extends Throwable> T reduceOrNullChecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ? extends Ex> op) throws Ex {
        return this.reduceOrNull(op);
    }

    @Nullable
    default public T reduceOrNullUnchecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ?> op) {
        return this.reduceOrNull(op);
    }

    @NotNull
    default public <Ex extends Throwable> Option<T> reduceOptionChecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ? extends Ex> op) throws Ex {
        return this.reduceOption(op);
    }

    @NotNull
    default public Option<T> reduceOptionUnchecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ?> op) {
        return this.reduceOption(op);
    }

    default public <Ex extends Throwable> T reduceLeftChecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ? extends Ex> op) throws Ex {
        return this.reduceLeft(op);
    }

    default public T reduceLeftUnchecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ?> op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public <Ex extends Throwable> T reduceLeftOrNullChecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ? extends Ex> op) throws Ex {
        return this.reduceLeftOrNull(op);
    }

    @Nullable
    default public T reduceLeftOrNullUnchecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ?> op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public <Ex extends Throwable> Option<T> reduceLeftOptionChecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ? extends Ex> op) throws Ex {
        return this.reduceLeftOption(op);
    }

    @NotNull
    default public Option<T> reduceLeftOptionUnchecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ?> op) {
        return this.reduceLeftOption(op);
    }

    default public <Ex extends Throwable> T reduceRightChecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ? extends Ex> op) throws Ex {
        return this.reduceRight(op);
    }

    default public T reduceRightUnchecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ?> op) {
        return this.reduceRight(op);
    }

    @Nullable
    default public <Ex extends Throwable> T reduceRightOrNullChecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ? extends Ex> op) throws Ex {
        return this.reduceRightOrNull(op);
    }

    @Nullable
    default public T reduceRightOrNullUnchecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ?> op) {
        return this.reduceRightOrNull(op);
    }

    @NotNull
    default public <Ex extends Throwable> Option<T> reduceRightOptionChecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ? extends Ex> op) throws Ex {
        return this.reduceRightOption(op);
    }

    @NotNull
    default public Option<T> reduceRightOptionUnchecked(@NotNull CheckedBiFunction<? super T, ? super T, ? extends T, ?> op) {
        return this.reduceRightOption(op);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(Object @NotNull [] dest) {
        return this.copyToArray(0, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(Object @NotNull [] dest, int destPos) {
        return this.copyToArray(0, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(Object @NotNull [] dest, int destPos, int limit) {
        return this.copyToArray(0, dest, destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, Object @NotNull [] dest) {
        return this.copyToArray(srcPos, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, Object @NotNull [] dest, int destPos) {
        return this.copyToArray(srcPos, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, Object @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + srcPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        if (limit <= 0) {
            return 0;
        }
        int dl = dest.length;
        if (destPos > dl) {
            return 0;
        }
        int kn = this.knownSize();
        if (kn >= 0 && srcPos >= kn) {
            return 0;
        }
        int end = Math.min(dl - destPos, limit) + destPos;
        int n = 0;
        Iterator<T> it = this.iterator();
        while (n++ < srcPos) {
            if (it.hasNext()) {
                it.next();
                continue;
            }
            return 0;
        }
        int idx = destPos;
        while (it.hasNext() && idx < end) {
            dest[idx++] = it.next();
        }
        return idx - destPos;
    }

    default public Object @NotNull [] toArray() {
        return this.toArray(ObjectArrays.generator());
    }

    default public <U> U @NotNull [] toArray(@NotNull Class<U> type) {
        return this.toArray(GenericArrays.generator(type));
    }

    default public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        int s = this.knownSize();
        if (s == 0) {
            return generator.apply(0);
        }
        if (s > 0) {
            Object[] arr = generator.apply(s);
            this.copyToArray(arr);
            return arr;
        }
        return Iterators.toArray(this.iterator(), generator);
    }

    default public <U> U @NotNull [] toArray(U @NotNull [] array) {
        int arrayLength = array.length;
        int size = this.size();
        Object[] res = arrayLength > size ? array : GenericArrays.create(array.getClass().getComponentType(), size);
        Iterator<T> it = this.iterator();
        for (int i = 0; i < res.length; ++i) {
            if (!it.hasNext()) {
                if (arrayLength > size) {
                    res[i] = null;
                } else {
                    if (arrayLength < i) {
                        return Arrays.copyOf(res, i);
                    }
                    System.arraycopy(res, 0, array, 0, i);
                    if (arrayLength > i) {
                        array[i] = null;
                    }
                }
                return array;
            }
            res[i] = it.next();
        }
        if (it.hasNext()) {
            throw new ConcurrentModificationException();
        }
        return res;
    }

    @Override
    default public void forEach(@NotNull Consumer<? super T> action) {
        Objects.requireNonNull(action);
        for (T t : this) {
            action.accept(t);
        }
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedConsumer<? super T, ? extends Ex> action) throws Ex {
        this.forEach(action);
    }

    default public void forEachUnchecked(@NotNull CheckedConsumer<? super T, ?> action) {
        this.forEach(action);
    }

    default public void forEachBreakable(@NotNull Predicate<? super T> action) {
        Objects.requireNonNull(action);
        for (T t : this) {
            if (!action.test(t)) break;
        }
    }

    default public <Ex extends Throwable> void forEachBreakableChecked(@NotNull CheckedPredicate<? super T, ? extends Ex> action) throws Ex {
        this.forEachBreakable(action);
    }

    default public void forEachBreakableUnchecked(@NotNull CheckedPredicate<? super T, ?> action) {
        this.forEachBreakable(action);
    }

    default public void forEachParallel(@NotNull Consumer<? super T> action) {
        this.forEachParallel(action, ConcurrentScope.currentExecutor(), Granularity.DEFAULT);
    }

    default public void forEachParallel(@NotNull Consumer<? super T> action, Granularity granularity) {
        this.forEachParallel(action, ConcurrentScope.currentExecutor(), granularity);
    }

    default public void forEachParallel(@NotNull Consumer<? super T> action, @NotNull Executor executor) {
        this.forEachParallel(action, executor, Granularity.DEFAULT);
    }

    default public void forEachParallel(@NotNull Consumer<? super T> action, @NotNull Executor executor, @NotNull Granularity granularity) {
        try {
            this.forEachAsync(action, executor, granularity).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    @NotNull
    default public Future<Void> forEachAsync(@NotNull Consumer<? super T> action) {
        return this.forEachAsync(action, ConcurrentScope.currentExecutor(), Granularity.DEFAULT);
    }

    @NotNull
    default public Future<Void> forEachAsync(@NotNull Consumer<? super T> action, @NotNull Executor executor) {
        return this.forEachAsync(action, executor, Granularity.DEFAULT);
    }

    @NotNull
    default public Future<Void> forEachAsync(@NotNull Consumer<? super T> action, Granularity granularity) {
        return this.forEachAsync(action, ConcurrentScope.currentExecutor(), granularity);
    }

    @NotNull
    default public Future<Void> forEachAsync(@NotNull Consumer<? super T> action, @NotNull Executor executor, @NotNull Granularity granularity) {
        if (granularity != Granularity.ATOM && executor instanceof ForkJoinPool) {
            return ((ForkJoinPool)executor).submit(() -> this.parallelStream().forEach(action), (Object)null);
        }
        LateInitCountDownLatch latch = new LateInitCountDownLatch();
        IntVar count = new IntVar();
        this.forEach(value -> {
            count.increment();
            executor.execute(() -> {
                try {
                    action.accept(value);
                }
                catch (Throwable throwable) {
                }
                finally {
                    latch.countDown();
                }
            });
        });
        latch.init(count.value);
        return latch.awaitFuture();
    }

    default public <U> void forEachWith(@NotNull Iterable<? extends U> other, @NotNull BiConsumer<? super T, ? super U> action) {
        Iterators.forEachWith(this.iterator(), other.iterator(), action);
    }

    default public <U, Ex extends Throwable> void forEachWithChecked(@NotNull Iterable<? extends U> other, @NotNull CheckedBiConsumer<? super T, ? super U, ? extends Ex> action) throws Ex {
        this.forEachWith(other, action);
    }

    default public <U> void forEachWithUnchecked(@NotNull Iterable<? extends U> other, @NotNull CheckedBiConsumer<? super T, ? super U, ?> action) {
        this.forEachWith(other, action);
    }

    @Override
    @Contract(value="_, _, _, _ -> param1", mutates="param1")
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        if (this.knownSize() == 0) {
            try {
                buffer.append(prefix).append(postfix);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return buffer;
        }
        return Iterators.joinTo(this.iterator(), buffer, separator, prefix, postfix);
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull Function<? super T, ? extends CharSequence> transform) {
        return this.joinTo(buffer, ", ", transform);
    }

    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, @NotNull Function<? super T, ? extends CharSequence> transform) {
        return this.joinTo(buffer, separator, "", "", transform);
    }

    @Contract(value="_, _, _, _, _ -> param1", mutates="param1")
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super T, ? extends CharSequence> transform) {
        if (this.knownSize() == 0) {
            try {
                buffer.append(prefix).append(postfix);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return buffer;
        }
        return Iterators.joinTo(this.iterator(), buffer, separator, prefix, postfix, transform);
    }

    @NotNull
    default public String joinToString(@NotNull Function<? super T, ? extends CharSequence> transform) {
        return this.joinTo(new StringBuilder(), transform).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator, @NotNull Function<? super T, ? extends CharSequence> transform) {
        return this.joinTo(new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    default public String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super T, ? extends CharSequence> transform) {
        return this.joinTo(new StringBuilder(), separator, prefix, postfix, transform).toString();
    }
}

