/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractBooleanIterator;
import kala.collection.base.primitive.BooleanIterator;
import kala.function.BooleanPredicate;
import org.jetbrains.annotations.NotNull;

final class BooleanIterators {
    static final BooleanIterator EMPTY = new AbstractBooleanIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean nextBoolean() {
            throw new NoSuchElementException();
        }

        @Override
        public String toString() {
            return "BooleanIterator[]";
        }
    };

    BooleanIterators() {
    }

    static final class Filter
    extends AbstractBooleanIterator {
        @NotNull
        private final BooleanIterator source;
        @NotNull
        private final BooleanPredicate predicate;
        private boolean nextValue;
        private boolean flag = false;
        private final boolean isFlipped;

        Filter(@NotNull BooleanIterator source, @NotNull BooleanPredicate predicate, boolean isFlipped) {
            this.source = source;
            this.predicate = predicate;
            this.isFlipped = isFlipped;
        }

        @Override
        public boolean hasNext() {
            if (this.flag) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            boolean v = this.source.nextBoolean();
            while (this.predicate.test(v) == this.isFlipped) {
                if (!this.source.hasNext()) {
                    return false;
                }
                v = this.source.nextBoolean();
            }
            this.nextValue = v;
            this.flag = true;
            return true;
        }

        @Override
        public boolean nextBoolean() {
            if (this.hasNext()) {
                this.flag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Appended
    extends AbstractBooleanIterator {
        @NotNull
        private final BooleanIterator source;
        private final boolean value;
        private boolean flag = true;

        Appended(@NotNull BooleanIterator source, boolean value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext() || this.flag;
        }

        @Override
        public boolean nextBoolean() {
            if (this.source.hasNext()) {
                return this.source.nextBoolean();
            }
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Prepended
    extends AbstractBooleanIterator {
        @NotNull
        private final BooleanIterator source;
        private final boolean value;
        private boolean flag = true;

        Prepended(@NotNull BooleanIterator source, boolean value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.flag || this.source.hasNext();
        }

        @Override
        public boolean nextBoolean() {
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            return this.source.nextBoolean();
        }
    }

    static final class Updated
    extends AbstractBooleanIterator {
        @NotNull
        private final BooleanIterator source;
        private final int n;
        private final boolean newValue;
        private int idx = 0;

        Updated(@NotNull BooleanIterator source, int n, boolean newValue) {
            this.source = source;
            this.n = n;
            this.newValue = newValue;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public boolean nextBoolean() {
            if (this.idx++ == this.n) {
                this.source.nextBoolean();
                return this.newValue;
            }
            return this.source.nextBoolean();
        }
    }

    static final class TakeWhile
    extends AbstractBooleanIterator {
        @NotNull
        private BooleanIterator source;
        private BooleanPredicate predicate;
        private boolean nextValue;
        private boolean tag = false;

        TakeWhile(@NotNull BooleanIterator source, BooleanPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.tag) {
                return true;
            }
            if (this.source.hasNext()) {
                this.nextValue = this.source.nextBoolean();
                boolean v = this.nextValue;
                if (this.predicate.test(v)) {
                    this.tag = true;
                    return true;
                }
                this.source = EMPTY;
                this.predicate = null;
                return false;
            }
            return false;
        }

        @Override
        public boolean nextBoolean() {
            if (this.hasNext()) {
                this.tag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Take
    extends AbstractBooleanIterator {
        private final BooleanIterator source;
        private int n;

        Take(BooleanIterator source, int n) {
            this.source = source;
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.n > 0 && this.source.hasNext();
        }

        @Override
        public boolean nextBoolean() {
            if (this.hasNext()) {
                --this.n;
                return this.source.nextBoolean();
            }
            throw new NoSuchElementException();
        }
    }

    static final class ConcatAll
    extends AbstractBooleanIterator {
        @NotNull
        private final Iterator<? extends BooleanIterator> iterators;
        private BooleanIterator current = null;

        ConcatAll(@NotNull Iterator<? extends BooleanIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.current.nextBoolean();
        }
    }

    static final class Concat
    extends AbstractBooleanIterator {
        private BooleanIterator it1;
        private BooleanIterator it2;

        Concat(BooleanIterator it1, BooleanIterator it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            if (this.it1 != null) {
                if (this.it1.hasNext()) {
                    return true;
                }
                this.it1 = null;
            }
            if (this.it2 != null) {
                if (this.it2.hasNext()) {
                    return true;
                }
                this.it2 = null;
            }
            return false;
        }

        @Override
        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.it1 != null) {
                return this.it1.nextBoolean();
            }
            if (this.it2 != null) {
                return this.it2.nextBoolean();
            }
            throw new AssertionError();
        }
    }
}

