/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.Growable;
import kala.collection.base.primitive.BooleanArrays;
import kala.collection.base.primitive.BooleanGrowable;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.PrimitiveTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.control.primitive.BooleanOption;
import kala.function.BooleanBinaryOperator;
import kala.function.BooleanConsumer;
import kala.function.BooleanFunction;
import kala.function.BooleanObjBiFunction;
import kala.function.BooleanPredicate;
import kala.function.BooleanUnaryOperator;
import kala.function.CheckedBooleanConsumer;
import kala.function.ObjBooleanBiFunction;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BooleanTraversable
extends PrimitiveTraversable<Boolean> {
    @Override
    @NotNull
    public BooleanIterator iterator();

    default public boolean elementAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && index >= knownSize) {
            throw new IndexOutOfBoundsException();
        }
        BooleanIterator it = this.iterator();
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            it.nextBoolean();
        }
        if (it.hasNext()) {
            return it.nextBoolean();
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    @NotNull
    default public BooleanOption find(@NotNull BooleanPredicate predicate) {
        return this.iterator().find(predicate);
    }

    default public boolean contains(boolean value) {
        return this.knownSize() != 0 && this.iterator().contains(value);
    }

    default public boolean containsAll(boolean @NotNull [] values) {
        return this.iterator().containsAll(values);
    }

    default public boolean containsAll(@NotNull BooleanTraversable values) {
        boolean value;
        BooleanIterator it1 = this.iterator();
        BooleanIterator it2 = values.iterator();
        if (!it2.hasNext()) {
            return true;
        }
        if (!it1.hasNext()) {
            return false;
        }
        boolean containsTrue = false;
        boolean containsFalse = false;
        while (it1.hasNext()) {
            boolean v = it1.nextBoolean();
            if (v) {
                containsTrue = true;
            } else {
                containsFalse = true;
            }
            if (!containsTrue || !containsFalse) continue;
            return true;
        }
        if (containsTrue) {
            while (it2.hasNext()) {
                value = it2.nextBoolean();
                if (value) continue;
                return false;
            }
        } else {
            while (it2.hasNext()) {
                value = it2.nextBoolean();
                if (!value) continue;
                return false;
            }
        }
        return true;
    }

    default public boolean sameElements(@NotNull BooleanTraversable other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean sameElements(@NotNull Iterable<?> other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean anyMatch(@NotNull BooleanPredicate predicate) {
        return this.iterator().anyMatch(predicate);
    }

    default public boolean allMatch(@NotNull BooleanPredicate predicate) {
        return this.iterator().allMatch(predicate);
    }

    default public boolean noneMatch(@NotNull BooleanPredicate predicate) {
        return this.iterator().noneMatch(predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends BooleanGrowable> G filterTo(@NotNull G destination, @NotNull BooleanPredicate predicate) {
        return this.iterator().filterTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends BooleanGrowable> G filterNotTo(@NotNull G destination, @NotNull BooleanPredicate predicate) {
        return this.iterator().filterNotTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends BooleanGrowable> G mapTo(@NotNull G destination, @NotNull BooleanUnaryOperator mapper) {
        return this.iterator().mapTo(destination, mapper);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull BooleanFunction<? extends U> mapper) {
        return this.iterator().mapToObjTo(destination, mapper);
    }

    default public int count(@NotNull BooleanPredicate predicate) {
        return this.iterator().count(predicate);
    }

    default public boolean max() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().max();
    }

    @Override
    @Nullable
    default public Boolean maxOrNull() {
        return this.isNotEmpty() ? Boolean.valueOf(this.max()) : null;
    }

    @NotNull
    default public BooleanOption maxOption() {
        return this.knownSize() == 0 ? BooleanOption.none() : this.iterator().maxOption();
    }

    default public boolean min() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().min();
    }

    @Override
    @Nullable
    default public Boolean minOrNull() {
        return this.knownSize() == 0 ? null : this.iterator().minOrNull();
    }

    @NotNull
    default public BooleanOption minOption() {
        return this.knownSize() == 0 ? BooleanOption.none() : this.iterator().minOption();
    }

    default public boolean fold(boolean zero, @NotNull BooleanBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public boolean foldLeft(boolean zero, @NotNull BooleanBinaryOperator op) {
        return this.iterator().foldLeft(zero, op);
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjBooleanBiFunction<U, U> op) {
        return this.iterator().foldLeftToObj(zero, op);
    }

    default public boolean foldRight(boolean zero, @NotNull BooleanBinaryOperator op) {
        return this.iterator().foldRight(zero, op);
    }

    default public <U> U foldRightToObj(U zero, @NotNull BooleanObjBiFunction<U, U> op) {
        return this.iterator().foldRightToObj(zero, op);
    }

    default public boolean reduce(@NotNull BooleanBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Boolean reduceOrNull(@NotNull BooleanBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public BooleanOption reduceOption(@NotNull BooleanBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public boolean reduceLeft(@NotNull BooleanBinaryOperator op) {
        return this.iterator().reduceLeft(op);
    }

    @Nullable
    default public Boolean reduceLeftOrNull(@NotNull BooleanBinaryOperator op) {
        return this.isNotEmpty() ? Boolean.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public BooleanOption reduceLeftOption(@NotNull BooleanBinaryOperator op) {
        return this.isNotEmpty() ? BooleanOption.some(this.reduceLeft(op)) : BooleanOption.none();
    }

    default public boolean reduceRight(@NotNull BooleanBinaryOperator op) {
        return this.iterator().reduceRight(op);
    }

    @Nullable
    default public Boolean reduceRightOrNull(@NotNull BooleanBinaryOperator op) {
        return this.isNotEmpty() ? Boolean.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public BooleanOption reduceRightOption(@NotNull BooleanBinaryOperator op) {
        return this.isNotEmpty() ? BooleanOption.some(this.reduceRight(op)) : BooleanOption.none();
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(boolean @NotNull [] dest) {
        return this.copyToArray(0, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(boolean @NotNull [] dest, int destPos) {
        return this.copyToArray(0, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(boolean @NotNull [] dest, int destPos, int limit) {
        return this.copyToArray(0, dest, destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, boolean @NotNull [] dest) {
        return this.copyToArray(srcPos, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, boolean @NotNull [] dest, int destPos) {
        return this.copyToArray(srcPos, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, boolean @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + srcPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        if (limit <= 0) {
            return 0;
        }
        int dl = dest.length;
        if (destPos > dl) {
            return 0;
        }
        int kn = this.knownSize();
        if (kn >= 0 && srcPos >= kn) {
            return 0;
        }
        int end = Math.min(dl - destPos, limit) + destPos;
        int n = 0;
        BooleanIterator it = this.iterator();
        while (n++ < srcPos) {
            if (it.hasNext()) {
                it.nextBoolean();
                continue;
            }
            return 0;
        }
        int idx = destPos;
        while (it.hasNext() && idx < end) {
            dest[idx++] = it.nextBoolean();
        }
        return idx - destPos;
    }

    @Override
    default public <R, Builder> R collect(@NotNull BooleanCollectionFactory<Builder, ? extends R> factory) {
        return BooleanCollectionFactory.buildBy(factory, this::forEach);
    }

    @Override
    @NotNull
    default public <G extends BooleanGrowable> G collect(@NotNull G destination) {
        destination.plusAssign(this);
        return destination;
    }

    default public boolean @NotNull [] toArray() {
        int s = this.knownSize();
        if (s == 0) {
            return BooleanArrays.EMPTY;
        }
        if (s > 0) {
            boolean[] arr = new boolean[s];
            int i = 0;
            BooleanIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                boolean t = iterator.nextBoolean();
                arr[i++] = t;
            }
            return arr;
        }
        return this.iterator().toArray();
    }

    default public void forEach(@NotNull BooleanConsumer action) {
        this.iterator().forEach(action);
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedBooleanConsumer<Ex> action) throws Ex {
        this.forEach(action);
    }

    default public void forEachUnchecked(@NotNull CheckedBooleanConsumer<?> action) {
        this.forEach(action);
    }

    default public void forEachBreakable(@NotNull BooleanPredicate action) {
        Objects.requireNonNull(action);
        BooleanIterator it = this.iterator();
        while (it.hasNext() && action.test(it.nextBoolean())) {
        }
    }
}

