/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractCharIterator;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharGrowable;
import kala.collection.base.primitive.CharIterators;
import kala.collection.base.primitive.PrimitiveIterator;
import kala.control.primitive.CharOption;
import kala.function.CharBinaryOperator;
import kala.function.CharConsumer;
import kala.function.CharFunction;
import kala.function.CharObjBiFunction;
import kala.function.CharPredicate;
import kala.function.CharUnaryOperator;
import kala.function.ObjCharBiFunction;
import kala.internal.InternalCharArrayBuilder;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CharIterator
extends PrimitiveIterator<Character, CharConsumer> {
    @NotNull
    public static CharIterator empty() {
        return CharIterators.EMPTY;
    }

    @NotNull
    public static CharIterator of() {
        return CharIterator.empty();
    }

    @NotNull
    public static CharIterator of(final char value) {
        return new CharIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public char nextChar() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return value;
                }
                throw new NoSuchElementException();
            }

            public String toString() {
                if (this.hasNext) {
                    return "CharIterator[" + value + "]";
                }
                return "CharIterator[]";
            }
        };
    }

    @NotNull
    public static CharIterator of(char ... values) {
        return CharArrays.iterator(values);
    }

    @NotNull
    public static CharIterator of(@NotNull String str) {
        return str.isEmpty() ? CharIterators.EMPTY : new CharIterators.OfString(str);
    }

    @NotNull
    public static CharIterator ofIterator(final @NotNull @NotNull Iterator<? extends @NotNull Character> it) {
        Objects.requireNonNull(it);
        if (it instanceof CharIterator) {
            return (CharIterator)it;
        }
        return new CharIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public char nextChar() {
                return ((Character)it.next()).charValue();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static CharIterator concat(@NotNull CharIterator it1, @NotNull CharIterator it2) {
        if (!it1.hasNext()) {
            return Objects.requireNonNull(it2);
        }
        if (!it2.hasNext()) {
            return it1;
        }
        return new CharIterators.Concat(it1, it2);
    }

    @NotNull
    public static CharIterator concat(CharIterator ... its) {
        switch (its.length) {
            case 0: {
                return CharIterator.empty();
            }
            case 1: {
                return Objects.requireNonNull(its[0]);
            }
            case 2: {
                return CharIterator.concat(its[0], its[1]);
            }
        }
        return new CharIterators.ConcatAll(GenericArrays.iterator(its));
    }

    @NotNull
    public static CharIterator concat(@NotNull Iterable<? extends CharIterator> its) {
        return CharIterator.concat(its.iterator());
    }

    @NotNull
    public static CharIterator concat(@NotNull Iterator<? extends CharIterator> its) {
        if (!its.hasNext()) {
            return CharIterator.empty();
        }
        return new CharIterators.ConcatAll(its);
    }

    public char nextChar();

    @Override
    default public void nextIgnoreResult() {
        this.nextChar();
    }

    @Override
    @Deprecated
    @NotNull
    default public Character next() {
        return Character.valueOf(this.nextChar());
    }

    @NotNull
    default public CharOption find(@NotNull CharPredicate predicate) {
        while (this.hasNext()) {
            char value = this.nextChar();
            if (!predicate.test(value)) continue;
            return CharOption.some(value);
        }
        return CharOption.None;
    }

    default public boolean contains(char value) {
        while (this.hasNext()) {
            if (value != this.nextChar()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean contains(Object value) {
        if (!(value instanceof Character)) {
            return false;
        }
        char v = ((Character)value).charValue();
        while (this.hasNext()) {
            if (v != this.nextChar()) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(char @NotNull [] values) {
        block0: while (this.hasNext()) {
            char v = this.nextChar();
            for (char i : values) {
                if (i == v) continue block0;
            }
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull CharIterator other) {
        while (this.hasNext() && other.hasNext()) {
            if (this.nextChar() == other.nextChar()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    @Override
    default public boolean sameElements(@NotNull Iterator<?> other) {
        if (other instanceof CharIterator) {
            return this.sameElements((CharIterator)other);
        }
        while (this.hasNext() && other.hasNext()) {
            Object value = other.next();
            if (!(value instanceof Character)) {
                return false;
            }
            if (((Character)value).charValue() == this.nextChar()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    default public boolean anyMatch(@NotNull CharPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextChar())) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(@NotNull CharPredicate predicate) {
        while (this.hasNext()) {
            if (predicate.test(this.nextChar())) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(@NotNull CharPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextChar())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public CharIterator drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0 && this.hasNext()) {
            this.nextChar();
            --n;
        }
        return this;
    }

    @NotNull
    default public CharIterator dropWhile(@NotNull CharPredicate predicate) {
        if (!this.hasNext()) {
            return this;
        }
        char value = '\u0000';
        boolean p = false;
        while (this.hasNext()) {
            value = this.nextChar();
            if (predicate.test(value)) continue;
            p = true;
            break;
        }
        if (p) {
            return this.hasNext() ? this.prepended(value) : CharIterator.of(value);
        }
        return this;
    }

    @NotNull
    default public CharIterator take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.hasNext() || n == 0) {
            return CharIterator.empty();
        }
        return new CharIterators.Take(this, n);
    }

    @NotNull
    default public CharIterator takeWhile(@NotNull CharPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return this;
        }
        return new CharIterators.TakeWhile(this, predicate);
    }

    @NotNull
    default public CharIterator updated(int n, char newValue) {
        if (!this.hasNext() || n < 0) {
            return this;
        }
        if (n == 0) {
            this.nextChar();
            return this.prepended(newValue);
        }
        return new CharIterators.Updated(this, n, newValue);
    }

    @NotNull
    default public CharIterator prepended(char value) {
        return new CharIterators.Prepended(this, value);
    }

    @NotNull
    default public CharIterator appended(char value) {
        return new CharIterators.Appended(this, value);
    }

    @NotNull
    default public CharIterator filter(@NotNull CharPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return CharIterator.empty();
        }
        return new CharIterators.Filter(this, predicate, false);
    }

    @NotNull
    default public CharIterator filterNot(@NotNull CharPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return CharIterator.empty();
        }
        return new CharIterators.Filter(this, predicate, true);
    }

    @NotNull
    default public CharIterator map(final @NotNull CharUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return this;
        }
        return new AbstractCharIterator(){

            @Override
            public boolean hasNext() {
                return CharIterator.this.hasNext();
            }

            @Override
            public char nextChar() {
                return mapper.applyAsChar(CharIterator.this.nextChar());
            }
        };
    }

    @NotNull
    default public <U> Iterator<U> mapToObj(final @NotNull CharFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return CharIterator.this.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(CharIterator.this.nextChar());
            }
        };
    }

    @NotNull
    default public @NotNull Tuple2<@NotNull CharIterator, @NotNull CharIterator> span(@NotNull CharPredicate predicate) {
        if (!this.hasNext()) {
            return Tuple.of(CharIterator.empty(), CharIterator.empty());
        }
        InternalCharArrayBuilder builder = new InternalCharArrayBuilder();
        CharIterator it = this;
        while (it.hasNext()) {
            char e = it.nextChar();
            if (predicate.test(e)) {
                builder.append(e);
                continue;
            }
            it = it.prepended(e);
            break;
        }
        return Tuple.of(builder.iterator(), it);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends CharGrowable> G filterTo(@NotNull G destination, @NotNull CharPredicate predicate) {
        CharIterator it = this;
        while (it.hasNext()) {
            char e = it.nextChar();
            if (!predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends CharGrowable> G filterNotTo(@NotNull G destination, @NotNull CharPredicate predicate) {
        CharIterator it = this;
        while (it.hasNext()) {
            char e = it.nextChar();
            if (predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends CharGrowable> G mapTo(@NotNull G destination, @NotNull CharUnaryOperator mapper) {
        CharIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.applyAsChar(it.nextChar()));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull CharFunction<? extends U> mapper) {
        CharIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.apply(it.nextChar()));
        }
        return destination;
    }

    default public int count(@NotNull CharPredicate predicate) {
        int c = 0;
        while (this.hasNext()) {
            if (!predicate.test(this.nextChar())) continue;
            ++c;
        }
        return c;
    }

    default public char max() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        char value = this.nextChar();
        while (this.hasNext()) {
            value = (char)Math.max(value, this.nextChar());
        }
        return value;
    }

    @Override
    @Nullable
    default public Character maxOrNull() {
        return this.hasNext() ? Character.valueOf(this.max()) : null;
    }

    @NotNull
    default public CharOption maxOption() {
        return this.hasNext() ? CharOption.some(this.max()) : CharOption.none();
    }

    default public char min() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        char value = this.nextChar();
        while (this.hasNext()) {
            value = (char)Math.min(value, this.nextChar());
        }
        return value;
    }

    @Override
    @Nullable
    default public Character minOrNull() {
        return this.hasNext() ? Character.valueOf(this.min()) : null;
    }

    @NotNull
    default public CharOption minOption() {
        return this.hasNext() ? CharOption.some(this.min()) : CharOption.none();
    }

    default public char fold(char zero, @NotNull CharBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public char foldLeft(char zero, @NotNull CharBinaryOperator op) {
        while (this.hasNext()) {
            zero = op.applyAsChar(zero, this.nextChar());
        }
        return zero;
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjCharBiFunction<U, U> op) {
        while (this.hasNext()) {
            zero = op.apply(zero, this.nextChar());
        }
        return zero;
    }

    default public char foldRight(char zero, @NotNull CharBinaryOperator op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalCharArrayBuilder builder = new InternalCharArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextChar());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.applyAsChar(builder.get(i), zero);
        }
        return zero;
    }

    default public <U> U foldRightToObj(U zero, @NotNull CharObjBiFunction<U, U> op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalCharArrayBuilder builder = new InternalCharArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextChar());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.apply(builder.get(i), zero);
        }
        return zero;
    }

    default public char reduce(@NotNull CharBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Character reduceOrNull(@NotNull CharBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public CharOption reduceOption(@NotNull CharBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public char reduceLeft(@NotNull CharBinaryOperator op) {
        char e = this.nextChar();
        while (this.hasNext()) {
            e = op.applyAsChar(e, this.nextChar());
        }
        return e;
    }

    @Nullable
    default public Character reduceLeftOrNull(@NotNull CharBinaryOperator op) {
        return this.hasNext() ? Character.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public CharOption reduceLeftOption(@NotNull CharBinaryOperator op) {
        return this.hasNext() ? CharOption.some(this.reduceLeft(op)) : CharOption.none();
    }

    default public char reduceRight(@NotNull CharBinaryOperator op) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        InternalCharArrayBuilder list = new InternalCharArrayBuilder();
        list.append(this.nextChar());
        while (this.hasNext()) {
            list.append(this.nextChar());
        }
        int size = list.size();
        char e = list.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.applyAsChar(list.get(i), e);
        }
        return e;
    }

    @Nullable
    default public Character reduceRightOrNull(@NotNull CharBinaryOperator op) {
        return this.hasNext() ? Character.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public CharOption reduceRightOption(@NotNull CharBinaryOperator op) {
        return this.hasNext() ? CharOption.some(this.reduceRight(op)) : CharOption.none();
    }

    default public char @NotNull [] toArray() {
        if (!this.hasNext()) {
            return CharArrays.EMPTY;
        }
        InternalCharArrayBuilder builder = new InternalCharArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextChar());
        }
        return builder.toArray();
    }

    @Override
    default public void forEach(@NotNull CharConsumer action) {
        while (this.hasNext()) {
            action.accept(this.nextChar());
        }
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Character> action) {
        if (action instanceof CharConsumer) {
            this.forEach((CharConsumer)((Object)action));
        } else {
            this.forEach(action::accept);
        }
    }

    @Override
    default public void forEachRemaining(@NotNull CharConsumer action) {
        this.forEach(action);
    }

    @Override
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        try {
            buffer.append(prefix);
            if (this.hasNext()) {
                buffer.append(String.valueOf(this.nextChar()));
            }
            while (this.hasNext()) {
                buffer.append(separator).append(String.valueOf(this.nextChar()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Override
    default public int hash() {
        int res = 0;
        while (this.hasNext()) {
            res = res * 31 + Character.hashCode(this.nextChar());
        }
        return res;
    }
}

