/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractCharIterator;
import kala.collection.base.primitive.CharIterator;
import kala.function.CharPredicate;
import org.jetbrains.annotations.NotNull;

final class CharIterators {
    static final CharIterator EMPTY = new AbstractCharIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public char nextChar() {
            throw new NoSuchElementException();
        }

        @Override
        public String toString() {
            return "CharIterator[]";
        }
    };

    CharIterators() {
    }

    static final class Filter
    extends AbstractCharIterator {
        @NotNull
        private final CharIterator source;
        @NotNull
        private final CharPredicate predicate;
        private char nextValue;
        private boolean flag = false;
        private final boolean isFlipped;

        Filter(@NotNull CharIterator source, @NotNull CharPredicate predicate, boolean isFlipped) {
            this.source = source;
            this.predicate = predicate;
            this.isFlipped = isFlipped;
        }

        @Override
        public boolean hasNext() {
            if (this.flag) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            char v = this.source.nextChar();
            while (this.predicate.test(v) == this.isFlipped) {
                if (!this.source.hasNext()) {
                    return false;
                }
                v = this.source.nextChar();
            }
            this.nextValue = v;
            this.flag = true;
            return true;
        }

        @Override
        public char nextChar() {
            if (this.hasNext()) {
                this.flag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Appended
    extends AbstractCharIterator {
        @NotNull
        private final CharIterator source;
        private final char value;
        private boolean flag = true;

        Appended(@NotNull CharIterator source, char value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext() || this.flag;
        }

        @Override
        public char nextChar() {
            if (this.source.hasNext()) {
                return this.source.nextChar();
            }
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Prepended
    extends AbstractCharIterator {
        @NotNull
        private final CharIterator source;
        private final char value;
        private boolean flag = true;

        Prepended(@NotNull CharIterator source, char value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.flag || this.source.hasNext();
        }

        @Override
        public char nextChar() {
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            return this.source.nextChar();
        }
    }

    static final class Updated
    extends AbstractCharIterator {
        @NotNull
        private final CharIterator source;
        private final int n;
        private final char newValue;
        private int idx = 0;

        Updated(@NotNull CharIterator source, int n, char newValue) {
            this.source = source;
            this.n = n;
            this.newValue = newValue;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public char nextChar() {
            if (this.idx++ == this.n) {
                this.source.nextChar();
                return this.newValue;
            }
            return this.source.nextChar();
        }
    }

    static final class TakeWhile
    extends AbstractCharIterator {
        @NotNull
        private CharIterator source;
        private CharPredicate predicate;
        private char nextValue;
        private boolean tag = false;

        TakeWhile(@NotNull CharIterator source, CharPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.tag) {
                return true;
            }
            if (this.source.hasNext()) {
                this.nextValue = this.source.nextChar();
                char v = this.nextValue;
                if (this.predicate.test(v)) {
                    this.tag = true;
                    return true;
                }
                this.source = EMPTY;
                this.predicate = null;
                return false;
            }
            return false;
        }

        @Override
        public char nextChar() {
            if (this.hasNext()) {
                this.tag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Take
    extends AbstractCharIterator {
        private final CharIterator source;
        private int n;

        Take(CharIterator source, int n) {
            this.source = source;
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.n > 0 && this.source.hasNext();
        }

        @Override
        public char nextChar() {
            if (this.hasNext()) {
                --this.n;
                return this.source.nextChar();
            }
            throw new NoSuchElementException();
        }
    }

    static final class ConcatAll
    extends AbstractCharIterator {
        @NotNull
        private final Iterator<? extends CharIterator> iterators;
        private CharIterator current = null;

        ConcatAll(@NotNull Iterator<? extends CharIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.current.nextChar();
        }
    }

    static final class Concat
    extends AbstractCharIterator {
        private CharIterator it1;
        private CharIterator it2;

        Concat(CharIterator it1, CharIterator it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            if (this.it1 != null) {
                if (this.it1.hasNext()) {
                    return true;
                }
                this.it1 = null;
            }
            if (this.it2 != null) {
                if (this.it2.hasNext()) {
                    return true;
                }
                this.it2 = null;
            }
            return false;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.it1 != null) {
                return this.it1.nextChar();
            }
            if (this.it2 != null) {
                return this.it2.nextChar();
            }
            throw new AssertionError();
        }
    }

    static final class OfString
    extends AbstractCharIterator {
        private final String str;
        private int idx = 0;

        OfString(String str) {
            this.str = str;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.str.length();
        }

        @Override
        public char nextChar() {
            if (this.idx < this.str.length()) {
                return this.str.charAt(this.idx);
            }
            throw new NoSuchElementException();
        }
    }
}

