/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractDoubleIterator;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleGrowable;
import kala.collection.base.primitive.DoubleIterators;
import kala.collection.base.primitive.PrimitiveIterator;
import kala.control.primitive.DoubleOption;
import kala.function.DoubleObjBiFunction;
import kala.function.ObjDoubleBiFunction;
import kala.internal.InternalDoubleArrayBuilder;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DoubleIterator
extends PrimitiveIterator<Double, DoubleConsumer>,
PrimitiveIterator.OfDouble {
    @NotNull
    public static DoubleIterator empty() {
        return DoubleIterators.EMPTY;
    }

    @NotNull
    public static DoubleIterator of() {
        return DoubleIterator.empty();
    }

    @NotNull
    public static DoubleIterator of(final double value) {
        return new DoubleIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public double nextDouble() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return value;
                }
                throw new NoSuchElementException();
            }

            public String toString() {
                if (this.hasNext) {
                    return "DoubleIterator[" + value + "]";
                }
                return "DoubleIterator[]";
            }
        };
    }

    @NotNull
    public static DoubleIterator of(double ... values) {
        return DoubleArrays.iterator(values);
    }

    @NotNull
    public static DoubleIterator ofIterator(final @NotNull @NotNull Iterator<? extends @NotNull Double> it) {
        Objects.requireNonNull(it);
        if (it instanceof DoubleIterator) {
            return (DoubleIterator)it;
        }
        return new DoubleIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public double nextDouble() {
                return (Double)it.next();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static DoubleIterator ofIterator(final @NotNull PrimitiveIterator.OfDouble it) {
        Objects.requireNonNull(it);
        if (it instanceof DoubleIterator) {
            return (DoubleIterator)it;
        }
        return new DoubleIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public double nextDouble() {
                return it.nextDouble();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static DoubleIterator concat(@NotNull DoubleIterator it1, @NotNull DoubleIterator it2) {
        if (!it1.hasNext()) {
            return Objects.requireNonNull(it2);
        }
        if (!it2.hasNext()) {
            return it1;
        }
        return new DoubleIterators.Concat(it1, it2);
    }

    @NotNull
    public static DoubleIterator concat(DoubleIterator ... its) {
        switch (its.length) {
            case 0: {
                return DoubleIterator.empty();
            }
            case 1: {
                return Objects.requireNonNull(its[0]);
            }
            case 2: {
                return DoubleIterator.concat(its[0], its[1]);
            }
        }
        return new DoubleIterators.ConcatAll(GenericArrays.iterator(its));
    }

    @NotNull
    public static DoubleIterator concat(@NotNull Iterable<? extends DoubleIterator> its) {
        return DoubleIterator.concat(its.iterator());
    }

    @NotNull
    public static DoubleIterator concat(@NotNull Iterator<? extends DoubleIterator> its) {
        if (!its.hasNext()) {
            return DoubleIterator.empty();
        }
        return new DoubleIterators.ConcatAll(its);
    }

    @Override
    public double nextDouble();

    @Override
    default public void nextIgnoreResult() {
        this.nextDouble();
    }

    @Override
    @Deprecated
    @NotNull
    default public Double next() {
        return this.nextDouble();
    }

    @NotNull
    default public DoubleOption find(@NotNull DoublePredicate predicate) {
        while (this.hasNext()) {
            double value = this.nextDouble();
            if (!predicate.test(value)) continue;
            return DoubleOption.some(value);
        }
        return DoubleOption.None;
    }

    default public boolean contains(double value) {
        while (this.hasNext()) {
            if (Double.doubleToLongBits(value) != Double.doubleToLongBits(this.nextDouble())) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean contains(Object value) {
        if (!(value instanceof Double)) {
            return false;
        }
        double v = (Double)value;
        while (this.hasNext()) {
            if (Double.doubleToLongBits(v) != Double.doubleToLongBits(this.nextDouble())) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(double @NotNull [] values) {
        block0: while (this.hasNext()) {
            double v = this.nextDouble();
            for (double i : values) {
                if (Double.doubleToLongBits(i) == Double.doubleToLongBits(v)) continue block0;
            }
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull DoubleIterator other) {
        return this.sameElements((PrimitiveIterator.OfDouble)other);
    }

    default public boolean sameElements(@NotNull PrimitiveIterator.OfDouble other) {
        while (this.hasNext() && other.hasNext()) {
            if (Double.doubleToLongBits(this.nextDouble()) == Double.doubleToLongBits(other.nextDouble())) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    @Override
    default public boolean sameElements(@NotNull Iterator<?> other) {
        if (other instanceof PrimitiveIterator.OfDouble) {
            return this.sameElements((PrimitiveIterator.OfDouble)other);
        }
        while (this.hasNext() && other.hasNext()) {
            Object value = other.next();
            if (!(value instanceof Double)) {
                return false;
            }
            if (Double.doubleToLongBits((Double)value) == Double.doubleToLongBits(this.nextDouble())) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    default public boolean anyMatch(@NotNull DoublePredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextDouble())) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(@NotNull DoublePredicate predicate) {
        while (this.hasNext()) {
            if (predicate.test(this.nextDouble())) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(@NotNull DoublePredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public DoubleIterator drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0 && this.hasNext()) {
            this.nextDouble();
            --n;
        }
        return this;
    }

    @NotNull
    default public DoubleIterator dropWhile(@NotNull DoublePredicate predicate) {
        if (!this.hasNext()) {
            return this;
        }
        double value = 0.0;
        boolean p = false;
        while (this.hasNext()) {
            value = this.nextDouble();
            if (predicate.test(value)) continue;
            p = true;
            break;
        }
        if (p) {
            return this.hasNext() ? this.prepended(value) : DoubleIterator.of(value);
        }
        return this;
    }

    @NotNull
    default public DoubleIterator take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.hasNext() || n == 0) {
            return DoubleIterator.empty();
        }
        return new DoubleIterators.Take(this, n);
    }

    @NotNull
    default public DoubleIterator takeWhile(@NotNull DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return this;
        }
        return new DoubleIterators.TakeWhile(this, predicate);
    }

    @NotNull
    default public DoubleIterator updated(int n, double newValue) {
        if (!this.hasNext() || n < 0) {
            return this;
        }
        if (n == 0) {
            this.nextDouble();
            return this.prepended(newValue);
        }
        return new DoubleIterators.Updated(this, n, newValue);
    }

    @NotNull
    default public DoubleIterator prepended(double value) {
        return new DoubleIterators.Prepended(this, value);
    }

    @NotNull
    default public DoubleIterator appended(double value) {
        return new DoubleIterators.Appended(this, value);
    }

    @NotNull
    default public DoubleIterator filter(@NotNull DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return DoubleIterator.empty();
        }
        return new DoubleIterators.Filter(this, predicate, false);
    }

    @NotNull
    default public DoubleIterator filterNot(@NotNull DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return DoubleIterator.empty();
        }
        return new DoubleIterators.Filter(this, predicate, true);
    }

    @NotNull
    default public DoubleIterator map(final @NotNull DoubleUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return this;
        }
        return new AbstractDoubleIterator(){

            @Override
            public boolean hasNext() {
                return DoubleIterator.this.hasNext();
            }

            @Override
            public double nextDouble() {
                return mapper.applyAsDouble(DoubleIterator.this.nextDouble());
            }
        };
    }

    @NotNull
    default public <U> Iterator<U> mapToObj(final @NotNull DoubleFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return DoubleIterator.this.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(DoubleIterator.this.nextDouble());
            }
        };
    }

    @NotNull
    default public @NotNull Tuple2<@NotNull DoubleIterator, @NotNull DoubleIterator> span(@NotNull DoublePredicate predicate) {
        if (!this.hasNext()) {
            return Tuple.of(DoubleIterator.empty(), DoubleIterator.empty());
        }
        InternalDoubleArrayBuilder builder = new InternalDoubleArrayBuilder();
        DoubleIterator it = this;
        while (it.hasNext()) {
            double e = it.nextDouble();
            if (predicate.test(e)) {
                builder.append(e);
                continue;
            }
            it = it.prepended(e);
            break;
        }
        return Tuple.of(builder.iterator(), it);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends DoubleGrowable> G filterTo(@NotNull G destination, @NotNull DoublePredicate predicate) {
        DoubleIterator it = this;
        while (it.hasNext()) {
            double e = it.nextDouble();
            if (!predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends DoubleGrowable> G filterNotTo(@NotNull G destination, @NotNull DoublePredicate predicate) {
        DoubleIterator it = this;
        while (it.hasNext()) {
            double e = it.nextDouble();
            if (predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends DoubleGrowable> G mapTo(@NotNull G destination, @NotNull DoubleUnaryOperator mapper) {
        DoubleIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.applyAsDouble(it.nextDouble()));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull DoubleFunction<? extends U> mapper) {
        DoubleIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.apply(it.nextDouble()));
        }
        return destination;
    }

    default public int count(@NotNull DoublePredicate predicate) {
        int c = 0;
        while (this.hasNext()) {
            if (!predicate.test(this.nextDouble())) continue;
            ++c;
        }
        return c;
    }

    default public double max() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        double value = this.nextDouble();
        while (this.hasNext()) {
            value = Math.max(value, this.nextDouble());
        }
        return value;
    }

    @Override
    @Nullable
    default public Double maxOrNull() {
        return this.hasNext() ? Double.valueOf(this.max()) : null;
    }

    @NotNull
    default public DoubleOption maxOption() {
        return this.hasNext() ? DoubleOption.some(this.max()) : DoubleOption.none();
    }

    default public double min() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        double value = this.nextDouble();
        while (this.hasNext()) {
            value = Math.min(value, this.nextDouble());
        }
        return value;
    }

    @Override
    @Nullable
    default public Double minOrNull() {
        return this.hasNext() ? Double.valueOf(this.min()) : null;
    }

    @NotNull
    default public DoubleOption minOption() {
        return this.hasNext() ? DoubleOption.some(this.min()) : DoubleOption.none();
    }

    default public double fold(double zero, @NotNull DoubleBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public double foldLeft(double zero, @NotNull DoubleBinaryOperator op) {
        while (this.hasNext()) {
            zero = op.applyAsDouble(zero, this.nextDouble());
        }
        return zero;
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjDoubleBiFunction<U, U> op) {
        while (this.hasNext()) {
            zero = op.apply(zero, this.nextDouble());
        }
        return zero;
    }

    default public double foldRight(double zero, @NotNull DoubleBinaryOperator op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalDoubleArrayBuilder builder = new InternalDoubleArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextDouble());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.applyAsDouble(builder.get(i), zero);
        }
        return zero;
    }

    default public <U> U foldRightToObj(U zero, @NotNull DoubleObjBiFunction<U, U> op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalDoubleArrayBuilder builder = new InternalDoubleArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextDouble());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.apply(builder.get(i), zero);
        }
        return zero;
    }

    default public double reduce(@NotNull DoubleBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Double reduceOrNull(@NotNull DoubleBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public DoubleOption reduceOption(@NotNull DoubleBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public double reduceLeft(@NotNull DoubleBinaryOperator op) {
        double e = this.nextDouble();
        while (this.hasNext()) {
            e = op.applyAsDouble(e, this.nextDouble());
        }
        return e;
    }

    @Nullable
    default public Double reduceLeftOrNull(@NotNull DoubleBinaryOperator op) {
        return this.hasNext() ? Double.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public DoubleOption reduceLeftOption(@NotNull DoubleBinaryOperator op) {
        return this.hasNext() ? DoubleOption.some(this.reduceLeft(op)) : DoubleOption.none();
    }

    default public double reduceRight(@NotNull DoubleBinaryOperator op) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        InternalDoubleArrayBuilder list = new InternalDoubleArrayBuilder();
        list.append(this.nextDouble());
        while (this.hasNext()) {
            list.append(this.nextDouble());
        }
        int size = list.size();
        double e = list.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.applyAsDouble(list.get(i), e);
        }
        return e;
    }

    @Nullable
    default public Double reduceRightOrNull(@NotNull DoubleBinaryOperator op) {
        return this.hasNext() ? Double.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public DoubleOption reduceRightOption(@NotNull DoubleBinaryOperator op) {
        return this.hasNext() ? DoubleOption.some(this.reduceRight(op)) : DoubleOption.none();
    }

    default public double @NotNull [] toArray() {
        if (!this.hasNext()) {
            return DoubleArrays.EMPTY;
        }
        InternalDoubleArrayBuilder builder = new InternalDoubleArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextDouble());
        }
        return builder.toArray();
    }

    @Override
    default public void forEach(@NotNull DoubleConsumer action) {
        while (this.hasNext()) {
            action.accept(this.nextDouble());
        }
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Double> action) {
        if (action instanceof DoubleConsumer) {
            this.forEach((DoubleConsumer)((Object)action));
        } else {
            this.forEach(action::accept);
        }
    }

    @Override
    default public void forEachRemaining(@NotNull DoubleConsumer action) {
        this.forEach(action);
    }

    @Override
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        try {
            buffer.append(prefix);
            if (this.hasNext()) {
                buffer.append(String.valueOf(this.nextDouble()));
            }
            while (this.hasNext()) {
                buffer.append(separator).append(String.valueOf(this.nextDouble()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Override
    default public int hash() {
        int res = 0;
        while (this.hasNext()) {
            res = res * 31 + Double.hashCode(this.nextDouble());
        }
        return res;
    }
}

