/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.DoublePredicate;
import kala.collection.base.primitive.AbstractDoubleIterator;
import kala.collection.base.primitive.DoubleIterator;
import org.jetbrains.annotations.NotNull;

final class DoubleIterators {
    static final DoubleIterator EMPTY = new AbstractDoubleIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public double nextDouble() {
            throw new NoSuchElementException();
        }

        @Override
        public String toString() {
            return "DoubleIterator[]";
        }
    };

    DoubleIterators() {
    }

    static final class Filter
    extends AbstractDoubleIterator {
        @NotNull
        private final DoubleIterator source;
        @NotNull
        private final DoublePredicate predicate;
        private double nextValue;
        private boolean flag = false;
        private final boolean isFlipped;

        Filter(@NotNull DoubleIterator source, @NotNull DoublePredicate predicate, boolean isFlipped) {
            this.source = source;
            this.predicate = predicate;
            this.isFlipped = isFlipped;
        }

        @Override
        public boolean hasNext() {
            if (this.flag) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            double v = this.source.nextDouble();
            while (this.predicate.test(v) == this.isFlipped) {
                if (!this.source.hasNext()) {
                    return false;
                }
                v = this.source.nextDouble();
            }
            this.nextValue = v;
            this.flag = true;
            return true;
        }

        @Override
        public double nextDouble() {
            if (this.hasNext()) {
                this.flag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Appended
    extends AbstractDoubleIterator {
        @NotNull
        private final DoubleIterator source;
        private final double value;
        private boolean flag = true;

        Appended(@NotNull DoubleIterator source, double value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext() || this.flag;
        }

        @Override
        public double nextDouble() {
            if (this.source.hasNext()) {
                return this.source.nextDouble();
            }
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Prepended
    extends AbstractDoubleIterator {
        @NotNull
        private final DoubleIterator source;
        private final double value;
        private boolean flag = true;

        Prepended(@NotNull DoubleIterator source, double value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.flag || this.source.hasNext();
        }

        @Override
        public double nextDouble() {
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            return this.source.nextDouble();
        }
    }

    static final class Updated
    extends AbstractDoubleIterator {
        @NotNull
        private final DoubleIterator source;
        private final int n;
        private final double newValue;
        private int idx = 0;

        Updated(@NotNull DoubleIterator source, int n, double newValue) {
            this.source = source;
            this.n = n;
            this.newValue = newValue;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public double nextDouble() {
            if (this.idx++ == this.n) {
                this.source.nextDouble();
                return this.newValue;
            }
            return this.source.nextDouble();
        }
    }

    static final class TakeWhile
    extends AbstractDoubleIterator {
        @NotNull
        private DoubleIterator source;
        private DoublePredicate predicate;
        private double nextValue;
        private boolean tag = false;

        TakeWhile(@NotNull DoubleIterator source, DoublePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.tag) {
                return true;
            }
            if (this.source.hasNext()) {
                this.nextValue = this.source.nextDouble();
                double v = this.nextValue;
                if (this.predicate.test(v)) {
                    this.tag = true;
                    return true;
                }
                this.source = EMPTY;
                this.predicate = null;
                return false;
            }
            return false;
        }

        @Override
        public double nextDouble() {
            if (this.hasNext()) {
                this.tag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Take
    extends AbstractDoubleIterator {
        private final DoubleIterator source;
        private int n;

        Take(DoubleIterator source, int n) {
            this.source = source;
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.n > 0 && this.source.hasNext();
        }

        @Override
        public double nextDouble() {
            if (this.hasNext()) {
                --this.n;
                return this.source.nextDouble();
            }
            throw new NoSuchElementException();
        }
    }

    static final class ConcatAll
    extends AbstractDoubleIterator {
        @NotNull
        private final Iterator<? extends DoubleIterator> iterators;
        private DoubleIterator current = null;

        ConcatAll(@NotNull Iterator<? extends DoubleIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.current.nextDouble();
        }
    }

    static final class Concat
    extends AbstractDoubleIterator {
        private DoubleIterator it1;
        private DoubleIterator it2;

        Concat(DoubleIterator it1, DoubleIterator it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            if (this.it1 != null) {
                if (this.it1.hasNext()) {
                    return true;
                }
                this.it1 = null;
            }
            if (this.it2 != null) {
                if (this.it2.hasNext()) {
                    return true;
                }
                this.it2 = null;
            }
            return false;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.it1 != null) {
                return this.it1.nextDouble();
            }
            if (this.it2 != null) {
                return this.it2.nextDouble();
            }
            throw new AssertionError();
        }
    }
}

