/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;
import kala.collection.base.Growable;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleGrowable;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.PrimitiveTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.control.primitive.DoubleOption;
import kala.function.CheckedDoubleConsumer;
import kala.function.DoubleObjBiFunction;
import kala.function.ObjDoubleBiFunction;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DoubleTraversable
extends PrimitiveTraversable<Double> {
    @Override
    @NotNull
    public DoubleIterator iterator();

    @NotNull
    default public Spliterator.OfDouble spliterator() {
        int ks = this.knownSize();
        if (ks == 0) {
            return Spliterators.emptyDoubleSpliterator();
        }
        if (ks > 0) {
            return Spliterators.spliterator(this.iterator(), (long)ks, this.characteristics());
        }
        return Spliterators.spliteratorUnknownSize(this.iterator(), this.characteristics());
    }

    @NotNull
    default public DoubleStream stream() {
        return StreamSupport.doubleStream(this.spliterator(), false);
    }

    @NotNull
    default public DoubleStream parallelStream() {
        return StreamSupport.doubleStream(this.spliterator(), true);
    }

    default public double elementAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && index >= knownSize) {
            throw new IndexOutOfBoundsException();
        }
        DoubleIterator it = this.iterator();
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            it.nextDouble();
        }
        if (it.hasNext()) {
            return it.nextDouble();
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    @NotNull
    default public DoubleOption find(@NotNull DoublePredicate predicate) {
        return this.iterator().find(predicate);
    }

    default public boolean contains(double value) {
        return this.knownSize() != 0 && this.iterator().contains(value);
    }

    default public boolean containsAll(double @NotNull [] values) {
        return this.iterator().containsAll(values);
    }

    default public boolean containsAll(@NotNull DoubleTraversable values) {
        DoubleIterator it = values.iterator();
        if (this.knownSize() == 0) {
            return !it.hasNext();
        }
        while (it.hasNext()) {
            if (this.contains(it.nextDouble())) continue;
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull DoubleTraversable other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean sameElements(@NotNull Iterable<?> other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean anyMatch(@NotNull DoublePredicate predicate) {
        return this.iterator().anyMatch(predicate);
    }

    default public boolean allMatch(@NotNull DoublePredicate predicate) {
        return this.iterator().allMatch(predicate);
    }

    default public boolean noneMatch(@NotNull DoublePredicate predicate) {
        return this.iterator().noneMatch(predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends DoubleGrowable> G filterTo(@NotNull G destination, @NotNull DoublePredicate predicate) {
        return this.iterator().filterTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends DoubleGrowable> G filterNotTo(@NotNull G destination, @NotNull DoublePredicate predicate) {
        return this.iterator().filterNotTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends DoubleGrowable> G mapTo(@NotNull G destination, @NotNull DoubleUnaryOperator mapper) {
        return this.iterator().mapTo(destination, mapper);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull DoubleFunction<? extends U> mapper) {
        return this.iterator().mapToObjTo(destination, mapper);
    }

    default public int count(@NotNull DoublePredicate predicate) {
        return this.iterator().count(predicate);
    }

    default public double max() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().max();
    }

    @Override
    @Nullable
    default public Double maxOrNull() {
        return this.isNotEmpty() ? Double.valueOf(this.max()) : null;
    }

    @NotNull
    default public DoubleOption maxOption() {
        return this.knownSize() == 0 ? DoubleOption.none() : this.iterator().maxOption();
    }

    default public double min() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().min();
    }

    @Override
    @Nullable
    default public Double minOrNull() {
        return this.knownSize() == 0 ? null : this.iterator().minOrNull();
    }

    @NotNull
    default public DoubleOption minOption() {
        return this.knownSize() == 0 ? DoubleOption.none() : this.iterator().minOption();
    }

    default public double fold(double zero, @NotNull DoubleBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public double foldLeft(double zero, @NotNull DoubleBinaryOperator op) {
        return this.iterator().foldLeft(zero, op);
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjDoubleBiFunction<U, U> op) {
        return this.iterator().foldLeftToObj(zero, op);
    }

    default public double foldRight(double zero, @NotNull DoubleBinaryOperator op) {
        return this.iterator().foldRight(zero, op);
    }

    default public <U> U foldRightToObj(U zero, @NotNull DoubleObjBiFunction<U, U> op) {
        return this.iterator().foldRightToObj(zero, op);
    }

    default public double reduce(@NotNull DoubleBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Double reduceOrNull(@NotNull DoubleBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public DoubleOption reduceOption(@NotNull DoubleBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public double reduceLeft(@NotNull DoubleBinaryOperator op) {
        return this.iterator().reduceLeft(op);
    }

    @Nullable
    default public Double reduceLeftOrNull(@NotNull DoubleBinaryOperator op) {
        return this.isNotEmpty() ? Double.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public DoubleOption reduceLeftOption(@NotNull DoubleBinaryOperator op) {
        return this.isNotEmpty() ? DoubleOption.some(this.reduceLeft(op)) : DoubleOption.none();
    }

    default public double reduceRight(@NotNull DoubleBinaryOperator op) {
        return this.iterator().reduceRight(op);
    }

    @Nullable
    default public Double reduceRightOrNull(@NotNull DoubleBinaryOperator op) {
        return this.isNotEmpty() ? Double.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public DoubleOption reduceRightOption(@NotNull DoubleBinaryOperator op) {
        return this.isNotEmpty() ? DoubleOption.some(this.reduceRight(op)) : DoubleOption.none();
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(double @NotNull [] dest) {
        return this.copyToArray(0, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(double @NotNull [] dest, int destPos) {
        return this.copyToArray(0, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(double @NotNull [] dest, int destPos, int limit) {
        return this.copyToArray(0, dest, destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, double @NotNull [] dest) {
        return this.copyToArray(srcPos, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, double @NotNull [] dest, int destPos) {
        return this.copyToArray(srcPos, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, double @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + srcPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        if (limit <= 0) {
            return 0;
        }
        int dl = dest.length;
        if (destPos > dl) {
            return 0;
        }
        int kn = this.knownSize();
        if (kn >= 0 && srcPos >= kn) {
            return 0;
        }
        int end = Math.min(dl - destPos, limit) + destPos;
        int n = 0;
        DoubleIterator it = this.iterator();
        while (n++ < srcPos) {
            if (it.hasNext()) {
                it.nextDouble();
                continue;
            }
            return 0;
        }
        int idx = destPos;
        while (it.hasNext() && idx < end) {
            dest[idx++] = it.nextDouble();
        }
        return idx - destPos;
    }

    @Override
    default public <R, Builder> R collect(@NotNull DoubleCollectionFactory<Builder, ? extends R> factory) {
        return DoubleCollectionFactory.buildBy(factory, this::forEach);
    }

    @Override
    @NotNull
    default public <G extends DoubleGrowable> G collect(@NotNull G destination) {
        destination.plusAssign(this);
        return destination;
    }

    default public double @NotNull [] toArray() {
        int s = this.knownSize();
        if (s == 0) {
            return DoubleArrays.EMPTY;
        }
        if (s > 0) {
            double[] arr = new double[s];
            int i = 0;
            DoubleIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                double t = iterator.nextDouble();
                arr[i++] = t;
            }
            return arr;
        }
        return this.iterator().toArray();
    }

    default public void forEach(@NotNull DoubleConsumer action) {
        this.iterator().forEach(action);
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedDoubleConsumer<Ex> action) throws Ex {
        this.forEach(action);
    }

    default public void forEachUnchecked(@NotNull CheckedDoubleConsumer<?> action) {
        this.forEach(action);
    }

    default public void forEachBreakable(@NotNull DoublePredicate action) {
        Objects.requireNonNull(action);
        DoubleIterator it = this.iterator();
        while (it.hasNext() && action.test(it.nextDouble())) {
        }
    }
}

