/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractFloatIterator;
import kala.collection.base.primitive.FloatIterator;
import kala.function.FloatPredicate;
import org.jetbrains.annotations.NotNull;

final class FloatIterators {
    static final FloatIterator EMPTY = new AbstractFloatIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public float nextFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public String toString() {
            return "FloatIterator[]";
        }
    };

    FloatIterators() {
    }

    static final class Filter
    extends AbstractFloatIterator {
        @NotNull
        private final FloatIterator source;
        @NotNull
        private final FloatPredicate predicate;
        private float nextValue;
        private boolean flag = false;
        private final boolean isFlipped;

        Filter(@NotNull FloatIterator source, @NotNull FloatPredicate predicate, boolean isFlipped) {
            this.source = source;
            this.predicate = predicate;
            this.isFlipped = isFlipped;
        }

        @Override
        public boolean hasNext() {
            if (this.flag) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            float v = this.source.nextFloat();
            while (this.predicate.test(v) == this.isFlipped) {
                if (!this.source.hasNext()) {
                    return false;
                }
                v = this.source.nextFloat();
            }
            this.nextValue = v;
            this.flag = true;
            return true;
        }

        @Override
        public float nextFloat() {
            if (this.hasNext()) {
                this.flag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Appended
    extends AbstractFloatIterator {
        @NotNull
        private final FloatIterator source;
        private final float value;
        private boolean flag = true;

        Appended(@NotNull FloatIterator source, float value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext() || this.flag;
        }

        @Override
        public float nextFloat() {
            if (this.source.hasNext()) {
                return this.source.nextFloat();
            }
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Prepended
    extends AbstractFloatIterator {
        @NotNull
        private final FloatIterator source;
        private final float value;
        private boolean flag = true;

        Prepended(@NotNull FloatIterator source, float value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.flag || this.source.hasNext();
        }

        @Override
        public float nextFloat() {
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            return this.source.nextFloat();
        }
    }

    static final class Updated
    extends AbstractFloatIterator {
        @NotNull
        private final FloatIterator source;
        private final int n;
        private final float newValue;
        private int idx = 0;

        Updated(@NotNull FloatIterator source, int n, float newValue) {
            this.source = source;
            this.n = n;
            this.newValue = newValue;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public float nextFloat() {
            if (this.idx++ == this.n) {
                this.source.nextFloat();
                return this.newValue;
            }
            return this.source.nextFloat();
        }
    }

    static final class TakeWhile
    extends AbstractFloatIterator {
        @NotNull
        private FloatIterator source;
        private FloatPredicate predicate;
        private float nextValue;
        private boolean tag = false;

        TakeWhile(@NotNull FloatIterator source, FloatPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.tag) {
                return true;
            }
            if (this.source.hasNext()) {
                this.nextValue = this.source.nextFloat();
                float v = this.nextValue;
                if (this.predicate.test(v)) {
                    this.tag = true;
                    return true;
                }
                this.source = EMPTY;
                this.predicate = null;
                return false;
            }
            return false;
        }

        @Override
        public float nextFloat() {
            if (this.hasNext()) {
                this.tag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Take
    extends AbstractFloatIterator {
        private final FloatIterator source;
        private int n;

        Take(FloatIterator source, int n) {
            this.source = source;
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.n > 0 && this.source.hasNext();
        }

        @Override
        public float nextFloat() {
            if (this.hasNext()) {
                --this.n;
                return this.source.nextFloat();
            }
            throw new NoSuchElementException();
        }
    }

    static final class ConcatAll
    extends AbstractFloatIterator {
        @NotNull
        private final Iterator<? extends FloatIterator> iterators;
        private FloatIterator current = null;

        ConcatAll(@NotNull Iterator<? extends FloatIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.current.nextFloat();
        }
    }

    static final class Concat
    extends AbstractFloatIterator {
        private FloatIterator it1;
        private FloatIterator it2;

        Concat(FloatIterator it1, FloatIterator it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            if (this.it1 != null) {
                if (this.it1.hasNext()) {
                    return true;
                }
                this.it1 = null;
            }
            if (this.it2 != null) {
                if (this.it2.hasNext()) {
                    return true;
                }
                this.it2 = null;
            }
            return false;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.it1 != null) {
                return this.it1.nextFloat();
            }
            if (this.it2 != null) {
                return this.it2.nextFloat();
            }
            throw new AssertionError();
        }
    }
}

