/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractLongIterator;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongGrowable;
import kala.collection.base.primitive.LongIterators;
import kala.collection.base.primitive.PrimitiveIterator;
import kala.control.primitive.LongOption;
import kala.function.LongObjBiFunction;
import kala.function.ObjLongBiFunction;
import kala.internal.InternalLongArrayBuilder;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LongIterator
extends PrimitiveIterator<Long, LongConsumer>,
PrimitiveIterator.OfLong {
    @NotNull
    public static LongIterator empty() {
        return LongIterators.EMPTY;
    }

    @NotNull
    public static LongIterator of() {
        return LongIterator.empty();
    }

    @NotNull
    public static LongIterator of(final long value) {
        return new LongIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public long nextLong() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return value;
                }
                throw new NoSuchElementException();
            }

            public String toString() {
                if (this.hasNext) {
                    return "LongIterator[" + value + "]";
                }
                return "LongIterator[]";
            }
        };
    }

    @NotNull
    public static LongIterator of(long ... values) {
        return LongArrays.iterator(values);
    }

    @NotNull
    public static LongIterator ofIterator(final @NotNull @NotNull Iterator<? extends @NotNull Long> it) {
        Objects.requireNonNull(it);
        if (it instanceof LongIterator) {
            return (LongIterator)it;
        }
        return new LongIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public long nextLong() {
                return (Long)it.next();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static LongIterator ofIterator(final @NotNull PrimitiveIterator.OfLong it) {
        Objects.requireNonNull(it);
        if (it instanceof LongIterator) {
            return (LongIterator)it;
        }
        return new LongIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public long nextLong() {
                return it.nextLong();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static LongIterator concat(@NotNull LongIterator it1, @NotNull LongIterator it2) {
        if (!it1.hasNext()) {
            return Objects.requireNonNull(it2);
        }
        if (!it2.hasNext()) {
            return it1;
        }
        return new LongIterators.Concat(it1, it2);
    }

    @NotNull
    public static LongIterator concat(LongIterator ... its) {
        switch (its.length) {
            case 0: {
                return LongIterator.empty();
            }
            case 1: {
                return Objects.requireNonNull(its[0]);
            }
            case 2: {
                return LongIterator.concat(its[0], its[1]);
            }
        }
        return new LongIterators.ConcatAll(GenericArrays.iterator(its));
    }

    @NotNull
    public static LongIterator concat(@NotNull Iterable<? extends LongIterator> its) {
        return LongIterator.concat(its.iterator());
    }

    @NotNull
    public static LongIterator concat(@NotNull Iterator<? extends LongIterator> its) {
        if (!its.hasNext()) {
            return LongIterator.empty();
        }
        return new LongIterators.ConcatAll(its);
    }

    @Override
    public long nextLong();

    @Override
    default public void nextIgnoreResult() {
        this.nextLong();
    }

    @Override
    @Deprecated
    @NotNull
    default public Long next() {
        return this.nextLong();
    }

    @NotNull
    default public LongOption find(@NotNull LongPredicate predicate) {
        while (this.hasNext()) {
            long value = this.nextLong();
            if (!predicate.test(value)) continue;
            return LongOption.some(value);
        }
        return LongOption.None;
    }

    default public boolean contains(long value) {
        while (this.hasNext()) {
            if (value != this.nextLong()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean contains(Object value) {
        if (!(value instanceof Long)) {
            return false;
        }
        long v = (Long)value;
        while (this.hasNext()) {
            if (v != this.nextLong()) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(long @NotNull [] values) {
        block0: while (this.hasNext()) {
            long v = this.nextLong();
            for (long i : values) {
                if (i == v) continue block0;
            }
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull LongIterator other) {
        return this.sameElements((PrimitiveIterator.OfLong)other);
    }

    default public boolean sameElements(@NotNull PrimitiveIterator.OfLong other) {
        while (this.hasNext() && other.hasNext()) {
            if (this.nextLong() == other.nextLong()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    @Override
    default public boolean sameElements(@NotNull Iterator<?> other) {
        if (other instanceof PrimitiveIterator.OfLong) {
            return this.sameElements((PrimitiveIterator.OfLong)other);
        }
        while (this.hasNext() && other.hasNext()) {
            Object value = other.next();
            if (!(value instanceof Long)) {
                return false;
            }
            if (((Long)value).longValue() == this.nextLong()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    default public boolean anyMatch(@NotNull LongPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextLong())) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(@NotNull LongPredicate predicate) {
        while (this.hasNext()) {
            if (predicate.test(this.nextLong())) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(@NotNull LongPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextLong())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public LongIterator drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0 && this.hasNext()) {
            this.nextLong();
            --n;
        }
        return this;
    }

    @NotNull
    default public LongIterator dropWhile(@NotNull LongPredicate predicate) {
        if (!this.hasNext()) {
            return this;
        }
        long value = 0L;
        boolean p = false;
        while (this.hasNext()) {
            value = this.nextLong();
            if (predicate.test(value)) continue;
            p = true;
            break;
        }
        if (p) {
            return this.hasNext() ? this.prepended(value) : LongIterator.of(value);
        }
        return this;
    }

    @NotNull
    default public LongIterator take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.hasNext() || n == 0) {
            return LongIterator.empty();
        }
        return new LongIterators.Take(this, n);
    }

    @NotNull
    default public LongIterator takeWhile(@NotNull LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return this;
        }
        return new LongIterators.TakeWhile(this, predicate);
    }

    @NotNull
    default public LongIterator updated(int n, long newValue) {
        if (!this.hasNext() || n < 0) {
            return this;
        }
        if (n == 0) {
            this.nextLong();
            return this.prepended(newValue);
        }
        return new LongIterators.Updated(this, n, newValue);
    }

    @NotNull
    default public LongIterator prepended(long value) {
        return new LongIterators.Prepended(this, value);
    }

    @NotNull
    default public LongIterator appended(long value) {
        return new LongIterators.Appended(this, value);
    }

    @NotNull
    default public LongIterator filter(@NotNull LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return LongIterator.empty();
        }
        return new LongIterators.Filter(this, predicate, false);
    }

    @NotNull
    default public LongIterator filterNot(@NotNull LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return LongIterator.empty();
        }
        return new LongIterators.Filter(this, predicate, true);
    }

    @NotNull
    default public LongIterator map(final @NotNull LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return this;
        }
        return new AbstractLongIterator(){

            @Override
            public boolean hasNext() {
                return LongIterator.this.hasNext();
            }

            @Override
            public long nextLong() {
                return mapper.applyAsLong(LongIterator.this.nextLong());
            }
        };
    }

    @NotNull
    default public <U> Iterator<U> mapToObj(final @NotNull LongFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return LongIterator.this.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(LongIterator.this.nextLong());
            }
        };
    }

    @NotNull
    default public @NotNull Tuple2<@NotNull LongIterator, @NotNull LongIterator> span(@NotNull LongPredicate predicate) {
        if (!this.hasNext()) {
            return Tuple.of(LongIterator.empty(), LongIterator.empty());
        }
        InternalLongArrayBuilder builder = new InternalLongArrayBuilder();
        LongIterator it = this;
        while (it.hasNext()) {
            long e = it.nextLong();
            if (predicate.test(e)) {
                builder.append(e);
                continue;
            }
            it = it.prepended(e);
            break;
        }
        return Tuple.of(builder.iterator(), it);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends LongGrowable> G filterTo(@NotNull G destination, @NotNull LongPredicate predicate) {
        LongIterator it = this;
        while (it.hasNext()) {
            long e = it.nextLong();
            if (!predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends LongGrowable> G filterNotTo(@NotNull G destination, @NotNull LongPredicate predicate) {
        LongIterator it = this;
        while (it.hasNext()) {
            long e = it.nextLong();
            if (predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends LongGrowable> G mapTo(@NotNull G destination, @NotNull LongUnaryOperator mapper) {
        LongIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.applyAsLong(it.nextLong()));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull LongFunction<? extends U> mapper) {
        LongIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.apply(it.nextLong()));
        }
        return destination;
    }

    default public int count(@NotNull LongPredicate predicate) {
        int c = 0;
        while (this.hasNext()) {
            if (!predicate.test(this.nextLong())) continue;
            ++c;
        }
        return c;
    }

    default public long max() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        long value = this.nextLong();
        while (this.hasNext()) {
            value = Math.max(value, this.nextLong());
        }
        return value;
    }

    @Override
    @Nullable
    default public Long maxOrNull() {
        return this.hasNext() ? Long.valueOf(this.max()) : null;
    }

    @NotNull
    default public LongOption maxOption() {
        return this.hasNext() ? LongOption.some(this.max()) : LongOption.none();
    }

    default public long min() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        long value = this.nextLong();
        while (this.hasNext()) {
            value = Math.min(value, this.nextLong());
        }
        return value;
    }

    @Override
    @Nullable
    default public Long minOrNull() {
        return this.hasNext() ? Long.valueOf(this.min()) : null;
    }

    @NotNull
    default public LongOption minOption() {
        return this.hasNext() ? LongOption.some(this.min()) : LongOption.none();
    }

    default public long fold(long zero, @NotNull LongBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public long foldLeft(long zero, @NotNull LongBinaryOperator op) {
        while (this.hasNext()) {
            zero = op.applyAsLong(zero, this.nextLong());
        }
        return zero;
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjLongBiFunction<U, U> op) {
        while (this.hasNext()) {
            zero = op.apply(zero, this.nextLong());
        }
        return zero;
    }

    default public long foldRight(long zero, @NotNull LongBinaryOperator op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalLongArrayBuilder builder = new InternalLongArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextLong());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.applyAsLong(builder.get(i), zero);
        }
        return zero;
    }

    default public <U> U foldRightToObj(U zero, @NotNull LongObjBiFunction<U, U> op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalLongArrayBuilder builder = new InternalLongArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextLong());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.apply(builder.get(i), zero);
        }
        return zero;
    }

    default public long reduce(@NotNull LongBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Long reduceOrNull(@NotNull LongBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public LongOption reduceOption(@NotNull LongBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public long reduceLeft(@NotNull LongBinaryOperator op) {
        long e = this.nextLong();
        while (this.hasNext()) {
            e = op.applyAsLong(e, this.nextLong());
        }
        return e;
    }

    @Nullable
    default public Long reduceLeftOrNull(@NotNull LongBinaryOperator op) {
        return this.hasNext() ? Long.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public LongOption reduceLeftOption(@NotNull LongBinaryOperator op) {
        return this.hasNext() ? LongOption.some(this.reduceLeft(op)) : LongOption.none();
    }

    default public long reduceRight(@NotNull LongBinaryOperator op) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        InternalLongArrayBuilder list = new InternalLongArrayBuilder();
        list.append(this.nextLong());
        while (this.hasNext()) {
            list.append(this.nextLong());
        }
        int size = list.size();
        long e = list.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.applyAsLong(list.get(i), e);
        }
        return e;
    }

    @Nullable
    default public Long reduceRightOrNull(@NotNull LongBinaryOperator op) {
        return this.hasNext() ? Long.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public LongOption reduceRightOption(@NotNull LongBinaryOperator op) {
        return this.hasNext() ? LongOption.some(this.reduceRight(op)) : LongOption.none();
    }

    default public long @NotNull [] toArray() {
        if (!this.hasNext()) {
            return LongArrays.EMPTY;
        }
        InternalLongArrayBuilder builder = new InternalLongArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextLong());
        }
        return builder.toArray();
    }

    @Override
    default public void forEach(@NotNull LongConsumer action) {
        while (this.hasNext()) {
            action.accept(this.nextLong());
        }
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Long> action) {
        if (action instanceof LongConsumer) {
            this.forEach((LongConsumer)((Object)action));
        } else {
            this.forEach(action::accept);
        }
    }

    @Override
    default public void forEachRemaining(@NotNull LongConsumer action) {
        this.forEach(action);
    }

    @Override
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        try {
            buffer.append(prefix);
            if (this.hasNext()) {
                buffer.append(String.valueOf(this.nextLong()));
            }
            while (this.hasNext()) {
                buffer.append(separator).append(String.valueOf(this.nextLong()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Override
    default public int hash() {
        int res = 0;
        while (this.hasNext()) {
            res = res * 31 + Long.hashCode(this.nextLong());
        }
        return res;
    }
}

