/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import kala.Conditions;
import kala.collection.base.primitive.AbstractShortIterator;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.control.primitive.ShortOption;
import kala.function.ObjShortBiFunction;
import kala.function.ShortBinaryOperator;
import kala.function.ShortFunction;
import kala.function.ShortObjBiFunction;
import kala.function.ShortPredicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShortArrays {
    public static final short[] EMPTY = new short[0];
    private static final IntFunction<short[]> GENERATOR = short[]::new;

    private ShortArrays() {
    }

    @Contract(pure=true)
    @NotNull
    public static IntFunction<short[]> generator() {
        return GENERATOR;
    }

    public static short @NotNull [] create(int length) {
        return new short[length];
    }

    @Contract(value="_ -> param1", pure=true)
    public static short @NotNull [] of(short ... values) {
        return values;
    }

    public static short @NotNull [] from(short @NotNull [] values) {
        return (short[])values.clone();
    }

    public static short @NotNull [] from(@NotNull ShortTraversable values) {
        return values.toArray();
    }

    public static short @NotNull [] from(@NotNull ShortIterator it) {
        return it.toArray();
    }

    @NotNull
    public static String className(short @NotNull [] array) {
        return "short[]";
    }

    @NotNull
    public static ShortIterator iterator(short @NotNull [] array) {
        int arrayLength = array.length;
        switch (arrayLength) {
            case 0: {
                return ShortIterator.empty();
            }
            case 1: {
                return ShortIterator.of(array[0]);
            }
        }
        return new Itr(array, 0, arrayLength);
    }

    @NotNull
    public static ShortIterator iterator(short @NotNull [] array, int beginIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndex(beginIndex, arrayLength);
        switch (arrayLength - beginIndex) {
            case 0: {
                return ShortIterator.empty();
            }
            case 1: {
                return ShortIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, arrayLength);
    }

    @NotNull
    public static ShortIterator iterator(short @NotNull [] array, int beginIndex, int endIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndices(beginIndex, endIndex, arrayLength);
        switch (endIndex - beginIndex) {
            case 0: {
                return ShortIterator.empty();
            }
            case 1: {
                return ShortIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, endIndex);
    }

    public static boolean isEmpty(short @NotNull [] array) {
        return array.length == 0;
    }

    public static int size(short @NotNull [] array) {
        return array.length;
    }

    public static int knownSize(short @NotNull [] array) {
        return array.length;
    }

    public static boolean isDefineAt(short @NotNull [] array, int index) {
        return index >= 0 && index <= array.length;
    }

    public static short get(short @NotNull [] array, int index) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Nullable
    public static Short getOrNull(short @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? Short.valueOf(array[index]) : null;
    }

    @NotNull
    public static ShortOption getOption(short @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? ShortOption.some(array[index]) : ShortOption.none();
    }

    public static void set(short @NotNull [] array, int index, short value) {
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public static short @NotNull [] reversed(short @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            return array;
        }
        short[] res = new short[length];
        for (int i = 0; i < length; ++i) {
            res[i] = array[length - i - 1];
        }
        return res;
    }

    @NotNull
    public static ShortIterator reverseIterator(short @NotNull [] array) {
        int length = array.length;
        switch (length) {
            case 0: {
                return ShortIterator.empty();
            }
            case 1: {
                return ShortIterator.of(array[0]);
            }
        }
        return new ReverseItr(array, length - 1);
    }

    public static void shuffle(short @NotNull [] array) {
        ShortArrays.shuffle(array, ThreadLocalRandom.current());
    }

    public static void shuffle(short @NotNull [] array, @NotNull Random random) {
        int size = array.length;
        if (size <= 1) {
            return;
        }
        for (int i = size; i > 1; --i) {
            int k = random.nextInt(i);
            short tmp = array[i - 1];
            array[i - 1] = array[k];
            array[k] = tmp;
        }
    }

    public static void sort(short @NotNull [] array) {
        Arrays.sort(array);
    }

    public static void sort(short @NotNull [] array, int beginIndex, int endIndex) {
        Arrays.sort(array, beginIndex, endIndex);
    }

    @NotNull
    public static ShortOption find(short @NotNull [] array, @NotNull ShortPredicate predicate) {
        for (short e : array) {
            if (!predicate.test(e)) continue;
            return ShortOption.some(e);
        }
        return ShortOption.none();
    }

    public static short first(short @NotNull [] array) {
        try {
            return array[0];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    public static short last(short @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        return array[length - 1];
    }

    public static boolean contains(short @NotNull [] array, short value) {
        for (short o : array) {
            if (value != o) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(short @NotNull [] array, short @NotNull [] values) {
        for (short value : values) {
            if (ShortArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(short @NotNull [] array, @NotNull ShortTraversable values) {
        ShortIterator it = values.iterator();
        while (it.hasNext()) {
            short value = it.nextShort();
            if (ShortArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatch(short @NotNull [] array, @NotNull ShortPredicate predicate) {
        for (short e : array) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean allMatch(short @NotNull [] array, @NotNull ShortPredicate predicate) {
        for (short e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneMatch(short @NotNull [] array, @NotNull ShortPredicate predicate) {
        for (short e : array) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(short @NotNull [] array, short value) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(short @NotNull [] array, short value, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(short @NotNull [] array, @NotNull ShortPredicate predicate) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(short @NotNull [] array, @NotNull ShortPredicate predicate, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(short @NotNull [] array, short value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(short @NotNull [] array, short value, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(short @NotNull [] array, @NotNull ShortPredicate predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(short @NotNull [] array, @NotNull ShortPredicate predicate, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static short max(short @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        short e = array[0];
        for (int i = 1; i < length; ++i) {
            short v = array[i];
            if (Short.compare(e, v) >= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Short maxOrNull(short @NotNull [] array) {
        return array.length != 0 ? Short.valueOf(ShortArrays.max(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static ShortOption maxOption(short @NotNull [] array) {
        return array.length != 0 ? ShortOption.some(ShortArrays.max(array)) : ShortOption.none();
    }

    @Contract(pure=true)
    public static short min(short @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        short e = array[0];
        for (int i = 1; i < length; ++i) {
            short v = array[i];
            if (Short.compare(e, v) <= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Short minOrNull(short @NotNull [] array) {
        return array.length != 0 ? Short.valueOf(ShortArrays.min(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static ShortOption minOption(short @NotNull [] array) {
        return array.length != 0 ? ShortOption.some(ShortArrays.min(array)) : ShortOption.none();
    }

    @Contract(pure=true)
    public static short fold(short @NotNull [] array, short zero, @NotNull ShortBinaryOperator op) {
        return ShortArrays.foldLeft(array, zero, op);
    }

    @Contract(pure=true)
    public static short foldLeft(short @NotNull [] array, short zero, @NotNull ShortBinaryOperator op) {
        for (short e : array) {
            zero = op.applyAsShort(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static <U> U foldLeftToObj(short @NotNull [] array, U zero, @NotNull ObjShortBiFunction<U, U> op) {
        for (short e : array) {
            zero = op.apply(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static short foldRight(short @NotNull [] array, short zero, @NotNull ShortBinaryOperator op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.applyAsShort(array[i], zero);
        }
        return zero;
    }

    public static <U> U foldRightToObj(short @NotNull [] array, U zero, @NotNull ShortObjBiFunction<U, U> op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.apply(array[i], zero);
        }
        return zero;
    }

    @Contract(pure=true)
    public static short reduce(short @NotNull [] array, @NotNull ShortBinaryOperator op) {
        return ShortArrays.reduceLeft(array, op);
    }

    @Contract(pure=true)
    @NotNull
    public static ShortOption reduceOption(short @NotNull [] array, @NotNull ShortBinaryOperator op) {
        return ShortArrays.reduceLeftOption(array, op);
    }

    @Contract(pure=true)
    public static short reduceLeft(short @NotNull [] array, @NotNull ShortBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        short e = array[0];
        for (int i = 1; i < length; ++i) {
            e = op.applyAsShort(e, array[i]);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Short reduceLeftOrNull(short @NotNull [] array, @NotNull ShortBinaryOperator op) {
        return array.length != 0 ? Short.valueOf(ShortArrays.reduceLeft(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static ShortOption reduceLeftOption(short @NotNull [] array, @NotNull ShortBinaryOperator op) {
        return array.length != 0 ? ShortOption.some(ShortArrays.reduceLeft(array, op)) : ShortOption.none();
    }

    @Contract(pure=true)
    public static short reduceRight(short @NotNull [] array, @NotNull ShortBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        short e = array[length - 1];
        for (int i = length - 2; i >= 0; --i) {
            e = op.applyAsShort(array[i], e);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Short reduceRightOrNull(short @NotNull [] array, @NotNull ShortBinaryOperator op) {
        return array.length != 0 ? Short.valueOf(ShortArrays.reduceRight(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static ShortOption reduceRightOption(short @NotNull [] array, @NotNull ShortBinaryOperator op) {
        return array.length != 0 ? ShortOption.some(ShortArrays.reduceRight(array, op)) : ShortOption.none();
    }

    @NotNull
    public static <A extends Appendable> A joinTo(short @NotNull [] array, @NotNull A buffer) {
        return ShortArrays.joinTo(array, buffer, ", ", "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(short @NotNull [] array, @NotNull A buffer, CharSequence separator) {
        return ShortArrays.joinTo(array, buffer, separator, "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(short @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(String.valueOf(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(Objects.toString(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static <A extends Appendable> A joinTo(short @NotNull [] array, @NotNull A buffer, @NotNull ShortFunction<? extends CharSequence> transform) {
        return ShortArrays.joinTo(array, buffer, ", ", "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(short @NotNull [] array, @NotNull A buffer, CharSequence separator, @NotNull ShortFunction<? extends CharSequence> transform) {
        return ShortArrays.joinTo(array, buffer, separator, "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(short @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull ShortFunction<? extends CharSequence> transform) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(transform.apply(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(transform.apply(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static String joinToString(short @NotNull [] array) {
        return ShortArrays.joinTo(array, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(short @NotNull [] array, CharSequence separator) {
        return ShortArrays.joinTo(array, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(short @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return ShortArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static String joinToString(short @NotNull [] array, @NotNull ShortFunction<? extends CharSequence> transform) {
        return ShortArrays.joinTo(array, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static String joinToString(short @NotNull [] array, CharSequence separator, @NotNull ShortFunction<? extends CharSequence> transform) {
        return ShortArrays.joinTo(array, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static String joinToString(short @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull ShortFunction<? extends CharSequence> transform) {
        return ShortArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }

    private static final class Itr
    extends AbstractShortIterator {
        private final short @NotNull [] array;
        private final int endIndex;
        private int index;

        Itr(short @NotNull [] array, int beginIndex, int endIndex) {
            this.array = array;
            this.index = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public short nextShort() {
            if (this.index >= this.endIndex) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.array[this.index++];
        }
    }

    private static final class ReverseItr
    extends AbstractShortIterator {
        private final short @NotNull [] array;
        private int index;

        ReverseItr(short @NotNull [] array, int index) {
            this.array = array;
            this.index = index;
        }

        ReverseItr(short @NotNull [] array) {
            this(array, array.length - 1);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public short nextShort() {
            try {
                return this.array[this.index--];
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                throw new NoSuchElementException();
            }
        }
    }
}

