/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractShortIterator;
import kala.collection.base.primitive.PrimitiveIterator;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortGrowable;
import kala.collection.base.primitive.ShortIterators;
import kala.control.primitive.ShortOption;
import kala.function.ObjShortBiFunction;
import kala.function.ShortBinaryOperator;
import kala.function.ShortConsumer;
import kala.function.ShortFunction;
import kala.function.ShortObjBiFunction;
import kala.function.ShortPredicate;
import kala.function.ShortUnaryOperator;
import kala.internal.InternalShortArrayBuilder;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ShortIterator
extends PrimitiveIterator<Short, ShortConsumer> {
    @NotNull
    public static ShortIterator empty() {
        return ShortIterators.EMPTY;
    }

    @NotNull
    public static ShortIterator of() {
        return ShortIterator.empty();
    }

    @NotNull
    public static ShortIterator of(final short value) {
        return new ShortIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public short nextShort() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return value;
                }
                throw new NoSuchElementException();
            }

            public String toString() {
                if (this.hasNext) {
                    return "ShortIterator[" + value + "]";
                }
                return "ShortIterator[]";
            }
        };
    }

    @NotNull
    public static ShortIterator of(short ... values) {
        return ShortArrays.iterator(values);
    }

    @NotNull
    public static ShortIterator ofIterator(final @NotNull @NotNull Iterator<? extends @NotNull Short> it) {
        Objects.requireNonNull(it);
        if (it instanceof ShortIterator) {
            return (ShortIterator)it;
        }
        return new ShortIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public short nextShort() {
                return (Short)it.next();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static ShortIterator concat(@NotNull ShortIterator it1, @NotNull ShortIterator it2) {
        if (!it1.hasNext()) {
            return Objects.requireNonNull(it2);
        }
        if (!it2.hasNext()) {
            return it1;
        }
        return new ShortIterators.Concat(it1, it2);
    }

    @NotNull
    public static ShortIterator concat(ShortIterator ... its) {
        switch (its.length) {
            case 0: {
                return ShortIterator.empty();
            }
            case 1: {
                return Objects.requireNonNull(its[0]);
            }
            case 2: {
                return ShortIterator.concat(its[0], its[1]);
            }
        }
        return new ShortIterators.ConcatAll(GenericArrays.iterator(its));
    }

    @NotNull
    public static ShortIterator concat(@NotNull Iterable<? extends ShortIterator> its) {
        return ShortIterator.concat(its.iterator());
    }

    @NotNull
    public static ShortIterator concat(@NotNull Iterator<? extends ShortIterator> its) {
        if (!its.hasNext()) {
            return ShortIterator.empty();
        }
        return new ShortIterators.ConcatAll(its);
    }

    public short nextShort();

    @Override
    default public void nextIgnoreResult() {
        this.nextShort();
    }

    @Override
    @Deprecated
    @NotNull
    default public Short next() {
        return this.nextShort();
    }

    @NotNull
    default public ShortOption find(@NotNull ShortPredicate predicate) {
        while (this.hasNext()) {
            short value = this.nextShort();
            if (!predicate.test(value)) continue;
            return ShortOption.some(value);
        }
        return ShortOption.None;
    }

    default public boolean contains(short value) {
        while (this.hasNext()) {
            if (value != this.nextShort()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean contains(Object value) {
        if (!(value instanceof Short)) {
            return false;
        }
        short v = (Short)value;
        while (this.hasNext()) {
            if (v != this.nextShort()) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(short @NotNull [] values) {
        block0: while (this.hasNext()) {
            short v = this.nextShort();
            for (short i : values) {
                if (i == v) continue block0;
            }
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull ShortIterator other) {
        while (this.hasNext() && other.hasNext()) {
            if (this.nextShort() == other.nextShort()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    @Override
    default public boolean sameElements(@NotNull Iterator<?> other) {
        if (other instanceof ShortIterator) {
            return this.sameElements((ShortIterator)other);
        }
        while (this.hasNext() && other.hasNext()) {
            Object value = other.next();
            if (!(value instanceof Short)) {
                return false;
            }
            if (((Short)value).shortValue() == this.nextShort()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    default public boolean anyMatch(@NotNull ShortPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextShort())) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(@NotNull ShortPredicate predicate) {
        while (this.hasNext()) {
            if (predicate.test(this.nextShort())) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(@NotNull ShortPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextShort())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public ShortIterator drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0 && this.hasNext()) {
            this.nextShort();
            --n;
        }
        return this;
    }

    @NotNull
    default public ShortIterator dropWhile(@NotNull ShortPredicate predicate) {
        if (!this.hasNext()) {
            return this;
        }
        short value = 0;
        boolean p = false;
        while (this.hasNext()) {
            value = this.nextShort();
            if (predicate.test(value)) continue;
            p = true;
            break;
        }
        if (p) {
            return this.hasNext() ? this.prepended(value) : ShortIterator.of(value);
        }
        return this;
    }

    @NotNull
    default public ShortIterator take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.hasNext() || n == 0) {
            return ShortIterator.empty();
        }
        return new ShortIterators.Take(this, n);
    }

    @NotNull
    default public ShortIterator takeWhile(@NotNull ShortPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return this;
        }
        return new ShortIterators.TakeWhile(this, predicate);
    }

    @NotNull
    default public ShortIterator updated(int n, short newValue) {
        if (!this.hasNext() || n < 0) {
            return this;
        }
        if (n == 0) {
            this.nextShort();
            return this.prepended(newValue);
        }
        return new ShortIterators.Updated(this, n, newValue);
    }

    @NotNull
    default public ShortIterator prepended(short value) {
        return new ShortIterators.Prepended(this, value);
    }

    @NotNull
    default public ShortIterator appended(short value) {
        return new ShortIterators.Appended(this, value);
    }

    @NotNull
    default public ShortIterator filter(@NotNull ShortPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return ShortIterator.empty();
        }
        return new ShortIterators.Filter(this, predicate, false);
    }

    @NotNull
    default public ShortIterator filterNot(@NotNull ShortPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return ShortIterator.empty();
        }
        return new ShortIterators.Filter(this, predicate, true);
    }

    @NotNull
    default public ShortIterator map(final @NotNull ShortUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return this;
        }
        return new AbstractShortIterator(){

            @Override
            public boolean hasNext() {
                return ShortIterator.this.hasNext();
            }

            @Override
            public short nextShort() {
                return mapper.applyAsShort(ShortIterator.this.nextShort());
            }
        };
    }

    @NotNull
    default public <U> Iterator<U> mapToObj(final @NotNull ShortFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return ShortIterator.this.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(ShortIterator.this.nextShort());
            }
        };
    }

    @NotNull
    default public @NotNull Tuple2<@NotNull ShortIterator, @NotNull ShortIterator> span(@NotNull ShortPredicate predicate) {
        if (!this.hasNext()) {
            return Tuple.of(ShortIterator.empty(), ShortIterator.empty());
        }
        InternalShortArrayBuilder builder = new InternalShortArrayBuilder();
        ShortIterator it = this;
        while (it.hasNext()) {
            short e = it.nextShort();
            if (predicate.test(e)) {
                builder.append(e);
                continue;
            }
            it = it.prepended(e);
            break;
        }
        return Tuple.of(builder.iterator(), it);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ShortGrowable> G filterTo(@NotNull G destination, @NotNull ShortPredicate predicate) {
        ShortIterator it = this;
        while (it.hasNext()) {
            short e = it.nextShort();
            if (!predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ShortGrowable> G filterNotTo(@NotNull G destination, @NotNull ShortPredicate predicate) {
        ShortIterator it = this;
        while (it.hasNext()) {
            short e = it.nextShort();
            if (predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ShortGrowable> G mapTo(@NotNull G destination, @NotNull ShortUnaryOperator mapper) {
        ShortIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.applyAsShort(it.nextShort()));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull ShortFunction<? extends U> mapper) {
        ShortIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.apply(it.nextShort()));
        }
        return destination;
    }

    default public int count(@NotNull ShortPredicate predicate) {
        int c = 0;
        while (this.hasNext()) {
            if (!predicate.test(this.nextShort())) continue;
            ++c;
        }
        return c;
    }

    default public short max() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        short value = this.nextShort();
        while (this.hasNext()) {
            value = (short)Math.max(value, this.nextShort());
        }
        return value;
    }

    @Override
    @Nullable
    default public Short maxOrNull() {
        return this.hasNext() ? Short.valueOf(this.max()) : null;
    }

    @NotNull
    default public ShortOption maxOption() {
        return this.hasNext() ? ShortOption.some(this.max()) : ShortOption.none();
    }

    default public short min() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        short value = this.nextShort();
        while (this.hasNext()) {
            value = (short)Math.min(value, this.nextShort());
        }
        return value;
    }

    @Override
    @Nullable
    default public Short minOrNull() {
        return this.hasNext() ? Short.valueOf(this.min()) : null;
    }

    @NotNull
    default public ShortOption minOption() {
        return this.hasNext() ? ShortOption.some(this.min()) : ShortOption.none();
    }

    default public short fold(short zero, @NotNull ShortBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public short foldLeft(short zero, @NotNull ShortBinaryOperator op) {
        while (this.hasNext()) {
            zero = op.applyAsShort(zero, this.nextShort());
        }
        return zero;
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjShortBiFunction<U, U> op) {
        while (this.hasNext()) {
            zero = op.apply(zero, this.nextShort());
        }
        return zero;
    }

    default public short foldRight(short zero, @NotNull ShortBinaryOperator op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalShortArrayBuilder builder = new InternalShortArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextShort());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.applyAsShort(builder.get(i), zero);
        }
        return zero;
    }

    default public <U> U foldRightToObj(U zero, @NotNull ShortObjBiFunction<U, U> op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalShortArrayBuilder builder = new InternalShortArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextShort());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.apply(builder.get(i), zero);
        }
        return zero;
    }

    default public short reduce(@NotNull ShortBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Short reduceOrNull(@NotNull ShortBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public ShortOption reduceOption(@NotNull ShortBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public short reduceLeft(@NotNull ShortBinaryOperator op) {
        short e = this.nextShort();
        while (this.hasNext()) {
            e = op.applyAsShort(e, this.nextShort());
        }
        return e;
    }

    @Nullable
    default public Short reduceLeftOrNull(@NotNull ShortBinaryOperator op) {
        return this.hasNext() ? Short.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public ShortOption reduceLeftOption(@NotNull ShortBinaryOperator op) {
        return this.hasNext() ? ShortOption.some(this.reduceLeft(op)) : ShortOption.none();
    }

    default public short reduceRight(@NotNull ShortBinaryOperator op) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        InternalShortArrayBuilder list = new InternalShortArrayBuilder();
        list.append(this.nextShort());
        while (this.hasNext()) {
            list.append(this.nextShort());
        }
        int size = list.size();
        short e = list.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.applyAsShort(list.get(i), e);
        }
        return e;
    }

    @Nullable
    default public Short reduceRightOrNull(@NotNull ShortBinaryOperator op) {
        return this.hasNext() ? Short.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public ShortOption reduceRightOption(@NotNull ShortBinaryOperator op) {
        return this.hasNext() ? ShortOption.some(this.reduceRight(op)) : ShortOption.none();
    }

    default public short @NotNull [] toArray() {
        if (!this.hasNext()) {
            return ShortArrays.EMPTY;
        }
        InternalShortArrayBuilder builder = new InternalShortArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextShort());
        }
        return builder.toArray();
    }

    @Override
    default public void forEach(@NotNull ShortConsumer action) {
        while (this.hasNext()) {
            action.accept(this.nextShort());
        }
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Short> action) {
        if (action instanceof ShortConsumer) {
            this.forEach((ShortConsumer)((Object)action));
        } else {
            this.forEach(action::accept);
        }
    }

    @Override
    default public void forEachRemaining(@NotNull ShortConsumer action) {
        this.forEach(action);
    }

    @Override
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        try {
            buffer.append(prefix);
            if (this.hasNext()) {
                buffer.append(String.valueOf(this.nextShort()));
            }
            while (this.hasNext()) {
                buffer.append(separator).append(String.valueOf(this.nextShort()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Override
    default public int hash() {
        int res = 0;
        while (this.hasNext()) {
            res = res * 31 + Short.hashCode(this.nextShort());
        }
        return res;
    }
}

