/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractShortIterator;
import kala.collection.base.primitive.ShortIterator;
import kala.function.ShortPredicate;
import org.jetbrains.annotations.NotNull;

final class ShortIterators {
    static final ShortIterator EMPTY = new AbstractShortIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public short nextShort() {
            throw new NoSuchElementException();
        }

        @Override
        public String toString() {
            return "ShortIterator[]";
        }
    };

    ShortIterators() {
    }

    static final class Filter
    extends AbstractShortIterator {
        @NotNull
        private final ShortIterator source;
        @NotNull
        private final ShortPredicate predicate;
        private short nextValue;
        private boolean flag = false;
        private final boolean isFlipped;

        Filter(@NotNull ShortIterator source, @NotNull ShortPredicate predicate, boolean isFlipped) {
            this.source = source;
            this.predicate = predicate;
            this.isFlipped = isFlipped;
        }

        @Override
        public boolean hasNext() {
            if (this.flag) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            short v = this.source.nextShort();
            while (this.predicate.test(v) == this.isFlipped) {
                if (!this.source.hasNext()) {
                    return false;
                }
                v = this.source.nextShort();
            }
            this.nextValue = v;
            this.flag = true;
            return true;
        }

        @Override
        public short nextShort() {
            if (this.hasNext()) {
                this.flag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Appended
    extends AbstractShortIterator {
        @NotNull
        private final ShortIterator source;
        private final short value;
        private boolean flag = true;

        Appended(@NotNull ShortIterator source, short value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext() || this.flag;
        }

        @Override
        public short nextShort() {
            if (this.source.hasNext()) {
                return this.source.nextShort();
            }
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Prepended
    extends AbstractShortIterator {
        @NotNull
        private final ShortIterator source;
        private final short value;
        private boolean flag = true;

        Prepended(@NotNull ShortIterator source, short value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.flag || this.source.hasNext();
        }

        @Override
        public short nextShort() {
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            return this.source.nextShort();
        }
    }

    static final class Updated
    extends AbstractShortIterator {
        @NotNull
        private final ShortIterator source;
        private final int n;
        private final short newValue;
        private int idx = 0;

        Updated(@NotNull ShortIterator source, int n, short newValue) {
            this.source = source;
            this.n = n;
            this.newValue = newValue;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public short nextShort() {
            if (this.idx++ == this.n) {
                this.source.nextShort();
                return this.newValue;
            }
            return this.source.nextShort();
        }
    }

    static final class TakeWhile
    extends AbstractShortIterator {
        @NotNull
        private ShortIterator source;
        private ShortPredicate predicate;
        private short nextValue;
        private boolean tag = false;

        TakeWhile(@NotNull ShortIterator source, ShortPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.tag) {
                return true;
            }
            if (this.source.hasNext()) {
                this.nextValue = this.source.nextShort();
                short v = this.nextValue;
                if (this.predicate.test(v)) {
                    this.tag = true;
                    return true;
                }
                this.source = EMPTY;
                this.predicate = null;
                return false;
            }
            return false;
        }

        @Override
        public short nextShort() {
            if (this.hasNext()) {
                this.tag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Take
    extends AbstractShortIterator {
        private final ShortIterator source;
        private int n;

        Take(ShortIterator source, int n) {
            this.source = source;
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.n > 0 && this.source.hasNext();
        }

        @Override
        public short nextShort() {
            if (this.hasNext()) {
                --this.n;
                return this.source.nextShort();
            }
            throw new NoSuchElementException();
        }
    }

    static final class ConcatAll
    extends AbstractShortIterator {
        @NotNull
        private final Iterator<? extends ShortIterator> iterators;
        private ShortIterator current = null;

        ConcatAll(@NotNull Iterator<? extends ShortIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.current.nextShort();
        }
    }

    static final class Concat
    extends AbstractShortIterator {
        private ShortIterator it1;
        private ShortIterator it2;

        Concat(ShortIterator it1, ShortIterator it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            if (this.it1 != null) {
                if (this.it1.hasNext()) {
                    return true;
                }
                this.it1 = null;
            }
            if (this.it2 != null) {
                if (this.it2.hasNext()) {
                    return true;
                }
                this.it2 = null;
            }
            return false;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.it1 != null) {
                return this.it1.nextShort();
            }
            if (this.it2 != null) {
                return this.it2.nextShort();
            }
            throw new AssertionError();
        }
    }
}

