/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.factory;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import kala.collection.base.AnyTraversable;
import kala.collection.base.Sized;
import kala.collection.factory.Factory;
import org.jetbrains.annotations.NotNull;

public interface MapFactory<K, V, Builder, R>
extends Factory<Builder, R> {
    public static <T, K, V, Builder, R> Collector<T, ?, R> collector(@NotNull MapFactory<K, V, Builder, R> factory, @NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return factory.collector(keyMapper, valueMapper);
    }

    @Override
    public Builder newBuilder();

    @Override
    public R build(Builder var1);

    public void addToBuilder(Builder var1, K var2, V var3);

    default public void addAllToBuilder(Builder builder, @NotNull Map<? extends K, ? extends V> values) {
        values.forEach((k, v) -> this.addToBuilder(builder, k, v));
    }

    public Builder mergeBuilder(Builder var1, Builder var2);

    @NotNull
    default public <T> Collector<T, Builder, R> collector(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return Collector.of(this::newBuilder, (builder, t) -> this.addToBuilder(builder, keyMapper.apply(t), valueMapper.apply(t)), this::mergeBuilder, this::build, new Collector.Characteristics[0]);
    }

    default public void sizeHint(@NotNull Builder builder, int size) {
    }

    default public void sizeHint(@NotNull Builder builder, @NotNull Iterable<?> it) {
        this.sizeHint(builder, it, 0);
    }

    default public void sizeHint(@NotNull Builder builder, @NotNull Iterable<?> it, int delta) {
        int ks;
        if (it instanceof Collection) {
            int s = ((Collection)it).size();
            this.sizeHint(builder, s + delta);
        } else if (it instanceof AnyTraversable && (ks = ((AnyTraversable)((Object)it)).knownSize()) > 0) {
            this.sizeHint(builder, ks + delta);
        }
    }

    default public void sizeHint(@NotNull Builder builder, @NotNull Map<?, ?> it) {
        this.sizeHint(builder, it.size());
    }

    default public void sizeHint(@NotNull Builder builder, Sized it) {
        int ks = it.knownSize();
        if (ks >= 0) {
            this.sizeHint(builder, ks);
        }
    }

    @NotNull
    default public <U> MapFactory<K, V, Builder, U> mapResult(final @NotNull Function<? super R, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        final class MappedFactory
        implements MapFactory<K, V, Builder, U> {
            MappedFactory() {
            }

            @Override
            public Builder newBuilder() {
                return MapFactory.this.newBuilder();
            }

            @Override
            public U build(Builder builder) {
                return mapper.apply(MapFactory.this.build(builder));
            }

            @Override
            public void addToBuilder(Builder builder, K key, V value) {
                MapFactory.this.addToBuilder(builder, key, value);
            }

            @Override
            public Builder mergeBuilder(Builder builder1, Builder builder2) {
                return MapFactory.this.mergeBuilder(builder1, builder2);
            }

            @Override
            public void sizeHint(@NotNull Builder builder, int size) {
                MapFactory.this.sizeHint(builder, size);
            }
        }
        return new MappedFactory();
    }
}

