/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.factory.primitive;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionBuilder;
import kala.collection.factory.primitive.PrimitiveCollectionFactory;
import kala.function.FloatConsumer;
import kala.function.FloatSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface FloatCollectionFactory<Builder, R>
extends PrimitiveCollectionFactory<Float, Builder, R> {
    public static <Builder, R> FloatCollectionFactory<Builder, R> narrow(FloatCollectionFactory<Builder, ? extends R> factory) {
        return factory;
    }

    @ApiStatus.Experimental
    public static <Builder, R> R buildBy(@NotNull FloatCollectionFactory<Builder, R> factory, Consumer<FloatConsumer> consumer) {
        Object builder = factory.newBuilder();
        consumer.accept(value -> factory.addToBuilder((Builder)builder, value));
        return factory.build(builder);
    }

    @ApiStatus.Experimental
    @NotNull
    default public FloatCollectionBuilder<R> newCollectionBuilder(final Builder builder) {
        return new FloatCollectionBuilder<R>(){

            @Override
            public void plusAssign(float value) {
                FloatCollectionFactory.this.addToBuilder(builder, value);
            }

            @Override
            public void sizeHint(int size) {
                FloatCollectionFactory.this.sizeHint(builder, size);
            }

            @Override
            public R build() {
                return FloatCollectionFactory.this.build(builder);
            }
        };
    }

    @ApiStatus.Experimental
    @NotNull
    default public FloatCollectionBuilder<R> newCollectionBuilder() {
        return this.newCollectionBuilder(this.newBuilder());
    }

    @ApiStatus.Experimental
    @NotNull
    default public FloatCollectionBuilder<R> newCollectionBuilder(int capacity) {
        return this.newCollectionBuilder(this.newBuilder(capacity));
    }

    @Override
    public void addToBuilder(@NotNull Builder var1, float var2);

    @Override
    default public void addToBuilder(@NotNull Builder builder, Float value) {
        this.addToBuilder(builder, value.floatValue());
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull FloatTraversable values) {
        this.addAllToBuilder(builder, values.iterator());
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull FloatIterator it) {
        while (it.hasNext()) {
            this.addToBuilder(builder, it.nextFloat());
        }
    }

    default public void addAllToBuilder(@NotNull Builder builder, float @NotNull [] values) {
        Objects.requireNonNull(values);
        for (float value : values) {
            this.addToBuilder(builder, value);
        }
    }

    @Override
    default public R fill(int n, float value) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, value);
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, FloatSupplier supplier) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, supplier.getAsFloat());
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, Float value) {
        return this.fill(n, value.floatValue());
    }

    default public R from(float @NotNull [] values) {
        if (values.length == 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, values.length);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull FloatTraversable values) {
        Object builder = this.newBuilder();
        this.sizeHint(builder, values);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull FloatIterator it) {
        if (!it.hasNext()) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.addAllToBuilder(builder, it);
        return this.build(builder);
    }

    @Override
    @NotNull
    default public <U> FloatCollectionFactory<Builder, U> mapResult(final @NotNull Function<? super R, ? extends U> mapper) {
        final FloatCollectionFactory self = this;
        return new FloatCollectionFactory<Builder, U>(){

            @Override
            public void addToBuilder(@NotNull Builder builder, float value) {
                self.addToBuilder(builder, value);
            }

            @Override
            public Builder newBuilder() {
                return self.newBuilder();
            }

            @Override
            public U build(Builder builder) {
                return mapper.apply(self.build(builder));
            }

            @Override
            public Builder mergeBuilder(@NotNull Builder builder1, @NotNull Builder builder2) {
                return self.mergeBuilder(builder1, builder2);
            }
        };
    }
}

