/*
 * Decompiled with CFR 0.152.
 */
package kala.comparator.primitive;

import java.io.Serializable;
import kala.comparator.primitive.ByteComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ByteComparators {
    ByteComparators() {
    }

    static final class ReverseOrderNullComparator
    implements ByteComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final ReverseOrderNullComparator NULLS_FIRST = new ReverseOrderNullComparator(true);
        static final ReverseOrderNullComparator NULLS_LAST = new ReverseOrderNullComparator(false);
        private final boolean nullFirst;

        ReverseOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(byte b1, byte b2) {
            return Byte.compare(b2, b1);
        }

        @Override
        public int compare(Byte b1, Byte b2) {
            if (b1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return b2.compareTo(b1);
        }

        @Override
        @NotNull
        public ByteComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public ByteComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public ByteComparator reversed() {
            return this.nullFirst ? NaturalOrderNullComparator.NULLS_LAST : NaturalOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NaturalOrderNullComparator
    implements ByteComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final NaturalOrderNullComparator NULLS_FIRST = new NaturalOrderNullComparator(true);
        static final NaturalOrderNullComparator NULLS_LAST = new NaturalOrderNullComparator(false);
        private final boolean nullFirst;

        NaturalOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(byte b1, byte b2) {
            return Byte.compare(b1, b2);
        }

        @Override
        public int compare(Byte b1, Byte b2) {
            if (b1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return b1.compareTo(b2);
        }

        @Override
        @NotNull
        public ByteComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public ByteComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public ByteComparator reversed() {
            return this.nullFirst ? ReverseOrderNullComparator.NULLS_LAST : ReverseOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NullComparator
    implements ByteComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final boolean nullFirst;
        @NotNull
        private final ByteComparator real;

        NullComparator(boolean nullFirst, @NotNull ByteComparator real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(byte b1, byte b2) {
            return this.real.compare(b1, b2);
        }

        @Override
        public int compare(@Nullable Byte b1, @Nullable Byte b2) {
            if (b1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real.compare(b1, b2);
        }

        @Override
        @NotNull
        public ByteComparator nullsFirst() {
            return this.nullFirst ? this : new NullComparator(true, this.real);
        }

        @Override
        @NotNull
        public ByteComparator nullsLast() {
            return this.nullFirst ? new NullComparator(false, this.real) : this;
        }

        @Override
        @NotNull
        public ByteComparator reversed() {
            return new NullComparator(!this.nullFirst, this.real.reversed());
        }
    }

    static enum ReverseOrderComparator implements ByteComparator
    {
        INSTANCE;


        @Override
        public final int compare(byte b1, byte b2) {
            return Byte.compare(b2, b1);
        }

        @Override
        @NotNull
        public final ByteComparator nullsFirst() {
            return ReverseOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final ByteComparator nullsLast() {
            return ReverseOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final ByteComparator reversed() {
            return NaturalOrderComparator.INSTANCE;
        }
    }

    static enum NaturalOrderComparator implements ByteComparator
    {
        INSTANCE;


        @Override
        public final int compare(byte b1, byte b2) {
            return Byte.compare(b1, b2);
        }

        @Override
        @NotNull
        public final ByteComparator nullsFirst() {
            return NaturalOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final ByteComparator nullsLast() {
            return NaturalOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final ByteComparator reversed() {
            return ReverseOrderComparator.INSTANCE;
        }
    }
}

