/*
 * Decompiled with CFR 0.152.
 */
package kala.comparator.primitive;

import java.io.Serializable;
import kala.comparator.primitive.CharComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CharComparators {
    CharComparators() {
    }

    static final class ReverseOrderNullComparator
    implements CharComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final ReverseOrderNullComparator NULLS_FIRST = new ReverseOrderNullComparator(true);
        static final ReverseOrderNullComparator NULLS_LAST = new ReverseOrderNullComparator(false);
        private final boolean nullFirst;

        ReverseOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(char c1, char c2) {
            return Character.compare(c2, c1);
        }

        @Override
        public int compare(Character c1, Character c2) {
            if (c1 == null) {
                return c2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (c2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return c2.compareTo(c1);
        }

        @Override
        @NotNull
        public CharComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public CharComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public CharComparator reversed() {
            return this.nullFirst ? NaturalOrderNullComparator.NULLS_LAST : NaturalOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NaturalOrderNullComparator
    implements CharComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final NaturalOrderNullComparator NULLS_FIRST = new NaturalOrderNullComparator(true);
        static final NaturalOrderNullComparator NULLS_LAST = new NaturalOrderNullComparator(false);
        private final boolean nullFirst;

        NaturalOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(char c1, char b2) {
            return Character.compare(c1, b2);
        }

        @Override
        public int compare(Character c1, Character b2) {
            if (c1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return c1.compareTo(b2);
        }

        @Override
        @NotNull
        public CharComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public CharComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public CharComparator reversed() {
            return this.nullFirst ? ReverseOrderNullComparator.NULLS_LAST : ReverseOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NullComparator
    implements CharComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final boolean nullFirst;
        @NotNull
        private final CharComparator real;

        NullComparator(boolean nullFirst, @NotNull CharComparator real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(char c1, char b2) {
            return this.real.compare(c1, b2);
        }

        @Override
        public int compare(@Nullable Character c1, @Nullable Character b2) {
            if (c1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real.compare(c1, b2);
        }

        @Override
        @NotNull
        public CharComparator nullsFirst() {
            return this.nullFirst ? this : new NullComparator(true, this.real);
        }

        @Override
        @NotNull
        public CharComparator nullsLast() {
            return this.nullFirst ? new NullComparator(false, this.real) : this;
        }

        @Override
        @NotNull
        public CharComparator reversed() {
            return new NullComparator(!this.nullFirst, this.real.reversed());
        }
    }

    static enum ReverseOrderComparator implements CharComparator
    {
        INSTANCE;


        @Override
        public final int compare(char c1, char b2) {
            return Character.compare(b2, c1);
        }

        @Override
        @NotNull
        public final CharComparator nullsFirst() {
            return ReverseOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final CharComparator nullsLast() {
            return ReverseOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final CharComparator reversed() {
            return NaturalOrderComparator.INSTANCE;
        }
    }

    static enum NaturalOrderComparator implements CharComparator
    {
        INSTANCE;


        @Override
        public final int compare(char c1, char b2) {
            return Character.compare(c1, b2);
        }

        @Override
        @NotNull
        public final CharComparator nullsFirst() {
            return NaturalOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final CharComparator nullsLast() {
            return NaturalOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final CharComparator reversed() {
            return ReverseOrderComparator.INSTANCE;
        }
    }
}

