/*
 * Decompiled with CFR 0.152.
 */
package kala.comparator.primitive;

import java.io.Serializable;
import kala.comparator.primitive.DoubleComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DoubleComparators {
    DoubleComparators() {
    }

    static final class ReverseOrderNullComparator
    implements DoubleComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final ReverseOrderNullComparator NULLS_FIRST = new ReverseOrderNullComparator(true);
        static final ReverseOrderNullComparator NULLS_LAST = new ReverseOrderNullComparator(false);
        private final boolean nullFirst;

        ReverseOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(double d1, double d2) {
            return Double.compare(d2, d1);
        }

        @Override
        public int compare(Double d1, Double d2) {
            if (d1 == null) {
                return d2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (d2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return d2.compareTo(d1);
        }

        @Override
        @NotNull
        public DoubleComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public DoubleComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public DoubleComparator reversed() {
            return this.nullFirst ? NaturalOrderNullComparator.NULLS_LAST : NaturalOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NaturalOrderNullComparator
    implements DoubleComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final NaturalOrderNullComparator NULLS_FIRST = new NaturalOrderNullComparator(true);
        static final NaturalOrderNullComparator NULLS_LAST = new NaturalOrderNullComparator(false);
        private final boolean nullFirst;

        NaturalOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(double d1, double b2) {
            return Double.compare(d1, b2);
        }

        @Override
        public int compare(Double d1, Double b2) {
            if (d1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return d1.compareTo(b2);
        }

        @Override
        @NotNull
        public DoubleComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public DoubleComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public DoubleComparator reversed() {
            return this.nullFirst ? ReverseOrderNullComparator.NULLS_LAST : ReverseOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NullComparator
    implements DoubleComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final boolean nullFirst;
        @NotNull
        private final DoubleComparator real;

        NullComparator(boolean nullFirst, @NotNull DoubleComparator real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(double d1, double b2) {
            return this.real.compare(d1, b2);
        }

        @Override
        public int compare(@Nullable Double d1, @Nullable Double b2) {
            if (d1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real.compare(d1, b2);
        }

        @Override
        @NotNull
        public DoubleComparator nullsFirst() {
            return this.nullFirst ? this : new NullComparator(true, this.real);
        }

        @Override
        @NotNull
        public DoubleComparator nullsLast() {
            return this.nullFirst ? new NullComparator(false, this.real) : this;
        }

        @Override
        @NotNull
        public DoubleComparator reversed() {
            return new NullComparator(!this.nullFirst, this.real.reversed());
        }
    }

    static enum ReverseOrderComparator implements DoubleComparator
    {
        INSTANCE;


        @Override
        public final int compare(double d1, double b2) {
            return Double.compare(b2, d1);
        }

        @Override
        @NotNull
        public final DoubleComparator nullsFirst() {
            return ReverseOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final DoubleComparator nullsLast() {
            return ReverseOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final DoubleComparator reversed() {
            return NaturalOrderComparator.INSTANCE;
        }
    }

    static enum NaturalOrderComparator implements DoubleComparator
    {
        INSTANCE;


        @Override
        public final int compare(double d1, double b2) {
            return Double.compare(d1, b2);
        }

        @Override
        @NotNull
        public final DoubleComparator nullsFirst() {
            return NaturalOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final DoubleComparator nullsLast() {
            return NaturalOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final DoubleComparator reversed() {
            return ReverseOrderComparator.INSTANCE;
        }
    }
}

