/*
 * Decompiled with CFR 0.152.
 */
package kala.comparator.primitive;

import java.io.Serializable;
import kala.comparator.primitive.IntComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IntComparators {
    IntComparators() {
    }

    static final class ReverseOrderNullComparator
    implements IntComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final ReverseOrderNullComparator NULLS_FIRST = new ReverseOrderNullComparator(true);
        static final ReverseOrderNullComparator NULLS_LAST = new ReverseOrderNullComparator(false);
        private final boolean nullFirst;

        ReverseOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(int i1, int i2) {
            return Integer.compare(i2, i1);
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            if (i1 == null) {
                return i2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (i2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return i2.compareTo(i1);
        }

        @Override
        @NotNull
        public IntComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public IntComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public IntComparator reversed() {
            return this.nullFirst ? NaturalOrderNullComparator.NULLS_LAST : NaturalOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NaturalOrderNullComparator
    implements IntComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final NaturalOrderNullComparator NULLS_FIRST = new NaturalOrderNullComparator(true);
        static final NaturalOrderNullComparator NULLS_LAST = new NaturalOrderNullComparator(false);
        private final boolean nullFirst;

        NaturalOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(int i1, int b2) {
            return Integer.compare(i1, b2);
        }

        @Override
        public int compare(Integer i1, Integer b2) {
            if (i1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return i1.compareTo(b2);
        }

        @Override
        @NotNull
        public IntComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public IntComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public IntComparator reversed() {
            return this.nullFirst ? ReverseOrderNullComparator.NULLS_LAST : ReverseOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NullComparator
    implements IntComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final boolean nullFirst;
        @NotNull
        private final IntComparator real;

        NullComparator(boolean nullFirst, @NotNull IntComparator real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(int i1, int b2) {
            return this.real.compare(i1, b2);
        }

        @Override
        public int compare(@Nullable Integer i1, @Nullable Integer b2) {
            if (i1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real.compare(i1, b2);
        }

        @Override
        @NotNull
        public IntComparator nullsFirst() {
            return this.nullFirst ? this : new NullComparator(true, this.real);
        }

        @Override
        @NotNull
        public IntComparator nullsLast() {
            return this.nullFirst ? new NullComparator(false, this.real) : this;
        }

        @Override
        @NotNull
        public IntComparator reversed() {
            return new NullComparator(!this.nullFirst, this.real.reversed());
        }
    }

    static enum ReverseOrderComparator implements IntComparator
    {
        INSTANCE;


        @Override
        public final int compare(int i1, int b2) {
            return Integer.compare(b2, i1);
        }

        @Override
        @NotNull
        public final IntComparator nullsFirst() {
            return ReverseOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final IntComparator nullsLast() {
            return ReverseOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final IntComparator reversed() {
            return NaturalOrderComparator.INSTANCE;
        }
    }

    static enum NaturalOrderComparator implements IntComparator
    {
        INSTANCE;


        @Override
        public final int compare(int i1, int b2) {
            return Integer.compare(i1, b2);
        }

        @Override
        @NotNull
        public final IntComparator nullsFirst() {
            return NaturalOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final IntComparator nullsLast() {
            return NaturalOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final IntComparator reversed() {
            return ReverseOrderComparator.INSTANCE;
        }
    }
}

