/*
 * Decompiled with CFR 0.152.
 */
package kala.comparator.primitive;

import java.io.Serializable;
import kala.comparator.primitive.ShortComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShortComparators {
    ShortComparators() {
    }

    static final class ReverseOrderNullComparator
    implements ShortComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final ReverseOrderNullComparator NULLS_FIRST = new ReverseOrderNullComparator(true);
        static final ReverseOrderNullComparator NULLS_LAST = new ReverseOrderNullComparator(false);
        private final boolean nullFirst;

        ReverseOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(short s1, short s2) {
            return Short.compare(s2, s1);
        }

        @Override
        public int compare(Short s1, Short s2) {
            if (s1 == null) {
                return s2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (s2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return s2.compareTo(s1);
        }

        @Override
        @NotNull
        public ShortComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public ShortComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public ShortComparator reversed() {
            return this.nullFirst ? NaturalOrderNullComparator.NULLS_LAST : NaturalOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NaturalOrderNullComparator
    implements ShortComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final NaturalOrderNullComparator NULLS_FIRST = new NaturalOrderNullComparator(true);
        static final NaturalOrderNullComparator NULLS_LAST = new NaturalOrderNullComparator(false);
        private final boolean nullFirst;

        NaturalOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(short s1, short b2) {
            return Short.compare(s1, b2);
        }

        @Override
        public int compare(Short s1, Short b2) {
            if (s1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return s1.compareTo(b2);
        }

        @Override
        @NotNull
        public ShortComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public ShortComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public ShortComparator reversed() {
            return this.nullFirst ? ReverseOrderNullComparator.NULLS_LAST : ReverseOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NullComparator
    implements ShortComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final boolean nullFirst;
        @NotNull
        private final ShortComparator real;

        NullComparator(boolean nullFirst, @NotNull ShortComparator real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(short s1, short b2) {
            return this.real.compare(s1, b2);
        }

        @Override
        public int compare(@Nullable Short s1, @Nullable Short b2) {
            if (s1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real.compare(s1, b2);
        }

        @Override
        @NotNull
        public ShortComparator nullsFirst() {
            return this.nullFirst ? this : new NullComparator(true, this.real);
        }

        @Override
        @NotNull
        public ShortComparator nullsLast() {
            return this.nullFirst ? new NullComparator(false, this.real) : this;
        }

        @Override
        @NotNull
        public ShortComparator reversed() {
            return new NullComparator(!this.nullFirst, this.real.reversed());
        }
    }

    static enum ReverseOrderComparator implements ShortComparator
    {
        INSTANCE;


        @Override
        public final int compare(short s1, short b2) {
            return Short.compare(b2, s1);
        }

        @Override
        @NotNull
        public final ShortComparator nullsFirst() {
            return ReverseOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final ShortComparator nullsLast() {
            return ReverseOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final ShortComparator reversed() {
            return NaturalOrderComparator.INSTANCE;
        }
    }

    static enum NaturalOrderComparator implements ShortComparator
    {
        INSTANCE;


        @Override
        public final int compare(short s1, short b2) {
            return Short.compare(s1, b2);
        }

        @Override
        @NotNull
        public final ShortComparator nullsFirst() {
            return NaturalOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final ShortComparator nullsLast() {
            return NaturalOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final ShortComparator reversed() {
            return ReverseOrderComparator.INSTANCE;
        }
    }
}

