/*
 * Decompiled with CFR 0.152.
 */
package kala.concurrent;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import kala.function.CheckedRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConcurrentScope
implements AutoCloseable {
    private static final ThreadLocal<ConcurrentScope> current = new ThreadLocal();
    private final ConcurrentScope parent;
    private final Executor executor;
    private final boolean shutdownOnExit;

    public static Executor currentExecutor() {
        ConcurrentScope currentScope = current.get();
        return currentScope == null ? ForkJoinPool.commonPool() : currentScope.executor;
    }

    private ConcurrentScope(ConcurrentScope parent, Executor executor, boolean shutdownOnExit) {
        this.parent = parent;
        this.executor = executor;
        this.shutdownOnExit = shutdownOnExit;
    }

    public static ConcurrentScope withExecutor(@Nullable Executor executor) {
        return ConcurrentScope.withExecutor(executor, false);
    }

    public static ConcurrentScope withExecutorAndShutdown(@Nullable ExecutorService executor) {
        return ConcurrentScope.withExecutor((Executor)executor, true);
    }

    private static ConcurrentScope withExecutor(@Nullable Executor executor, boolean shutdownOnExit) {
        Objects.requireNonNull(executor);
        ConcurrentScope scope = new ConcurrentScope(current.get(), executor, shutdownOnExit);
        current.set(scope);
        return scope;
    }

    public static <Ex extends Throwable> void withExecutor(@Nullable Executor executor, @NotNull CheckedRunnable<Ex> action) throws Ex {
        ConcurrentScope.withExecutor(executor, false, action);
    }

    public static <Ex extends Throwable> void withExecutorAndShutdown(@Nullable ExecutorService executor, @NotNull CheckedRunnable<Ex> action) throws Ex {
        ConcurrentScope.withExecutor(executor, true, action);
    }

    private static <Ex extends Throwable> void withExecutor(@Nullable Executor executor, boolean shutdownOnExit, @NotNull CheckedRunnable<Ex> action) throws Ex {
        try (ConcurrentScope scope = ConcurrentScope.withExecutor(executor, shutdownOnExit);){
            action.runChecked();
        }
        catch (Throwable ex) {
            Throwable e = ex;
            throw e;
        }
    }

    @Override
    public void close() {
        if (current.get() != this) {
            throw new IllegalStateException();
        }
        current.set(this.parent);
        if (this.shutdownOnExit) {
            ((ExecutorService)this.executor).shutdown();
        }
    }
}

