/*
 * Decompiled with CFR 0.152.
 */
package kala.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.jetbrains.annotations.NotNull;

public final class LateInitCountDownLatch {
    private final Sync sync = new Sync();

    public LateInitCountDownLatch() {
    }

    public LateInitCountDownLatch(int count) {
        this.sync.threshold = count;
    }

    public void init(int count) {
        this.sync.threshold = count;
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public void countDown() {
        this.sync.releaseShared(1);
    }

    public Future<Void> awaitFuture() {
        return new AwaitFuture();
    }

    public int getCount() {
        return this.sync.getCount();
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -1871679293724769263L;
        volatile int threshold = -1;

        private Sync() {
        }

        int getCount() {
            return this.getState();
        }

        boolean isDone() {
            return this.getState() == this.threshold;
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            return this.getState() == this.threshold ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            do {
                if ((c = this.getState()) != this.threshold) continue;
                return false;
            } while (!this.compareAndSetState(c, nextc = c + 1));
            return nextc == this.threshold;
        }
    }

    private final class AwaitFuture
    implements Future<Void> {
        private AwaitFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return LateInitCountDownLatch.this.sync.isDone();
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            LateInitCountDownLatch.this.await();
            return null;
        }

        @Override
        public Void get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!LateInitCountDownLatch.this.await(timeout, unit)) {
                throw new TimeoutException();
            }
            return null;
        }
    }
}

