/*
 * Decompiled with CFR 0.152.
 */
package kala.control;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import kala.control.Either;
import kala.control.Option;
import kala.control.OptionContainer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Result<T, E>
implements OptionContainer<T>,
Serializable {
    private static final long serialVersionUID = -3388441653871179293L;

    Result() {
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T, E> Result<T, E> narrow(Result<? extends T, ? extends E> result) {
        return result;
    }

    @Contract(value="_ -> new")
    public static <T, E> Result<T, E> ok(T value) {
        return new Ok(value);
    }

    @Contract(value="_ -> new")
    public static <T, E> Result<T, E> err(E value) {
        return new Err(value);
    }

    public final boolean isOk() {
        return this instanceof Ok;
    }

    public final boolean isErr() {
        return this instanceof Err;
    }

    @Override
    public final boolean isDefined() {
        return this.isOk();
    }

    @Override
    public abstract T get();

    public abstract E getErr();

    @Nullable
    public final E getErrOrNull() {
        return this.isErr() ? (E)this.getErr() : null;
    }

    @NotNull
    public final Option<E> getErrOption() {
        return this.isErr() ? Option.some(this.getErr()) : Option.none();
    }

    @NotNull
    public final <U> Result<U, E> map(@NotNull Function<? super T, ? extends U> mapper) {
        return this.isOk() ? Result.ok(mapper.apply(this.get())) : this;
    }

    @NotNull
    public final <U> Result<T, U> mapErr(@NotNull Function<? super E, ? extends U> mapper) {
        return this.isErr() ? Result.err(mapper.apply(this.getErr())) : this;
    }

    @NotNull
    public final <U> Result<U, E> flatMap(@NotNull Function<? super T, ? extends Result<? extends U, ? extends E>> mapper) {
        return this.isOk() ? mapper.apply(this.get()) : this;
    }

    @Contract(value="-> new")
    @NotNull
    public final Either<E, T> toEither() {
        return this.isOk() ? Either.right(this.get()) : Either.left(this.getErr());
    }

    public final String toString() {
        if (this.isOk()) {
            return "Result.Ok[" + this.get() + "]";
        }
        return "Result.Err[" + this.getErr() + "]";
    }

    private static final class Ok<T, E>
    extends Result<T, E> {
        private static final long serialVersionUID = -7623929614408282297L;
        private static final int HASH_MAGIC = 227556744;
        private final T value;

        Ok(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        @Contract(value="-> fail")
        public E getErr() {
            throw new NoSuchElementException("Result.Ok.getErr()");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ok)) {
                return false;
            }
            return Objects.equals(this.value, ((Ok)o).value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value) + 227556744;
        }
    }

    private static final class Err<T, E>
    extends Result<T, E> {
        private static final long serialVersionUID = 8182313103380510810L;
        private static final int HASH_MAGIC = 1638357662;
        private final E err;

        Err(E err) {
            this.err = err;
        }

        @Override
        @Contract(value="-> fail")
        public T get() {
            throw new NoSuchElementException();
        }

        @Override
        public E getErr() {
            return this.err;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Err)) {
                return false;
            }
            return Objects.equals(this.err, ((Err)o).err);
        }

        public int hashCode() {
            return Objects.hashCode(this.err) + 1638357662;
        }
    }
}

