/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.control.Option;
import kala.control.primitive.PrimitiveOption;
import kala.function.ByteConsumer;
import kala.function.ByteSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteOption
extends PrimitiveOption<Byte>
implements ByteTraversable {
    private static final long serialVersionUID = -8990024629462620023L;
    public static final ByteOption None = new ByteOption();
    private final byte value;

    private ByteOption() {
        this.value = 0;
    }

    private ByteOption(byte value) {
        this.value = value;
    }

    @NotNull
    public static ByteOption some(byte value) {
        return new ByteOption(value);
    }

    @NotNull
    public static ByteOption none() {
        return None;
    }

    @Deprecated
    @NotNull
    public static ByteOption of(byte value) {
        return ByteOption.some(value);
    }

    @Deprecated
    @NotNull
    public static ByteOption of(@Nullable Byte value) {
        return ByteOption.ofNullable(value);
    }

    @NotNull
    public static ByteOption ofNullable(@Nullable Byte value) {
        return value == null ? None : ByteOption.some(value);
    }

    public boolean isDefined() {
        return this != None;
    }

    @Override
    public boolean isEmpty() {
        return this == None;
    }

    public byte get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ByteOption.None");
        }
        return this.value;
    }

    @Nullable
    public Byte getOrNull() {
        return this.isDefined() ? Byte.valueOf(this.value) : null;
    }

    public byte getOrDefault(byte defaultValue) {
        return this.isDefined() ? this.value : defaultValue;
    }

    public byte getOrElse(@NotNull ByteSupplier supplier) {
        return this.isDefined() ? this.get() : supplier.getAsByte();
    }

    public <Ex extends Throwable> byte getOrThrowException(@NotNull Ex exception) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(exception);
            throw exception;
        }
        return this.value;
    }

    public <Ex extends Throwable> byte getOrThrow(@NotNull Supplier<? extends Ex> supplier) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(supplier);
            throw (Throwable)supplier.get();
        }
        return this.value;
    }

    @NotNull
    public ByteOption orElse(ByteOption other) {
        return this.isDefined() ? this : other;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ByteOption) {
            return this != None && o != None && this.value == ((ByteOption)o).value;
        }
        if (o instanceof Option) {
            Option other = (Option)o;
            if (this.isEmpty()) {
                return other.isEmpty();
            }
            if (other.isEmpty()) {
                return false;
            }
            Object v = other.get();
            return v instanceof Byte && this.value == (Byte)v;
        }
        return false;
    }

    public int hashCode() {
        return this.isDefined() ? -818206074 + Byte.hashCode(this.value) : 1937147281;
    }

    public String toString() {
        return this == None ? "ByteOption.None" : "ByteOption[" + this.value + "]";
    }

    @Override
    @NotNull
    public ByteIterator iterator() {
        return this.isDefined() ? ByteIterator.of(this.value) : ByteIterator.empty();
    }

    @Override
    public void forEach(@NotNull ByteConsumer action) {
        if (this.isDefined()) {
            action.accept(this.value);
        }
    }

    private Object writeReplace() {
        return new Data(this == None ? null : Byte.valueOf(this.value));
    }

    private static final class Data
    implements Serializable {
        private static final long serialVersionUID = -2044232156734869349L;
        private final Byte value;

        Data(Byte value) {
            this.value = value;
        }

        Object readResolve() {
            return this.value == null ? None : ByteOption.some(this.value);
        }
    }
}

