/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.control.Option;
import kala.control.primitive.PrimitiveOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DoubleOption
extends PrimitiveOption<Double>
implements DoubleTraversable {
    private static final long serialVersionUID = -8990024629462620023L;
    public static final DoubleOption None = new DoubleOption();
    private final double value;

    private DoubleOption() {
        this.value = 0.0;
    }

    private DoubleOption(double value) {
        this.value = value;
    }

    @NotNull
    public static DoubleOption some(double value) {
        return new DoubleOption(value);
    }

    @NotNull
    public static DoubleOption none() {
        return None;
    }

    @Deprecated
    @NotNull
    public static DoubleOption of(double value) {
        return DoubleOption.some(value);
    }

    @Deprecated
    @NotNull
    public static DoubleOption of(@Nullable Double value) {
        return DoubleOption.ofNullable(value);
    }

    @NotNull
    public static DoubleOption ofNullable(@Nullable Double value) {
        return value == null ? None : DoubleOption.some(value);
    }

    @NotNull
    public static DoubleOption fromJava(@NotNull OptionalDouble optional) {
        return optional.isPresent() ? DoubleOption.some(optional.getAsDouble()) : DoubleOption.none();
    }

    public boolean isDefined() {
        return this != None;
    }

    @Override
    public boolean isEmpty() {
        return this == None;
    }

    public double get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("DoubleOption.None");
        }
        return this.value;
    }

    @Nullable
    public Double getOrNull() {
        return this.isDefined() ? Double.valueOf(this.value) : null;
    }

    public double getOrDefault(double defaultValue) {
        return this.isDefined() ? this.value : defaultValue;
    }

    public double getOrElse(@NotNull DoubleSupplier supplier) {
        return this.isDefined() ? this.get() : supplier.getAsDouble();
    }

    public <Ex extends Throwable> double getOrThrowException(@NotNull Ex exception) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(exception);
            throw exception;
        }
        return this.value;
    }

    public <Ex extends Throwable> double getOrThrow(@NotNull Supplier<? extends Ex> supplier) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(supplier);
            throw (Throwable)supplier.get();
        }
        return this.value;
    }

    @NotNull
    public DoubleOption orElse(DoubleOption other) {
        return this.isDefined() ? this : other;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DoubleOption) {
            return this != None && o != None && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((DoubleOption)o).value);
        }
        if (o instanceof Option) {
            Option other = (Option)o;
            if (this.isEmpty()) {
                return other.isEmpty();
            }
            if (other.isEmpty()) {
                return false;
            }
            Object v = other.get();
            return v instanceof Double && Double.doubleToLongBits(this.value) == Double.doubleToLongBits((Double)v);
        }
        return false;
    }

    public int hashCode() {
        return this.isDefined() ? -818206074 + Double.hashCode(this.value) : 1937147281;
    }

    public String toString() {
        return this == None ? "DoubleOption.None" : "DoubleOption[" + this.value + "]";
    }

    @Override
    @NotNull
    public DoubleIterator iterator() {
        return this.isDefined() ? DoubleIterator.of(this.value) : DoubleIterator.empty();
    }

    @Override
    public void forEach(@NotNull DoubleConsumer action) {
        if (this.isDefined()) {
            action.accept(this.value);
        }
    }

    private Object writeReplace() {
        return new Data(this == None ? null : Double.valueOf(this.value));
    }

    private static final class Data
    implements Serializable {
        private static final long serialVersionUID = -2044232156734869349L;
        private final Double value;

        Data(Double value) {
            this.value = value;
        }

        Object readResolve() {
            return this.value == null ? None : DoubleOption.some(this.value);
        }
    }
}

