/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.control.Option;
import kala.control.primitive.PrimitiveOption;
import kala.function.FloatConsumer;
import kala.function.FloatSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FloatOption
extends PrimitiveOption<Float>
implements FloatTraversable {
    private static final long serialVersionUID = -8990024629462620023L;
    public static final FloatOption None = new FloatOption();
    private final float value;

    private FloatOption() {
        this.value = 0.0f;
    }

    private FloatOption(float value) {
        this.value = value;
    }

    @NotNull
    public static FloatOption some(float value) {
        return new FloatOption(value);
    }

    @NotNull
    public static FloatOption none() {
        return None;
    }

    @Deprecated
    @NotNull
    public static FloatOption of(float value) {
        return FloatOption.some(value);
    }

    @Deprecated
    @NotNull
    public static FloatOption of(@Nullable Float value) {
        return FloatOption.ofNullable(value);
    }

    @NotNull
    public static FloatOption ofNullable(@Nullable Float value) {
        return value == null ? None : FloatOption.some(value.floatValue());
    }

    public boolean isDefined() {
        return this != None;
    }

    @Override
    public boolean isEmpty() {
        return this == None;
    }

    public float get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("FloatOption.None");
        }
        return this.value;
    }

    @Nullable
    public Float getOrNull() {
        return this.isDefined() ? Float.valueOf(this.value) : null;
    }

    public float getOrDefault(float defaultValue) {
        return this.isDefined() ? this.value : defaultValue;
    }

    public float getOrElse(@NotNull FloatSupplier supplier) {
        return this.isDefined() ? this.get() : supplier.getAsFloat();
    }

    public <Ex extends Throwable> float getOrThrowException(@NotNull Ex exception) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(exception);
            throw exception;
        }
        return this.value;
    }

    public <Ex extends Throwable> float getOrThrow(@NotNull Supplier<? extends Ex> supplier) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(supplier);
            throw (Throwable)supplier.get();
        }
        return this.value;
    }

    @NotNull
    public FloatOption orElse(FloatOption other) {
        return this.isDefined() ? this : other;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FloatOption) {
            return this != None && o != None && Float.floatToIntBits(this.value) == Float.floatToIntBits(((FloatOption)o).value);
        }
        if (o instanceof Option) {
            Option other = (Option)o;
            if (this.isEmpty()) {
                return other.isEmpty();
            }
            if (other.isEmpty()) {
                return false;
            }
            Object v = other.get();
            return v instanceof Float && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)v).floatValue());
        }
        return false;
    }

    public int hashCode() {
        return this.isDefined() ? -818206074 + Float.hashCode(this.value) : 1937147281;
    }

    public String toString() {
        return this == None ? "FloatOption.None" : "FloatOption[" + this.value + "]";
    }

    @Override
    @NotNull
    public FloatIterator iterator() {
        return this.isDefined() ? FloatIterator.of(this.value) : FloatIterator.empty();
    }

    @Override
    public void forEach(@NotNull FloatConsumer action) {
        if (this.isDefined()) {
            action.accept(this.value);
        }
    }

    private Object writeReplace() {
        return new Data(this == None ? null : Float.valueOf(this.value));
    }

    private static final class Data
    implements Serializable {
        private static final long serialVersionUID = -2044232156734869349L;
        private final Float value;

        Data(Float value) {
            this.value = value;
        }

        Object readResolve() {
            return this.value == null ? None : FloatOption.some(this.value.floatValue());
        }
    }
}

