/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.control.Option;
import kala.control.primitive.PrimitiveOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntOption
extends PrimitiveOption<Integer>
implements IntTraversable {
    private static final long serialVersionUID = -8990024629462620023L;
    public static final IntOption None = new IntOption();
    private final int value;

    private IntOption() {
        this.value = 0;
    }

    private IntOption(int value) {
        this.value = value;
    }

    @NotNull
    public static IntOption some(int value) {
        return new IntOption(value);
    }

    @NotNull
    public static IntOption none() {
        return None;
    }

    @Deprecated
    @NotNull
    public static IntOption of(int value) {
        return IntOption.some(value);
    }

    @Deprecated
    @NotNull
    public static IntOption of(@Nullable Integer value) {
        return IntOption.ofNullable(value);
    }

    @NotNull
    public static IntOption ofNullable(@Nullable Integer value) {
        return value == null ? None : IntOption.some(value);
    }

    @NotNull
    public static IntOption fromJava(@NotNull OptionalInt optional) {
        return optional.isPresent() ? IntOption.some(optional.getAsInt()) : IntOption.none();
    }

    public boolean isDefined() {
        return this != None;
    }

    @Override
    public boolean isEmpty() {
        return this == None;
    }

    public int get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("IntOption.None");
        }
        return this.value;
    }

    @Nullable
    public Integer getOrNull() {
        return this.isDefined() ? Integer.valueOf(this.value) : null;
    }

    public int getOrDefault(int defaultValue) {
        return this.isDefined() ? this.value : defaultValue;
    }

    public int getOrElse(@NotNull IntSupplier supplier) {
        return this.isDefined() ? this.get() : supplier.getAsInt();
    }

    public <Ex extends Throwable> int getOrThrowException(@NotNull Ex exception) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(exception);
            throw exception;
        }
        return this.value;
    }

    public <Ex extends Throwable> int getOrThrow(@NotNull Supplier<? extends Ex> supplier) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(supplier);
            throw (Throwable)supplier.get();
        }
        return this.value;
    }

    @NotNull
    public IntOption orElse(IntOption other) {
        return this.isDefined() ? this : other;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IntOption) {
            return this != None && o != None && this.value == ((IntOption)o).value;
        }
        if (o instanceof Option) {
            Option other = (Option)o;
            if (this.isEmpty()) {
                return other.isEmpty();
            }
            if (other.isEmpty()) {
                return false;
            }
            Object v = other.get();
            return v instanceof Integer && this.value == (Integer)v;
        }
        return false;
    }

    public int hashCode() {
        return this.isDefined() ? -818206074 + Integer.hashCode(this.value) : 1937147281;
    }

    public String toString() {
        return this == None ? "IntOption.None" : "IntOption[" + this.value + "]";
    }

    @Override
    @NotNull
    public IntIterator iterator() {
        return this.isDefined() ? IntIterator.of(this.value) : IntIterator.empty();
    }

    @Override
    public void forEach(@NotNull IntConsumer action) {
        if (this.isDefined()) {
            action.accept(this.value);
        }
    }

    private Object writeReplace() {
        return new Data(this == None ? null : Integer.valueOf(this.value));
    }

    private static final class Data
    implements Serializable {
        private static final long serialVersionUID = -2044232156734869349L;
        private final Integer value;

        Data(Integer value) {
            this.value = value;
        }

        Object readResolve() {
            return this.value == null ? None : IntOption.some(this.value);
        }
    }
}

