/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.control.AnyTry;
import kala.control.Try;
import kala.control.primitive.ShortOption;
import kala.function.CheckedShortSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShortTry
extends AnyTry<Short>
implements ShortTraversable,
Serializable {
    private static final long serialVersionUID = 8279218383491584792L;
    private final short value;
    private final Throwable cause;

    private ShortTry(short value, Throwable cause) {
        this.value = value;
        this.cause = cause;
    }

    @NotNull
    public static ShortTry success(short value) {
        return new ShortTry(value, null);
    }

    @NotNull
    public static ShortTry failure(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        return new ShortTry(0, exception);
    }

    @NotNull
    public static ShortTry of(@NotNull CheckedShortSupplier<?> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return ShortTry.success(supplier.getAsShortChecked());
        }
        catch (Throwable ex) {
            return ShortTry.failure(ex);
        }
    }

    @Override
    public boolean isSuccess() {
        return this.cause == null;
    }

    @Override
    public boolean isFailure() {
        return this.cause != null;
    }

    @Override
    @Deprecated
    @NotNull
    public Short getValue() {
        return this.get();
    }

    public short get() {
        if (this.isFailure()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    @Override
    @Nullable
    public Short getOrNull() {
        return this.isSuccess() ? Short.valueOf(this.get()) : null;
    }

    public ShortOption getOption() {
        return this.isSuccess() ? ShortOption.some(this.get()) : ShortOption.none();
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @NotNull
    public <Ex extends Throwable> ShortTry rethrow() throws Ex {
        if (this.isFailure()) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public <Ex extends Throwable> ShortTry rethrow(@NotNull Class<? extends Ex> type) throws Ex {
        if (type.isInstance(this.cause)) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public ShortTry rethrowFatal() {
        if (Try.isFatal(this.cause)) {
            Try.sneakyThrow(this.cause);
        }
        return this;
    }

    @Override
    @NotNull
    public ShortIterator iterator() {
        return this.isSuccess() ? ShortIterator.of(this.get()) : ShortIterator.empty();
    }

    public int hashCode() {
        if (this.isSuccess()) {
            return Short.hashCode(this.get()) + 518848667;
        }
        return this.getCause().hashCode() + 1918688519;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnyTry)) {
            return false;
        }
        AnyTry other = (AnyTry)o;
        if (this.isSuccess() && other.isSuccess()) {
            if (other instanceof ShortTry) {
                return this.get() == ((ShortTry)other).get();
            }
            if (other instanceof Try) {
                Object v = other.getValue();
                return v instanceof Short && this.get() == ((Short)v).shortValue();
            }
            return false;
        }
        if (this.isFailure() && other.isFailure()) {
            return this.getCause().equals(other.getCause());
        }
        return false;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "ShortTry.Success[" + this.get() + "]";
        }
        return "ShortTry.Failure[" + this.cause + "]";
    }
}

