/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import kala.control.Try;
import kala.function.FloatConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface CheckedFloatConsumer<Ex extends Throwable>
extends FloatConsumer {
    @Contract(value="_ -> param1", pure=true)
    public static <Ex extends Throwable> CheckedFloatConsumer<Ex> of(CheckedFloatConsumer<? extends Ex> consumer) {
        return consumer;
    }

    public void acceptChecked(float var1) throws Ex;

    @Override
    default public void accept(float value) {
        try {
            this.acceptChecked(value);
        }
        catch (Throwable e) {
            Try.sneakyThrow(e);
        }
    }

    @Deprecated
    @NotNull
    default public Try<Void> tryAccept(float value) {
        try {
            this.acceptChecked(value);
            return Try.VOID;
        }
        catch (Throwable e) {
            return Try.failure(e);
        }
    }
}

