/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.util.function.Function;
import kala.control.Try;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface CheckedFunction<T, R, Ex extends Throwable>
extends Function<T, R> {
    @Contract(value="_ -> param1", pure=true)
    public static <T, R, Ex extends Throwable> CheckedFunction<T, R, Ex> of(CheckedFunction<? super T, ? extends R, ? extends Ex> function) {
        return function;
    }

    public R applyChecked(T var1) throws Ex;

    @Override
    default public R apply(T t) {
        try {
            return this.applyChecked(t);
        }
        catch (Throwable e) {
            return Try.sneakyThrow(e);
        }
    }

    @Deprecated
    @NotNull
    default public Try<R> tryApply(T t) {
        try {
            return Try.success(this.applyChecked(t));
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }
}

